/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.radar.painter.label;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.jensoft.core.plugin.radar.Radar;
import org.jensoft.core.plugin.radar.RadarDimension;
import org.jensoft.core.plugin.radar.painter.label.AbstractRadarDimensionLabel;

public class RadarDimensionDefaultLabel
extends AbstractRadarDimensionLabel {
    private String label;
    private Color labelColor;
    private Font labelFont;
    private int offsetRadius = 30;
    private int outlineRound = 6;
    private int labelPaddingX = 10;
    private int labelPaddingY = 2;
    private Color outlineColor;
    private Stroke outlineStroke;
    private Color fillColor;
    private float[] shadeFractions;
    private Color[] shadeColors;
    private AbstractRadarDimensionLabel.Style style = AbstractRadarDimensionLabel.Style.Both;
    private Stroke defaultStroke = new BasicStroke();

    public RadarDimensionDefaultLabel(String label, Color labelColor, Font labelFont) {
        this.label = label;
        this.labelColor = labelColor;
        this.labelFont = labelFont;
    }

    public RadarDimensionDefaultLabel(String label, Color labelColor) {
        this(label, labelColor, null);
    }

    public RadarDimensionDefaultLabel(String label) {
        this(label, null, null);
    }

    public AbstractRadarDimensionLabel.Style getStyle() {
        return this.style;
    }

    public void setStyle(AbstractRadarDimensionLabel.Style style) {
        this.style = style;
    }

    public int getOutlineRound() {
        return this.outlineRound;
    }

    public void setOutlineRound(int outlineRound) {
        this.outlineRound = outlineRound;
    }

    public int getLabelPaddingX() {
        return this.labelPaddingX;
    }

    public void setLabelPaddingX(int labelPaddingX) {
        this.labelPaddingX = labelPaddingX;
    }

    public int getLabelPaddingY() {
        return this.labelPaddingY;
    }

    public void setLabelPaddingY(int labelPaddingY) {
        this.labelPaddingY = labelPaddingY;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public int getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(int offsetRadius) {
        this.offsetRadius = offsetRadius;
    }

    @Override
    protected void paintDimensionLabel(Graphics2D g2d, Radar radar, RadarDimension radarDimension) {
        if (this.label == null) {
            return;
        }
        if (this.labelFont != null) {
            g2d.setFont(this.labelFont);
        }
        FontMetrics fm = g2d.getFontMetrics();
        int widthText = fm.stringWidth(this.label);
        int heightText = fm.getHeight();
        int ascentText = fm.getAscent();
        int descentText = fm.getDescent();
        Point2D pointRef = radar.getDimensionPointAtRadius(radarDimension, radar.getRadius() + (double)this.offsetRadius);
        int x = (int)pointRef.getX();
        int y = (int)pointRef.getY();
        g2d.setColor(Color.RED);
        g2d.drawRect(x - 2, y - 2, 4, 4);
        if (radarDimension.getAngleDegree() >= 270.0 && radarDimension.getAngleDegree() <= 360.0 || radarDimension.getAngleDegree() >= 0.0 && radarDimension.getAngleDegree() <= 90.0) {
            y += fm.getAscent() / 2;
        } else {
            x -= widthText;
            y += fm.getAscent() / 2;
        }
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x - this.labelPaddingX, y - ascentText - this.labelPaddingY, widthText + 2 * this.labelPaddingX, ascentText + descentText + 2 * this.labelPaddingY, this.outlineRound, this.outlineRound);
        if (this.style == AbstractRadarDimensionLabel.Style.Fill || this.style == AbstractRadarDimensionLabel.Style.Both) {
            if (this.fillColor != null && this.shadeFractions == null) {
                g2d.setColor(this.fillColor);
                g2d.fill(rect);
            }
            if (this.fillColor == null && this.shadeFractions == null) {
                g2d.setColor(radar.getThemeColor());
                g2d.fill(rect);
            }
            Point2D.Double start2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY() + ((RectangularShape)rect).getHeight());
            Point2D.Double end2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY());
            if (this.shadeFractions != null && this.shadeColors != null && !start2.equals(end2)) {
                LinearGradientPaint p2 = new LinearGradientPaint(start2, end2, this.shadeFractions, this.shadeColors);
                g2d.setPaint(p2);
                g2d.fill(rect);
            }
        }
        if (this.style == AbstractRadarDimensionLabel.Style.Stroke || this.style == AbstractRadarDimensionLabel.Style.Both) {
            if (this.outlineColor != null) {
                g2d.setColor(this.outlineColor);
            } else {
                g2d.setColor(radar.getThemeColor().brighter());
            }
            if (this.outlineStroke != null) {
                g2d.setStroke(this.outlineStroke);
            }
            g2d.draw(rect);
        }
        g2d.setColor(radar.getThemeColor());
        g2d.setStroke(this.defaultStroke);
        g2d.setColor(radar.getThemeColor().brighter());
        if (this.labelColor != null) {
            g2d.setColor(this.labelColor);
        }
        g2d.drawString(this.label, x, y);
    }
}

