/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.ray;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.ray.Ray;
import org.jensoft.core.plugin.ray.RayEvent;
import org.jensoft.core.plugin.ray.RayGroup;
import org.jensoft.core.plugin.ray.RayListener;
import org.jensoft.core.plugin.ray.RayStack;
import org.jensoft.core.plugin.ray.StackedRay;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class RayPlugin
extends AbstractPlugin
implements AbstractPlugin.OnClickListener,
AbstractPlugin.OnEnterListener,
AbstractPlugin.OnExitListener,
AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnMoveListener,
AbstractPlugin.OnDragListener {
    private List<Ray> rays;
    private EventListenerList rayListenerList;

    public RayPlugin() {
        this.setName("RayPlugin");
        this.rays = new ArrayList<Ray>();
        this.rayListenerList = new EventListenerList();
        this.setOnMoveListener(this);
        this.setOnClickListener(this);
        this.setOnReleaseListener(this);
        this.setOnPressListener(this);
        this.setOnDragListener(this);
        this.setPriority(500);
    }

    public void addRay(Ray ray) {
        ray.setHost(this);
        this.rays.add(ray);
    }

    public void removeRay(Ray ray) {
        ray.setHost(null);
        this.rays.remove(ray);
    }

    private void checkRay(Ray ray) {
        if (ray.getRayNature() == null) {
            throw new IllegalStateException("Ray nature should be supplied");
        }
    }

    private void resolveRayGeometry() {
        for (Ray ray : this.rays) {
            this.checkRay(ray);
            if (ray instanceof StackedRay) {
                this.resolveStackedRayGeometry((StackedRay)ray);
                continue;
            }
            if (ray instanceof RayGroup) {
                this.resolveRayGroupGeometry((RayGroup)ray);
                continue;
            }
            this.resolveRayGeometry(ray);
        }
    }

    public void resolveRayComponent(Ray ray) {
        if (ray instanceof StackedRay) {
            this.resolveStackedRayGeometry((StackedRay)ray);
        } else if (ray instanceof RayGroup) {
            this.resolveRayGroupGeometry((RayGroup)ray);
        } else {
            this.resolveRayGeometry(ray);
        }
    }

    private void resolveRayGroupGeometry(RayGroup rayGroup) {
        rayGroup.copyToRays();
        List<Ray> rays = rayGroup.getRays();
        for (Ray ray : rays) {
            this.resolveRayGeometry(ray);
        }
    }

    private void resolveRayGeometry(Ray ray) {
        Projection w2d = this.getProjection();
        if (ray.getRayNature() == Ray.RayNature.XRay) {
            double centerUserX = ray.getRay();
            double centerDeviceX = w2d.userToPixel(new Point2D.Double(centerUserX, 0.0)).getX();
            double deviceRayWidth = 0.0;
            if (ray.getThicknessType() == Ray.ThicknessType.Device) {
                deviceRayWidth = ray.getThickness();
            } else {
                double left = centerUserX - ray.getThickness() / 2.0;
                Point2D pLeft = w2d.userToPixel(new Point2D.Double(left, 0.0));
                double right = centerUserX + ray.getThickness() / 2.0;
                Point2D pRight = w2d.userToPixel(new Point2D.Double(right, 0.0));
                deviceRayWidth = pRight.getX() - pLeft.getX();
            }
            double yUserRayBase = 0.0;
            if (ray.isAscent()) {
                yUserRayBase = ray.getRayBase();
            }
            if (ray.isDescent()) {
                yUserRayBase = ray.getRayBase() - ray.getRayValue();
            }
            double yDeviceRayBase = w2d.userToPixel(new Point2D.Double(0.0, yUserRayBase)).getY();
            double yUserRayFleche = 0.0;
            if (ray.isAscent()) {
                yUserRayFleche = ray.getRayBase() + ray.getRayValue();
            }
            if (ray.isDescent()) {
                yUserRayFleche = ray.getRayBase();
            }
            double yDeviceRayFleche = w2d.userToPixel(new Point2D.Double(0.0, yUserRayFleche)).getY();
            double x = centerDeviceX - deviceRayWidth / 2.0;
            double y = yDeviceRayFleche;
            double width = deviceRayWidth;
            double height = Math.abs(yDeviceRayFleche - yDeviceRayBase);
            Rectangle2D.Double rayShape = new Rectangle2D.Double(x, y, width, height);
            ray.setRayShape(rayShape);
        } else if (ray.getRayNature() == Ray.RayNature.YRay) {
            double centerUserY = ray.getRay();
            double centerDeviceY = w2d.userToPixel(new Point2D.Double(0.0, centerUserY)).getY();
            double deviceRayHeight = 0.0;
            if (ray.getThicknessType() == Ray.ThicknessType.Device) {
                deviceRayHeight = ray.getThickness();
            } else {
                double top = centerUserY - ray.getThickness() / 2.0;
                Point2D pTop = w2d.userToPixel(new Point2D.Double(0.0, top));
                double bottom = centerUserY + ray.getThickness() / 2.0;
                Point2D pBottom = w2d.userToPixel(new Point2D.Double(0.0, bottom));
                deviceRayHeight = Math.abs(pTop.getY() - pBottom.getY());
            }
            double xUserRayBase = 0.0;
            if (ray.isAscent()) {
                xUserRayBase = ray.getRayBase();
            }
            if (ray.isDescent()) {
                xUserRayBase = ray.getRayBase() - ray.getRayValue();
            }
            double xDeviceRayBase = w2d.userToPixel(new Point2D.Double(xUserRayBase, 0.0)).getX();
            double xUserRayFleche = 0.0;
            if (ray.isAscent()) {
                xUserRayFleche = ray.getRayBase() - ray.getRayValue();
            }
            if (ray.isDescent()) {
                xUserRayFleche = ray.getRayBase();
            }
            double xDeviceRayFleche = w2d.userToPixel(new Point2D.Double(xUserRayFleche, 0.0)).getX();
            double x = xDeviceRayBase;
            double y = centerDeviceY - deviceRayHeight / 2.0;
            double width = Math.abs(xDeviceRayFleche - xDeviceRayBase);
            double height = deviceRayHeight;
            Rectangle2D.Double rayShape = new Rectangle2D.Double(x, y, width, height);
            ray.setRayShape(rayShape);
        }
    }

    private void resolveStackedRayGeometry(StackedRay stackedRay) {
        block29: {
            Projection w2d;
            block28: {
                w2d = this.getProjection();
                stackedRay.normalize();
                if (stackedRay.getRayNature() != Ray.RayNature.XRay) break block28;
                double centerUserX = stackedRay.getRay();
                double centerDeviceX = w2d.userToPixel(new Point2D.Double(centerUserX, 0.0)).getX();
                double deviceRayWidth = 0.0;
                if (stackedRay.getThicknessType() == Ray.ThicknessType.Device) {
                    deviceRayWidth = stackedRay.getThickness();
                } else {
                    double left = centerUserX - stackedRay.getThickness() / 2.0;
                    Point2D pLeft = w2d.userToPixel(new Point2D.Double(left, 0.0));
                    double right = centerUserX + stackedRay.getThickness() / 2.0;
                    Point2D pRight = w2d.userToPixel(new Point2D.Double(right, 0.0));
                    deviceRayWidth = pRight.getX() - pLeft.getX();
                }
                double yUserRayBase = 0.0;
                if (stackedRay.isAscent()) {
                    yUserRayBase = stackedRay.getRayBase();
                }
                if (stackedRay.isDescent()) {
                    yUserRayBase = stackedRay.getRayBase() - stackedRay.getRayValue();
                }
                double yDeviceRayBase = w2d.userToPixel(new Point2D.Double(0.0, yUserRayBase)).getY();
                double yUserRayFleche = 0.0;
                if (stackedRay.isAscent()) {
                    yUserRayFleche = stackedRay.getRayBase() + stackedRay.getRayValue();
                }
                if (stackedRay.isDescent()) {
                    yUserRayFleche = stackedRay.getRayBase();
                }
                double yDeviceRayFleche = w2d.userToPixel(new Point2D.Double(0.0, yUserRayFleche)).getY();
                double x = centerDeviceX - deviceRayWidth / 2.0;
                double y = yDeviceRayFleche;
                double width = deviceRayWidth;
                double height = Math.abs(yDeviceRayFleche - yDeviceRayBase);
                Rectangle2D.Double rayShape = new Rectangle2D.Double(x, y, width, height);
                stackedRay.setRayShape(rayShape);
                for (RayStack s : stackedRay.getStacks()) {
                    Ray rayStack = new Ray();
                    rayStack.setName(s.getStackName());
                    rayStack.setRayNature(stackedRay.getRayNature());
                    rayStack.setThickness(stackedRay.getThickness());
                    rayStack.setThicknessType(stackedRay.getThicknessType());
                    rayStack.setRay(stackedRay.getRay());
                    rayStack.setRayBase(stackedRay.getStackBase(s));
                    rayStack.setThemeColor(s.getThemeColor());
                    rayStack.setRayFill(s.getRayFill());
                    rayStack.setRayDraw(s.getRayDraw());
                    rayStack.setRayEffect(s.getRayEffect());
                    if (stackedRay.isAscent()) {
                        rayStack.setAscentValue(s.getNormalizedValue());
                    } else if (stackedRay.isDescent()) {
                        rayStack.setDescentValue(s.getNormalizedValue());
                    }
                    double yUserStackRayBase = 0.0;
                    if (stackedRay.isAscent()) {
                        yUserStackRayBase = stackedRay.getStackBase(s);
                    }
                    if (stackedRay.isDescent()) {
                        yUserStackRayBase = stackedRay.getStackBase(s) - s.getNormalizedValue();
                    }
                    double yDeviceStackRayBase = w2d.userToPixel(new Point2D.Double(0.0, yUserStackRayBase)).getY();
                    double yUserStackRayFleche = 0.0;
                    if (stackedRay.isAscent()) {
                        yUserStackRayFleche = stackedRay.getStackBase(s) + s.getNormalizedValue();
                    }
                    if (stackedRay.isDescent()) {
                        yUserStackRayFleche = stackedRay.getStackBase(s);
                    }
                    double yDeviceStackRayFleche = w2d.userToPixel(new Point2D.Double(0.0, yUserStackRayFleche)).getY();
                    double stackx = centerDeviceX - deviceRayWidth / 2.0;
                    double stacky = yDeviceStackRayFleche;
                    double stackwidth = deviceRayWidth;
                    double stackheight = Math.abs(yDeviceStackRayFleche - yDeviceStackRayBase);
                    Rectangle2D.Double stackRayShape = new Rectangle2D.Double(stackx, stacky, stackwidth, stackheight);
                    rayStack.setRayShape(stackRayShape);
                    s.setRay(rayStack);
                }
                break block29;
            }
            if (stackedRay.getRayNature() != Ray.RayNature.YRay) break block29;
            double centerUserY = stackedRay.getRay();
            double centerDeviceY = w2d.userToPixel(new Point2D.Double(0.0, centerUserY)).getY();
            double deviceRayHeight = 0.0;
            if (stackedRay.getThicknessType() == Ray.ThicknessType.Device) {
                deviceRayHeight = stackedRay.getThickness();
            } else {
                double top = centerUserY - stackedRay.getThickness() / 2.0;
                Point2D pTop = w2d.userToPixel(new Point2D.Double(0.0, top));
                double bottom = centerUserY + stackedRay.getThickness() / 2.0;
                Point2D pBottom = w2d.userToPixel(new Point2D.Double(0.0, bottom));
                deviceRayHeight = Math.abs(pTop.getY() - pBottom.getY());
            }
            double xUserRayBase = 0.0;
            if (stackedRay.isAscent()) {
                xUserRayBase = stackedRay.getRayBase();
            }
            if (stackedRay.isDescent()) {
                xUserRayBase = stackedRay.getRayBase() - stackedRay.getRayValue();
            }
            double xDeviceRayBase = w2d.userToPixel(new Point2D.Double(xUserRayBase, 0.0)).getX();
            double xUserRayFleche = 0.0;
            if (stackedRay.isAscent()) {
                xUserRayFleche = stackedRay.getRayBase() - stackedRay.getRayValue();
            }
            if (stackedRay.isDescent()) {
                xUserRayFleche = stackedRay.getRayBase();
            }
            double xDeviceRayFleche = w2d.userToPixel(new Point2D.Double(xUserRayFleche, 0.0)).getX();
            double x = xDeviceRayBase;
            double y = centerDeviceY - deviceRayHeight / 2.0;
            double width = Math.abs(xDeviceRayFleche - xDeviceRayBase);
            double height = deviceRayHeight;
            Rectangle2D.Double rayShape = new Rectangle2D.Double(x, y, width, height);
            stackedRay.setRayShape(rayShape);
            for (RayStack s : stackedRay.getStacks()) {
                Ray rayStack = new Ray();
                rayStack.setName(s.getStackName());
                rayStack.setRayNature(stackedRay.getRayNature());
                rayStack.setThickness(stackedRay.getThickness());
                rayStack.setThicknessType(stackedRay.getThicknessType());
                rayStack.setRay(stackedRay.getRay());
                rayStack.setRayBase(stackedRay.getStackBase(s));
                rayStack.setThemeColor(s.getThemeColor());
                rayStack.setRayFill(s.getRayFill());
                rayStack.setRayDraw(s.getRayDraw());
                rayStack.setRayEffect(s.getRayEffect());
                if (stackedRay.isAscent()) {
                    rayStack.setAscentValue(s.getNormalizedValue());
                } else if (stackedRay.isDescent()) {
                    rayStack.setDescentValue(s.getNormalizedValue());
                }
                double xUserStackRayBase = 0.0;
                if (stackedRay.isAscent()) {
                    xUserStackRayBase = stackedRay.getStackBase(s);
                }
                if (stackedRay.isDescent()) {
                    xUserStackRayBase = stackedRay.getStackBase(s) - s.getNormalizedValue();
                }
                double xDeviceStackRayBase = w2d.userToPixel(new Point2D.Double(xUserStackRayBase, 0.0)).getX();
                double xUserStackRayFleche = 0.0;
                if (stackedRay.isAscent()) {
                    xUserStackRayFleche = stackedRay.getStackBase(s) - s.getNormalizedValue();
                }
                if (stackedRay.isDescent()) {
                    xUserStackRayFleche = stackedRay.getStackBase(s);
                }
                double xDeviceStackRayFleche = w2d.userToPixel(new Point2D.Double(xUserStackRayFleche, 0.0)).getX();
                double stackx = xDeviceStackRayBase;
                double stacky = centerDeviceY - deviceRayHeight / 2.0;
                double stackwidth = Math.abs(xDeviceStackRayFleche - xDeviceStackRayBase);
                double stackheight = deviceRayHeight;
                Rectangle2D.Double stackRayShape = new Rectangle2D.Double(stackx, stacky, stackwidth, stackheight);
                rayStack.setRayShape(stackRayShape);
                s.setRay(rayStack);
            }
        }
    }

    private void paintRay(View v2d, Graphics2D g2d, Ray ray, ViewPart viewPart, PaintRequest paintRequest) {
        ray.setHost(this);
        if (paintRequest == PaintRequest.RayLayer) {
            if (ray.getRayFill() != null) {
                ray.getRayFill().paintRay(g2d, ray, viewPart);
            }
            if (ray.getRayEffect() != null) {
                ray.getRayEffect().paintRay(g2d, ray, viewPart);
            }
            if (ray.getRayDraw() != null) {
                ray.getRayDraw().paintRay(g2d, ray, viewPart);
            }
        } else if (ray.getRayLabel() != null) {
            ray.getRayLabel().paintRay(g2d, ray, viewPart);
        }
    }

    private void paintStackedRay(View v2d, Graphics2D g2d, StackedRay stackedRay, ViewPart viewPart, PaintRequest paintRequest) {
        for (RayStack s : stackedRay.getStacks()) {
            Ray stackRay = s.getRay();
            this.paintRay(v2d, g2d, stackRay, viewPart, paintRequest);
        }
        this.paintRay(v2d, g2d, stackedRay, viewPart, paintRequest);
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        this.resolveRayGeometry();
        if (viewPart == ViewPart.Device) {
            List<Ray> rays;
            RayGroup group;
            for (Ray ray : this.rays) {
                if (ray instanceof RayGroup) {
                    group = (RayGroup)ray;
                    rays = group.getRays();
                    for (Ray r : rays) {
                        if (r instanceof StackedRay && !(ray instanceof RayGroup)) {
                            this.paintStackedRay(v2d, g2d, (StackedRay)r, viewPart, PaintRequest.RayLayer);
                            continue;
                        }
                        if (!(r instanceof Ray) || r instanceof RayGroup) continue;
                        this.paintRay(v2d, g2d, r, viewPart, PaintRequest.RayLayer);
                    }
                    continue;
                }
                if (ray instanceof StackedRay) {
                    this.paintStackedRay(v2d, g2d, (StackedRay)ray, viewPart, PaintRequest.RayLayer);
                    continue;
                }
                this.paintRay(v2d, g2d, ray, viewPart, PaintRequest.RayLayer);
            }
            for (Ray ray : this.rays) {
                if (ray instanceof RayGroup) {
                    group = (RayGroup)ray;
                    rays = group.getRays();
                    for (Ray r : rays) {
                        if (r instanceof StackedRay && !(ray instanceof RayGroup)) {
                            this.paintStackedRay(v2d, g2d, (StackedRay)r, viewPart, PaintRequest.LabelLayer);
                            continue;
                        }
                        if (!(r instanceof Ray) || r instanceof RayGroup) continue;
                        this.paintRay(v2d, g2d, r, viewPart, PaintRequest.LabelLayer);
                    }
                    continue;
                }
                if (ray instanceof StackedRay) {
                    this.paintStackedRay(v2d, g2d, (StackedRay)ray, viewPart, PaintRequest.LabelLayer);
                    continue;
                }
                this.paintRay(v2d, g2d, ray, viewPart, PaintRequest.LabelLayer);
            }
        } else {
            this.paintRayAxisLabel(g2d, viewPart);
        }
    }

    protected void paintRayAxisLabel(Graphics2D g2d, ViewPart viewPart) {
        for (Ray ray : this.rays) {
            ray.setHost(this);
            if (ray instanceof RayGroup) {
                RayGroup group = (RayGroup)ray;
                if (group.getRayAxisLabel() != null) {
                    group.getRayAxisLabel().paintRay(g2d, ray, viewPart);
                }
                List<Ray> rays = group.getRays();
                for (Ray r : rays) {
                    ray.setHost(this);
                    if (r instanceof RayGroup || r.getRayAxisLabel() == null) continue;
                    r.getRayAxisLabel().paintRay(g2d, r, viewPart);
                }
                continue;
            }
            if (ray.getRayAxisLabel() == null) continue;
            ray.getRayAxisLabel().paintRay(g2d, ray, viewPart);
        }
    }

    public void addRayListener(RayListener listener) {
        this.rayListenerList.add(RayListener.class, listener);
    }

    public void removeRayListener(RayListener listener) {
        this.rayListenerList.remove(RayListener.class, listener);
    }

    @Override
    public void onRelease(MouseEvent me) {
        for (Ray ray : this.rays) {
            if (ray.getRayShape() == null || !ray.getRayShape().contains(me.getX(), me.getY())) continue;
            this.fireRayReleased(ray);
        }
    }

    @Override
    public void onPress(MouseEvent me) {
        for (Ray ray : this.rays) {
            if (ray.getRayShape() == null || !ray.getRayShape().contains(me.getX(), me.getY())) continue;
            this.fireRayPressed(ray);
        }
    }

    @Override
    public void onExit(MouseEvent me) {
    }

    @Override
    public void onEnter(MouseEvent me) {
    }

    @Override
    public void onClick(MouseEvent me) {
        for (Ray ray : this.rays) {
            if (!ray.getRayShape().contains(me.getX(), me.getY())) continue;
            this.fireRayClicked(ray);
        }
    }

    @Override
    public void onMove(MouseEvent me) {
        for (Ray ray : this.rays) {
            if (ray instanceof StackedRay) {
                this.rayEnterExitTracker(ray, me.getX(), me.getY());
                StackedRay stackedRay = (StackedRay)ray;
                List<RayStack> rayStacks = stackedRay.getStacks();
                for (RayStack rayStack : rayStacks) {
                    Ray subRay = rayStack.getRay();
                    this.rayEnterExitTracker(subRay, me.getX(), me.getY());
                }
                continue;
            }
            this.rayEnterExitTracker(ray, me.getX(), me.getY());
        }
    }

    private void rayEnterExitTracker(Ray ray, int x, int y) {
        if (ray.getRayShape() == null) {
            return;
        }
        if (ray.getRayShape().contains(x, y) && !ray.isLockEnter()) {
            ray.lockEnter();
            this.fireRayEntered(ray);
        } else if (!ray.getRayShape().contains(x, y) && ray.isLockEnter()) {
            ray.unlockEnter();
            this.fireRayExited(ray);
        }
    }

    @Override
    public void onDrag(MouseEvent me) {
        for (Ray ray : this.rays) {
            if (ray instanceof StackedRay) {
                this.rayEnterExitTracker(ray, me.getX(), me.getY());
                StackedRay stackedRay = (StackedRay)ray;
                List<RayStack> rayStacks = stackedRay.getStacks();
                for (RayStack rayStack : rayStacks) {
                    Ray subRay = rayStack.getRay();
                    this.rayEnterExitTracker(subRay, me.getX(), me.getY());
                }
                continue;
            }
            this.rayEnterExitTracker(ray, me.getX(), me.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRayEntered(Ray ray) {
        Object[] listeners;
        Object[] objectArray = listeners = this.rayListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != RayListener.class) continue;
                ((RayListener)listeners[i + 1]).rayEntered(new RayEvent(ray));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRayExited(Ray ray) {
        Object[] listeners;
        Object[] objectArray = listeners = this.rayListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != RayListener.class) continue;
                ((RayListener)listeners[i + 1]).rayExited(new RayEvent(ray));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRayClicked(Ray ray) {
        Object[] listeners;
        Object[] objectArray = listeners = this.rayListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != RayListener.class) continue;
                ((RayListener)listeners[i + 1]).rayClicked(new RayEvent(ray));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRayPressed(Ray ray) {
        Object[] listeners;
        Object[] objectArray = listeners = this.rayListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != RayListener.class) continue;
                ((RayListener)listeners[i + 1]).rayPressed(new RayEvent(ray));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRayReleased(Ray ray) {
        Object[] listeners;
        Object[] objectArray = listeners = this.rayListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != RayListener.class) continue;
                ((RayListener)listeners[i + 1]).rayReleased(new RayEvent(ray));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static enum PaintRequest {
        RayLayer,
        LabelLayer;

    }
}

