/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.ray;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.Toolkit;
import org.jensoft.core.plugin.ray.Ray;
import org.jensoft.core.plugin.ray.RayStack;
import org.jensoft.core.plugin.ray.RayView;
import org.jensoft.core.plugin.ray.StackedRay;
import org.jensoft.core.plugin.ray.painter.draw.RayDefaultDraw;
import org.jensoft.core.plugin.ray.painter.effect.RayEffect1;
import org.jensoft.core.plugin.ray.painter.fill.RayFill1;

public class RayToolkit
extends Toolkit {
    public static RayView createCompatibleView(double minx, double maxx, double miny, double maxy) {
        RayView rayView = new RayView(minx, maxx, miny, maxy);
        return rayView;
    }

    public static Ray createRay(String name, Color themeColor, Ray.RayNature rayNature, double rayLocation, Ray.RayInflate rayInflate, double rayBase, double rayInflateValue, Ray.ThicknessType thicknessType, double thickness) {
        Ray ray = new Ray();
        ray.setName(name);
        ray.setRayNature(rayNature);
        ray.setRay(rayLocation);
        ray.setThicknessType(thicknessType);
        ray.setThickness(thickness);
        ray.setRayBase(rayBase);
        if (rayInflate == Ray.RayInflate.Ascent) {
            ray.setAscentValue(rayInflateValue);
        }
        if (rayInflate == Ray.RayInflate.Descent) {
            ray.setDescentValue(rayInflateValue);
        }
        ray.setThemeColor(themeColor);
        ray.setRayDraw(new RayDefaultDraw(Color.WHITE));
        ray.setRayFill(new RayFill1());
        ray.setRayEffect(new RayEffect1());
        return ray;
    }

    public static Ray createXRayAscent(String name, Color themeColor, double rayLocation, double rayBase, double ascentValue, Ray.ThicknessType thicknessType, double thickness) {
        return RayToolkit.createRay(name, themeColor, Ray.RayNature.XRay, rayLocation, Ray.RayInflate.Ascent, rayBase, ascentValue, thicknessType, thickness);
    }

    public static Ray createXRayDescent(String name, Color themeColor, double rayLocation, double rayBase, double descentValue, Ray.ThicknessType thicknessType, double thickness) {
        return RayToolkit.createRay(name, themeColor, Ray.RayNature.XRay, rayLocation, Ray.RayInflate.Descent, rayBase, descentValue, thicknessType, thickness);
    }

    public static Ray createYRayAscent(String name, Color themeColor, double rayLocation, double rayBase, double ascentValue, Ray.ThicknessType thicknessType, double thickness) {
        return RayToolkit.createRay(name, themeColor, Ray.RayNature.YRay, rayLocation, Ray.RayInflate.Ascent, rayBase, ascentValue, thicknessType, thickness);
    }

    public static Ray createYRayDescent(String name, Color themeColor, double rayLocation, double rayBase, double descentValue, Ray.ThicknessType thicknessType, double thickness) {
        return RayToolkit.createRay(name, themeColor, Ray.RayNature.YRay, rayLocation, Ray.RayInflate.Descent, rayBase, descentValue, thicknessType, thickness);
    }

    public static StackedRay createStackedRay(String name, Color themeColor, Ray.RayNature rayNature, double rayLocation, Ray.RayInflate rayInflate, double rayBase, double rayInflateValue, Ray.ThicknessType thicknessType, double thickness) {
        StackedRay sray = new StackedRay();
        sray.setName(name);
        sray.setRayNature(rayNature);
        sray.setRay(rayLocation);
        sray.setThicknessType(thicknessType);
        sray.setThickness(thickness);
        sray.setRayBase(rayBase);
        if (rayInflate == Ray.RayInflate.Ascent) {
            sray.setAscentValue(rayInflateValue);
        }
        if (rayInflate == Ray.RayInflate.Descent) {
            sray.setDescentValue(rayInflateValue);
        }
        sray.setThemeColor(themeColor);
        sray.setRayDraw(new RayDefaultDraw(Color.WHITE));
        return sray;
    }

    public static StackedRay createStackedRay(String name, Color themeColor, Ray.RayNature rayNature, double rayLocation, Ray.RayInflate rayInflate, double rayBase, double rayInflateValue, Ray.ThicknessType thicknessType, double thickness, RayStack ... stacks) {
        StackedRay sray = RayToolkit.createStackedRay(name, themeColor, rayNature, rayLocation, rayInflate, rayBase, rayInflateValue, thicknessType, thickness);
        for (int i = 0; i < stacks.length; ++i) {
            sray.addStack(stacks[i]);
        }
        return sray;
    }

    public static StackedRay createStackedRay(String name, Color themeColor, Ray.RayNature rayNature, double rayLocation, Ray.RayInflate rayInflate, double rayBase, double rayInflateValue, Ray.ThicknessType thicknessType, double thickness, List<RayStack> stacks) {
        StackedRay sray = RayToolkit.createStackedRay(name, themeColor, rayNature, rayLocation, rayInflate, rayBase, rayInflateValue, thicknessType, thickness);
        for (int i = 0; i < stacks.size(); ++i) {
            sray.addStack(stacks.get(i));
        }
        return sray;
    }

    public static final RayStack createStack(String name, Color themeColor, double proportionValue) {
        if (proportionValue < 0.0) {
            throw new IllegalArgumentException("stack proportion value should be greater than 0");
        }
        RayStack stack = new RayStack(name, themeColor, proportionValue);
        return stack;
    }

    public static final List<RayStack> createStacks(String[] names, Color[] themeColors, double[] proportionValues) {
        if (names.length != themeColors.length || names.length != proportionValues.length) {
            throw new IllegalArgumentException("properties array length does not match !");
        }
        ArrayList<RayStack> stacks = new ArrayList<RayStack>();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            stacks.add(RayToolkit.createStack(names[i], themeColors[i], proportionValues[i]));
        }
        return stacks;
    }
}

