/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.ray.painter.axis;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import org.jensoft.core.plugin.ray.Ray;
import org.jensoft.core.plugin.ray.RayGroup;
import org.jensoft.core.plugin.ray.RayPlugin;
import org.jensoft.core.plugin.ray.painter.axis.AbstractRayAxisLabel;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class RayDefaultAxisLabel
extends AbstractRayAxisLabel {
    private String symbol;
    private Color symbolColor;
    private Font symbolFont;
    private int offsetX = 0;
    private int offsetY = 0;
    private int internalMarginX = 4;
    private int internalMarginY = 4;
    private int round = 10;
    private Color drawColor;
    private Color fillColor;

    public RayDefaultAxisLabel() {
    }

    public RayDefaultAxisLabel(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public RayDefaultAxisLabel(String symbol, Color symbolColor) {
        this.symbol = symbol;
        this.symbolColor = symbolColor;
    }

    public RayDefaultAxisLabel(String symbol, Color symbolColor, int offsetX, int offsetY) {
        this.symbol = symbol;
        this.symbolColor = symbolColor;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public Color getSymbolColor() {
        return this.symbolColor;
    }

    public void setSymbolColor(Color symbolColor) {
        this.symbolColor = symbolColor;
    }

    public Font getSymbolFont() {
        return this.symbolFont;
    }

    public void setSymbolFont(Font symbolFont) {
        this.symbolFont = symbolFont;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public int getInternalMarginX() {
        return this.internalMarginX;
    }

    public void setInternalMarginX(int internalMarginX) {
        this.internalMarginX = internalMarginX;
    }

    public int getInternalMarginY() {
        return this.internalMarginY;
    }

    public void setInternalMarginY(int internalMarginY) {
        this.internalMarginY = internalMarginY;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    @Override
    public void paintRayAxisLabel(Graphics2D g2d, Ray ray, ViewPart viewPart) {
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        if (ray.getRayNature() == Ray.RayNature.XRay) {
            this.paintXRayAxisLabel(g2d, ray, viewPart);
        }
        if (ray.getRayNature() == Ray.RayNature.YRay) {
            this.paintYRayAxisLabel(g2d, ray, viewPart);
        }
    }

    private void paintXRayAxisLabel(Graphics2D g2d, Ray ray, ViewPart viewPart) {
        RayPlugin bsp = ray.getHost();
        View v2d = ray.getHost().getProjection().getView();
        if (this.symbolFont == null) {
            this.setSymbolFont(new Font("Dialog", 0, 12));
        }
        g2d.setFont(this.getSymbolFont());
        FontMetrics fm = g2d.getFontMetrics();
        if (viewPart == ViewPart.South) {
            int margin = v2d.getPlaceHolderAxisWest();
            if (ray instanceof Ray && !(ray instanceof RayGroup)) {
                Ray r = ray;
                String symbol = this.getSymbol();
                if (symbol == null) {
                    symbol = r.getName();
                }
                if (symbol != null) {
                    double barWidth = ray.getRayShape().getWidth();
                    int symbolWidth = fm.stringWidth(symbol);
                    float pt = (float)(ray.getRayShape().getX() + (double)margin + barWidth / 2.0 - (double)(symbolWidth / 2));
                    int x = (int)(pt + (float)this.offsetX);
                    int y = fm.getAscent() + this.offsetY;
                    RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(x - this.internalMarginX, y - fm.getAscent() - this.internalMarginY, symbolWidth + 2 * this.internalMarginX, fm.getHeight() + 2 * this.internalMarginY, this.round, this.round);
                    if (this.fillColor != null) {
                        g2d.setColor(this.fillColor);
                        g2d.fill(roundRect);
                    }
                    if (this.drawColor != null) {
                        g2d.setColor(this.drawColor);
                        g2d.draw(roundRect);
                    }
                    if (this.getSymbolColor() != null) {
                        g2d.setColor(this.getSymbolColor());
                    } else {
                        g2d.setColor(ray.getThemeColor());
                    }
                    g2d.drawString(symbol, x, y);
                }
            }
        }
    }

    private void paintYRayAxisLabel(Graphics2D g2d, Ray bar, ViewPart viewPart) {
        View v2d = bar.getHost().getProjection().getView();
        if (this.symbolFont == null) {
            this.setSymbolFont(new Font("Dialog", 0, 12));
        }
        g2d.setFont(this.getSymbolFont());
        FontMetrics fm = g2d.getFontMetrics();
        if (viewPart == ViewPart.West) {
            int margin = v2d.getPlaceHolderAxisWest();
            if (bar instanceof Ray && !(bar instanceof RayGroup)) {
                String symbol = this.getSymbol();
                if (symbol == null) {
                    symbol = bar.getName();
                }
                double barHeight = bar.getRayShape().getHeight();
                g2d.setColor(bar.getThemeColor());
                if (symbol != null) {
                    int symbolWidth = fm.stringWidth(symbol);
                    float pt = (float)(bar.getRayShape().getY() + barHeight / 2.0 + (double)(fm.getAscent() / 2));
                    int x = margin - symbolWidth - this.internalMarginX + this.offsetX - 4;
                    int y = (int)(pt + (float)this.offsetY);
                    RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(x - this.internalMarginX, y - fm.getAscent() - this.internalMarginY, symbolWidth + 2 * this.internalMarginX, fm.getHeight() + 2 * this.internalMarginY, this.round, this.round);
                    if (this.fillColor != null) {
                        g2d.setColor(this.fillColor);
                        g2d.fill(roundRect);
                    }
                    if (this.drawColor != null) {
                        g2d.setColor(this.drawColor);
                        g2d.draw(roundRect);
                    }
                    if (this.getSymbolColor() != null) {
                        g2d.setColor(this.getSymbolColor());
                    } else {
                        g2d.setColor(bar.getThemeColor());
                    }
                    g2d.drawString(symbol, x, y);
                }
            }
        }
    }
}

