/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.ray.painter.effect;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.plugin.ray.Ray;
import org.jensoft.core.plugin.ray.painter.effect.AbstractRayEffect;

public class RayEffect1
extends AbstractRayEffect {
    @Override
    public void paintRayEffect(Graphics2D g2d, Ray ray) {
        if (ray.getRayNature() == Ray.RayNature.XRay) {
            this.fillXRay(g2d, ray);
        }
        if (ray.getRayNature() == Ray.RayNature.YRay) {
            this.fillYRay(g2d, ray);
        }
    }

    private void fillXRay(Graphics2D g2d, Ray ray) {
        Rectangle2D boun2D2 = ray.getRayShape();
        Rectangle2D.Double shapeEffect = new Rectangle2D.Double(boun2D2.getX(), boun2D2.getY(), boun2D2.getWidth() / 2.0, boun2D2.getHeight());
        Point2D.Double start = null;
        Point2D.Double end = null;
        if (ray.isAscent()) {
            start = new Point2D.Double(boun2D2.getX(), boun2D2.getY());
            end = new Point2D.Double(boun2D2.getX() + boun2D2.getWidth(), boun2D2.getY() + boun2D2.getHeight());
        } else if (ray.isDescent()) {
            start = new Point2D.Double(boun2D2.getX(), boun2D2.getY());
            end = new Point2D.Double(boun2D2.getX(), boun2D2.getY() + boun2D2.getHeight());
        }
        float[] dist = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{new Color(255, 255, 255, 120), new Color(255, 255, 255, 80)};
        LinearGradientPaint p2 = new LinearGradientPaint(start, end, dist, colors);
        g2d.setPaint(p2);
        g2d.fill(shapeEffect);
    }

    private void fillYRay(Graphics2D g2d, Ray ray) {
        Rectangle2D boun2D2 = ray.getRayShape();
        Rectangle2D.Double shapeEffect = new Rectangle2D.Double(boun2D2.getX(), boun2D2.getY(), boun2D2.getWidth(), boun2D2.getHeight() / 2.0);
        Point2D.Double start = null;
        Point2D.Double end = null;
        if (ray.isAscent()) {
            start = new Point2D.Double(boun2D2.getX(), boun2D2.getY());
            end = new Point2D.Double(boun2D2.getX(), boun2D2.getY() + boun2D2.getHeight() / 2.0);
        } else if (ray.isDescent()) {
            start = new Point2D.Double(boun2D2.getX(), boun2D2.getY());
            end = new Point2D.Double(boun2D2.getX(), boun2D2.getY() + boun2D2.getHeight() / 2.0);
        }
        float[] dist = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{new Color(255, 255, 255, 120), new Color(255, 255, 255, 80)};
        if (!start.equals(end)) {
            LinearGradientPaint p2 = new LinearGradientPaint(start, end, dist, colors);
            g2d.setPaint(p2);
            g2d.fill(shapeEffect);
        }
    }
}

