/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.ray.painter.fill;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.plugin.ray.Ray;
import org.jensoft.core.plugin.ray.painter.fill.AbstractRayFill;

public class RayFill2
extends AbstractRayFill {
    @Override
    public void paintRayFill(Graphics2D g2d, Ray ray) {
        if (ray.getRayNature() == Ray.RayNature.XRay) {
            this.fillXRay(g2d, ray);
        }
        if (ray.getRayNature() == Ray.RayNature.YRay) {
            this.fillYRay(g2d, ray);
        }
    }

    private void fillXRay(Graphics2D g2d, Ray bar) {
        Rectangle2D boun2D = bar.getRayShape().getBounds2D();
        Point2D.Double start = new Point2D.Double(boun2D.getX(), boun2D.getCenterY());
        Point2D.Double end = new Point2D.Double(boun2D.getX() + boun2D.getWidth(), boun2D.getCenterY());
        float[] dist = new float[]{0.0f, 0.5f, 1.0f};
        Color cBase = bar.getThemeColor();
        Color brighther1 = ColorPalette.brighter(cBase, 0.8f);
        Color[] colors = new Color[]{cBase, brighther1, cBase};
        LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
        g2d.setPaint(p);
        g2d.fill(bar.getRayShape());
    }

    private void fillYRay(Graphics2D g2d, Ray ray) {
        Color cBase = ray.getThemeColor();
        Color brighther1 = ColorPalette.brighter(cBase, 0.8f);
        Rectangle2D boun2D = ray.getRayShape().getBounds2D();
        Point2D.Double start = new Point2D.Double(boun2D.getCenterX(), boun2D.getY());
        Point2D.Double end = new Point2D.Double(boun2D.getCenterX(), boun2D.getY() + boun2D.getHeight());
        float[] dist = new float[]{0.0f, 0.5f, 1.0f};
        Color[] colors = new Color[]{cBase, brighther1, cBase};
        LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
        g2d.setPaint(p);
        g2d.fill(ray.getRayShape());
    }
}

