/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.ray.painter.label;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import org.jensoft.core.plugin.ray.Ray;
import org.jensoft.core.plugin.ray.painter.label.AbstractRayLabel;

public class RayRelativeLabel
extends AbstractRayLabel {
    private VerticalAlignment verticalAlignment = VerticalAlignment.Middle;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.Middle;
    private Font font;
    private Color drawColor;
    private Color fillColor;
    private DecimalFormat decimalFormat = new DecimalFormat("##.00");
    private String label;
    private Color labelColor;
    private int marginExternalX = 5;
    private int marginExternalY = 5;
    private int marginInternalX = 2;
    private int marginInternalY = 2;
    private int round = 6;
    float alpha = 1.0f;

    public RayRelativeLabel() {
    }

    public RayRelativeLabel(VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment, Color drawColor, Color fillColor, String label, Color labelColor) {
        this.verticalAlignment = verticalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        this.drawColor = drawColor;
        this.fillColor = fillColor;
        this.label = label;
        this.labelColor = labelColor;
    }

    public RayRelativeLabel(Color drawColor, Color fillColor, Color labelColor) {
        this.drawColor = drawColor;
        this.fillColor = fillColor;
        this.labelColor = labelColor;
    }

    public RayRelativeLabel(VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment, Color drawColor, Color fillColor, Color labelColor) {
        this.verticalAlignment = verticalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        this.drawColor = drawColor;
        this.fillColor = fillColor;
        this.labelColor = labelColor;
    }

    public RayRelativeLabel(VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment, Color drawColor, Color fillColor, Color labelColor, float alpha) {
        this(verticalAlignment, horizontalAlignment, drawColor, fillColor, labelColor);
        this.alpha = alpha;
    }

    public RayRelativeLabel(String label, Color labelColor, Font font) {
        this.label = label;
        this.labelColor = labelColor;
        this.font = font;
    }

    public RayRelativeLabel(VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.horizontalAlignment = horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getMarginExternalX() {
        return this.marginExternalX;
    }

    public void setMarginExternalX(int marginExternalX) {
        this.marginExternalX = marginExternalX;
    }

    public int getMarginExternalY() {
        return this.marginExternalY;
    }

    public void setMarginExternalY(int marginExternalY) {
        this.marginExternalY = marginExternalY;
    }

    public int getMarginInternalX() {
        return this.marginInternalX;
    }

    public void setMarginInternalX(int marginInternalX) {
        this.marginInternalX = marginInternalX;
    }

    public int getMarginInternalY() {
        return this.marginInternalY;
    }

    public void setMarginInternalY(int marginInternalY) {
        this.marginInternalY = marginInternalY;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    @Override
    public void paintRayLabel(Graphics2D g2d, Ray bar) {
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        if (bar.getRayNature() == Ray.RayNature.XRay) {
            this.paintXRayLabel(g2d, bar);
        }
        if (bar.getRayNature() == Ray.RayNature.YRay) {
            this.paintYRayLabel(g2d, bar);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    private void paintYRayLabel(Graphics2D g2d, Ray bar) {
        double value = bar.getRayValue();
        String sVal = this.decimalFormat.format(value);
        if (this.getLabel() != null) {
            sVal = this.getLabel();
        }
        this.drawStickers(g2d, bar);
        if (this.getLabelColor() == null) {
            this.setLabelColor(Color.DARK_GRAY);
        }
        g2d.setColor(this.getLabelColor());
        g2d.drawString(sVal, (int)this.getX(g2d, bar), (int)this.getY(g2d, bar));
    }

    private void paintXRayLabel(Graphics2D g2d, Ray bar) {
        double value = bar.getRayValue();
        String sVal = this.decimalFormat.format(value);
        if (this.getLabel() != null) {
            sVal = this.getLabel();
        }
        this.drawStickers(g2d, bar);
        if (this.getLabelColor() == null) {
            this.setLabelColor(Color.DARK_GRAY);
        }
        g2d.setColor(this.getLabelColor());
        g2d.drawString(sVal, (int)this.getX(g2d, bar), (int)this.getY(g2d, bar));
    }

    private void drawStickers(Graphics2D g2d, Ray ray) {
        if (this.getFillColor() != null || this.getDrawColor() != null) {
            if (this.font == null) {
                this.setFont(new Font("Dialog", 0, 12));
            }
            g2d.setFont(this.getFont());
            FontMetrics fm = g2d.getFontMetrics();
            RoundRectangle2D.Double sticker = new RoundRectangle2D.Double((int)this.getX(g2d, ray) - this.marginInternalX, (int)this.getY(g2d, ray) - fm.getAscent() - this.marginInternalY, this.getLabelWidth(g2d, ray) + (double)(2 * this.marginInternalX), fm.getHeight() + 2 * this.marginInternalY, this.round, this.round);
            if (this.getFillColor() != null) {
                g2d.setColor(this.getFillColor());
                g2d.fill(sticker);
            }
            if (this.getDrawColor() != null) {
                g2d.setColor(this.getDrawColor());
                g2d.draw(sticker);
            }
        }
    }

    public double getLabelWidth(Graphics2D g2d, Ray ray) {
        if (this.font == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        double value = ray.getRayValue();
        String sVal = this.decimalFormat.format(value);
        if (this.getLabel() != null) {
            sVal = this.getLabel();
        }
        int labelWidth = fm.stringWidth(sVal);
        return labelWidth;
    }

    private double getX(Graphics2D g2d, Ray ray) {
        double x = 0.0;
        Rectangle2D rayShape = ray.getRayShape();
        if (this.horizontalAlignment == HorizontalAlignment.WestLeft) {
            double west = rayShape.getBounds2D().getX();
            x = west - this.getLabelWidth(g2d, ray) - (double)this.marginExternalX - (double)this.marginInternalX;
        } else if (this.horizontalAlignment == HorizontalAlignment.WestAcross) {
            double west = rayShape.getBounds2D().getX();
            x = west - this.getLabelWidth(g2d, ray) / 2.0;
        } else if (this.horizontalAlignment == HorizontalAlignment.WestRight) {
            double west = rayShape.getBounds2D().getX();
            x = west + (double)this.marginExternalX + (double)this.marginInternalX;
        } else if (this.horizontalAlignment == HorizontalAlignment.Middle) {
            double centerX = rayShape.getBounds2D().getCenterX();
            x = centerX - this.getLabelWidth(g2d, ray) / 2.0;
        } else if (this.horizontalAlignment == HorizontalAlignment.EastLeft) {
            double east = rayShape.getBounds2D().getX() + rayShape.getBounds2D().getWidth();
            x = east - this.getLabelWidth(g2d, ray) - (double)this.marginExternalX - (double)this.marginInternalX;
        } else if (this.horizontalAlignment == HorizontalAlignment.EastAcross) {
            double east = rayShape.getBounds2D().getX() + rayShape.getBounds2D().getWidth();
            x = east - this.getLabelWidth(g2d, ray) / 2.0;
        } else if (this.horizontalAlignment == HorizontalAlignment.EastRight) {
            double east = rayShape.getBounds2D().getX() + rayShape.getBounds2D().getWidth() + (double)this.marginExternalX;
            x = east + (double)this.marginInternalX;
        }
        return x;
    }

    private double getY(Graphics2D g2d, Ray ray) {
        double y = 0.0;
        if (this.font == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D rayShape = ray.getRayShape();
        if (this.verticalAlignment == VerticalAlignment.NorthTop) {
            y = rayShape.getBounds2D().getY() - (double)(fm.getDescent() + this.marginExternalY + this.marginInternalY);
        } else if (this.verticalAlignment == VerticalAlignment.NorthAcross) {
            y = rayShape.getBounds2D().getY() + (double)(fm.getAscent() / 2);
        } else if (this.verticalAlignment == VerticalAlignment.NorthBottom) {
            y = rayShape.getBounds2D().getY() + (double)(fm.getHeight() + this.marginExternalY + this.marginInternalY);
        } else if (this.verticalAlignment == VerticalAlignment.Middle) {
            y = rayShape.getBounds2D().getY() + rayShape.getBounds2D().getHeight() / 2.0 + (double)(fm.getAscent() / 2);
        } else if (this.verticalAlignment == VerticalAlignment.SouthTop) {
            y = rayShape.getBounds2D().getY() + rayShape.getBounds2D().getHeight() - (double)(fm.getAscent() + this.marginExternalY + this.marginInternalY);
        } else if (this.verticalAlignment == VerticalAlignment.SouthAcross) {
            y = rayShape.getBounds2D().getY() + rayShape.getBounds2D().getHeight() + (double)(fm.getAscent() / 2);
        } else if (this.verticalAlignment == VerticalAlignment.SouthBottom) {
            y = rayShape.getBounds2D().getY() + rayShape.getBounds2D().getHeight() + (double)(fm.getAscent() + this.marginExternalY + this.marginInternalY);
        }
        return y;
    }

    public static enum HorizontalAlignment {
        WestLeft,
        WestAcross,
        WestRight,
        Middle,
        EastLeft,
        EastAcross,
        EastRight;

    }

    public static enum VerticalAlignment {
        NorthTop,
        NorthAcross,
        NorthBottom,
        Middle,
        SouthTop,
        SouthAcross,
        SouthBottom;

    }
}

