/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.shell.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.metal.MetalScrollBarUI;
import org.jensoft.core.palette.color.Alpha;
import org.jensoft.core.palette.color.Spectral;
import org.jensoft.core.plugin.shell.ui.ShellScrollButton;

public class ShellScrollbarUI
extends MetalScrollBarUI {
    private Color scrollbarThemeColor = Spectral.SPECTRAL_BLUE2.brighter();

    public ShellScrollbarUI() {
    }

    public ShellScrollbarUI(Color scrollbarThemeColor) {
        this.scrollbarThemeColor = scrollbarThemeColor;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new ShellScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding, this.scrollbarThemeColor);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new ShellScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding, this.scrollbarThemeColor);
        return this.increaseButton;
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.scrollbar.getOrientation() == 1) {
            g2.translate(thumbBounds.x + 1, thumbBounds.y + 2);
            int width = thumbBounds.width - 3;
            int height = thumbBounds.height - 4;
            RoundRectangle2D.Double casing = new RoundRectangle2D.Double(0.0, 0.0, width, height, width, width);
            g2.setColor(Color.WHITE);
            Paint paint = g2.getPaint();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(8489627), 0.0f, height, new Color(3818066)));
            g2.setColor(new Alpha(this.scrollbarThemeColor, 200));
            g2.fill(casing);
            g2.setPaint(paint);
            Stroke stroke = g2.getStroke();
            g2.setStroke(new BasicStroke(2.0f));
            g2.setStroke(stroke);
            g2.translate(-thumbBounds.x - 1, -thumbBounds.y - 2);
        } else {
            g2.translate(thumbBounds.x + 2, thumbBounds.y + 1);
            int width = thumbBounds.width - 4;
            int height = thumbBounds.height - 3;
            RoundRectangle2D.Double casing = new RoundRectangle2D.Double(0.0, 0.0, width, height, height, height);
            g2.setColor(Color.WHITE);
            Paint paint = g2.getPaint();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(8489627), 0.0f, height, new Color(3818066)));
            g2.setColor(this.scrollbarThemeColor);
            g2.fill(casing);
            g2.setPaint(paint);
            Stroke stroke = g2.getStroke();
            g2.setStroke(new BasicStroke(2.0f));
            g2.setStroke(stroke);
            g2.translate(-thumbBounds.x - 2, -thumbBounds.y - 1);
        }
    }
}

