/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stock;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Dithering;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.stock.Stock;
import org.jensoft.core.plugin.stock.StockLayer;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class StockPlugin
extends AbstractPlugin {
    protected List<Stock> stocks = new ArrayList<Stock>();
    private List<StockLayer<?>> stockLayers = new ArrayList();

    public StockPlugin() {
        this.setAntialiasing(Antialiasing.On);
        this.setTextAntialising(TextAntialiasing.On);
        this.setDithering(Dithering.On);
        this.setPriority(100);
    }

    public List<StockLayer<?>> getLayers() {
        return this.stockLayers;
    }

    public void setLayers(List<StockLayer<?>> layers) {
        for (int i = 0; i < layers.size(); ++i) {
            layers.get(i).setHost(this);
        }
        this.stockLayers = layers;
    }

    public void addLayer(StockLayer<?> layer) {
        layer.setHost(this);
        this.stockLayers.add(layer);
    }

    public void addLayer(StockLayer<?> ... layers) {
        for (int i = 0; i < layers.length; ++i) {
            layers[i].setHost(this);
            this.stockLayers.add(layers[i]);
        }
    }

    public List<Stock> getStocks() {
        return this.stocks;
    }

    public void setStocks(List<Stock> stocks) {
        this.stocks = stocks;
    }

    public void addStocks(Stock stock) {
        this.stocks.add(stock);
    }

    public void addStock(Stock ... stocks) {
        for (int i = 0; i < stocks.length; ++i) {
            this.stocks.add(stocks[i]);
        }
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        for (StockLayer<?> layer : this.stockLayers) {
            layer.solveLayer();
            layer.paintLayer(v2d, g2d, viewPart);
        }
    }
}

