/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stock.geom;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.plugin.stock.geom.StockItemGeometry;

public class OhlcGeom
extends StockItemGeometry {
    private Color lowHighColor = NanoChromatique.BLACK.brighter();
    private Line2D deviceLowHighGap;
    private Line2D deviceOpenTick;
    private Line2D deviceCloseTick;

    @Override
    public void solveGeometry() {
        super.solveGeometry();
        Line2D.Double deviceLowHighGap = new Line2D.Double(this.getDeviceLow(), this.getDeviceHigh());
        this.setDeviceLowHighGap(deviceLowHighGap);
        Line2D.Double deviceOpenTick = new Line2D.Double(new Point2D.Double(this.getDeviceOpen().getX() - this.getDeviceFixingDuration() / 2.0, this.getDeviceOpen().getY()), this.getDeviceOpen());
        this.setDeviceOpenTick(deviceOpenTick);
        Line2D.Double deviceCloseTick = new Line2D.Double(this.getDeviceClose(), new Point2D.Double(this.getDeviceClose().getX() + this.getDeviceFixingDuration() / 2.0, this.getDeviceClose().getY()));
        this.setDeviceCloseTick(deviceCloseTick);
    }

    public Line2D getDeviceLowHighGap() {
        return this.deviceLowHighGap;
    }

    public void setDeviceLowHighGap(Line2D deviceLowHighGap) {
        this.deviceLowHighGap = deviceLowHighGap;
    }

    public Color getLowHighColor() {
        return this.lowHighColor;
    }

    public void setLowHighColor(Color lowHighColor) {
        this.lowHighColor = lowHighColor;
    }

    public Line2D getDeviceOpenTick() {
        return this.deviceOpenTick;
    }

    public void setDeviceOpenTick(Line2D deviceOpenTick) {
        this.deviceOpenTick = deviceOpenTick;
    }

    public Line2D getDeviceCloseTick() {
        return this.deviceCloseTick;
    }

    public void setDeviceCloseTick(Line2D deviceCloseTick) {
        this.deviceCloseTick = deviceCloseTick;
    }
}

