/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stock.geom;

import java.awt.geom.Point2D;
import org.jensoft.core.plugin.stock.Stock;
import org.jensoft.core.plugin.stock.geom.StockGeometry;
import org.jensoft.core.projection.Projection;

public class StockItemGeometry
extends StockGeometry {
    private Stock stock;
    private Point2D deviceLow;
    private Point2D deviceHigh;
    private Point2D deviceOpen;
    private Point2D deviceClose;
    private Point2D deviceVolume;
    private Point2D deviceVolumeBase;
    private double deviceFixing;
    private double deviceFixingStart;
    private double deviceFixingEnd;
    private double deviceFixingDuration;

    public Stock getStock() {
        return this.stock;
    }

    public void setStock(Stock stock) {
        this.stock = stock;
    }

    public Point2D getDeviceLow() {
        return this.deviceLow;
    }

    public void setDeviceLow(Point2D deviceLow) {
        this.deviceLow = deviceLow;
    }

    public Point2D getDeviceHigh() {
        return this.deviceHigh;
    }

    public void setDeviceHigh(Point2D deviceHigh) {
        this.deviceHigh = deviceHigh;
    }

    public Point2D getDeviceOpen() {
        return this.deviceOpen;
    }

    public void setDeviceOpen(Point2D deviceOpen) {
        this.deviceOpen = deviceOpen;
    }

    public Point2D getDeviceClose() {
        return this.deviceClose;
    }

    public void setDeviceClose(Point2D deviceClose) {
        this.deviceClose = deviceClose;
    }

    public Point2D getDeviceVolume() {
        return this.deviceVolume;
    }

    public void setDeviceVolume(Point2D deviceVolume) {
        this.deviceVolume = deviceVolume;
    }

    public Point2D getDeviceVolumeBase() {
        return this.deviceVolumeBase;
    }

    public void setDeviceVolumeBase(Point2D deviceVolumeBase) {
        this.deviceVolumeBase = deviceVolumeBase;
    }

    public double getDeviceFixing() {
        return this.deviceFixing;
    }

    public void setDeviceFixing(double deviceFixing) {
        this.deviceFixing = deviceFixing;
    }

    public double getDeviceFixingStart() {
        return this.deviceFixingStart;
    }

    public void setDeviceFixingStart(double deviceFixingStart) {
        this.deviceFixingStart = deviceFixingStart;
    }

    public double getDeviceFixingEnd() {
        return this.deviceFixingEnd;
    }

    public void setDeviceFixingEnd(double deviceFixingEnd) {
        this.deviceFixingEnd = deviceFixingEnd;
    }

    public double getDeviceFixingDuration() {
        return this.deviceFixingDuration;
    }

    public void setDeviceFixingDuration(double deviceFixingDuration) {
        this.deviceFixingDuration = deviceFixingDuration;
    }

    @Override
    public void solveGeometry() {
        Point2D deviceLow = this.getProjection().userToPixel(new Point2D.Double(new Long(this.stock.getFixing().getTime()).doubleValue(), this.stock.getLow()));
        Point2D deviceHigh = this.getProjection().userToPixel(new Point2D.Double(new Long(this.stock.getFixing().getTime()).doubleValue(), this.stock.getHigh()));
        Point2D deviceOpen = this.getProjection().userToPixel(new Point2D.Double(new Long(this.stock.getFixing().getTime()).doubleValue(), this.stock.getOpen()));
        Point2D deviceClose = this.getProjection().userToPixel(new Point2D.Double(new Long(this.stock.getFixing().getTime()).doubleValue(), this.stock.getClose()));
        this.setDeviceLow(deviceLow);
        this.setDeviceHigh(deviceHigh);
        this.setDeviceClose(deviceClose);
        this.setDeviceOpen(deviceOpen);
        Point2D deviceVolume = this.getProjection().userToPixel(new Point2D.Double(new Long(this.stock.getFixing().getTime()).doubleValue(), this.stock.getVolume()));
        this.setDeviceVolume(deviceVolume);
        Point2D deviceVolumeBase = this.getProjection().userToPixel(new Point2D.Double(new Long(this.stock.getFixing().getTime()).doubleValue(), 0.0));
        this.setDeviceVolumeBase(deviceVolumeBase);
        double deviceFixingStart = this.getProjection().userToPixelX(new Long(this.stock.getFixing().getTime() - this.stock.getFixingDurationMillis() / 2L).doubleValue());
        double deviceFixingEnd = this.getProjection().userToPixelX(new Long(this.stock.getFixing().getTime() + this.stock.getFixingDurationMillis() / 2L).doubleValue());
        double deviceFixingDuration = Math.abs(deviceFixingEnd - deviceFixingStart);
        double deviceTimingX = this.getProjection().userToPixelX(new Long(this.stock.getFixing().getTime()).doubleValue());
        this.setDeviceFixing(deviceTimingX);
        this.setDeviceFixingDuration(deviceFixingDuration);
        this.setDeviceFixingStart(deviceFixingStart);
        this.setDeviceFixingEnd(deviceFixingEnd);
    }

    private Projection getProjection() {
        return this.getLayer().getHost().getProjection();
    }
}

