/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stripe.manager;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.stripe.Stripe;
import org.jensoft.core.plugin.stripe.StripePlugin;
import org.jensoft.core.plugin.stripe.manager.AbstractStripeManager;
import org.jensoft.core.plugin.stripe.painter.StripePaint;

public class FreeStripeManager
extends AbstractStripeManager {
    private List<Stripe> stripes = new ArrayList<Stripe>();
    private List<Stripe> deviceStripes = new ArrayList<Stripe>();

    public FreeStripeManager(StripePlugin.StripeOrientation stripOrientation) {
        super.setStripeOrientation(stripOrientation);
    }

    public void addStripe(double stripStart, double stripEnd, StripePaint stripePaint) {
        Stripe band = new Stripe();
        band.setUserStart(stripStart);
        band.setUserEnd(stripEnd);
        band.setStripePaint(stripePaint);
        this.stripes.add(band);
    }

    public void addStripe(Stripe stripe) {
        this.stripes.add(stripe);
    }

    @Override
    public List<Stripe> getStripes() {
        this.deviceStripes.clear();
        for (Stripe b : this.stripes) {
            Stripe stripe;
            Point2D p2dDeviceStripeEnd;
            Point2D.Double p2dUserStripeEnd;
            Point2D p2dDeviceStripeStart;
            Point2D.Double p2dUserStripeStart;
            if (this.getStripeOrientation() == StripePlugin.StripeOrientation.Vertical) {
                p2dUserStripeStart = new Point2D.Double(b.getUserStart(), 0.0);
                p2dDeviceStripeStart = this.getProjection().userToPixel(p2dUserStripeStart);
                p2dUserStripeEnd = new Point2D.Double(b.getUserEnd(), 0.0);
                p2dDeviceStripeEnd = this.getProjection().userToPixel(p2dUserStripeEnd);
                stripe = new Stripe(StripePlugin.StripeOrientation.Vertical);
                stripe.setDeviceInterval(p2dDeviceStripeEnd.getX() - p2dDeviceStripeStart.getX());
                stripe.setDeviceStart(p2dDeviceStripeStart.getX());
                stripe.setDeviceEnd(p2dDeviceStripeEnd.getX());
                stripe.setUserInterval(b.getUserEnd() - b.getUserStart());
                stripe.setUserStart(b.getUserStart());
                stripe.setUserEnd(b.getUserEnd());
                stripe.setPaint(b.getStripePaint());
                this.deviceStripes.add(stripe);
                continue;
            }
            if (this.getStripeOrientation() != StripePlugin.StripeOrientation.Horizontal) continue;
            p2dUserStripeStart = new Point2D.Double(0.0, b.getUserStart());
            p2dDeviceStripeStart = this.getProjection().userToPixel(p2dUserStripeStart);
            p2dUserStripeEnd = new Point2D.Double(0.0, b.getUserEnd());
            p2dDeviceStripeEnd = this.getProjection().userToPixel(p2dUserStripeEnd);
            stripe = new Stripe(StripePlugin.StripeOrientation.Horizontal);
            stripe.setDeviceInterval(p2dDeviceStripeStart.getY() - p2dDeviceStripeEnd.getY());
            stripe.setDeviceStart(p2dDeviceStripeStart.getY());
            stripe.setUserInterval(b.getUserEnd() - b.getUserStart());
            stripe.setUserStart(b.getUserStart());
            stripe.setUserEnd(b.getUserEnd());
            stripe.setPaint(b.getStripePaint());
            this.deviceStripes.add(stripe);
        }
        return this.deviceStripes;
    }
}

