/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stripe.painter;

import java.awt.Color;
import java.awt.Paint;
import org.jensoft.core.graphics.Shader;

public class StripePaint {
    private Color stripeColor;
    private float[] shadeFractions;
    private Color[] shadeColors;
    private Paint stripePaint;

    public StripePaint() {
    }

    public StripePaint(Color stripeColor) {
        this.stripeColor = stripeColor;
    }

    public StripePaint(Shader shader) {
        if (shader.getFractions().length != shader.getColors().length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = shader.getFractions();
        this.shadeColors = shader.getColors();
    }

    public StripePaint(float[] shadeFractions, Color[] shadeColors) {
        if (shadeFractions.length != shadeColors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = shadeFractions;
        this.shadeColors = shadeColors;
    }

    public StripePaint(Paint stripePaint) {
        this.stripePaint = stripePaint;
    }

    public Color getStripeColor() {
        return this.stripeColor;
    }

    public void setStripeColor(Color stripeColor) {
        this.stripeColor = stripeColor;
    }

    public Paint getStripePaint() {
        return this.stripePaint;
    }

    public void setStripePaint(Paint stripePaint) {
        this.stripePaint = stripePaint;
    }

    public float[] getShadeFractions() {
        return this.shadeFractions;
    }

    public Color[] getShadeColors() {
        return this.shadeColors;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }
}

