/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import org.jensoft.core.catalog.nature.JenSoftView;
import org.jensoft.core.catalog.ui.ViewFrameUI;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.palette.color.FilPalette;
import org.jensoft.core.palette.color.JennyPalette;
import org.jensoft.core.palette.color.PetalPalette;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.grid.Grid;
import org.jensoft.core.plugin.grid.GridPlugin;
import org.jensoft.core.plugin.grid.manager.FreeGridManager;
import org.jensoft.core.plugin.legend.title.TitleLegend;
import org.jensoft.core.plugin.legend.title.TitleLegendConstraints;
import org.jensoft.core.plugin.legend.title.TitleLegendPlugin;
import org.jensoft.core.plugin.legend.title.painter.fil.TitleLegendGradientFill;
import org.jensoft.core.plugin.stripe.StripePlugin;
import org.jensoft.core.plugin.stripe.painter.StripePalette;
import org.jensoft.core.plugin.symbol.BarEvent;
import org.jensoft.core.plugin.symbol.BarListener;
import org.jensoft.core.plugin.symbol.BarSymbol;
import org.jensoft.core.plugin.symbol.BarSymbolLayer;
import org.jensoft.core.plugin.symbol.Stack;
import org.jensoft.core.plugin.symbol.StackedBarSymbol;
import org.jensoft.core.plugin.symbol.SymbolComponent;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.plugin.symbol.SymbolToolkit;
import org.jensoft.core.plugin.symbol.painter.effect.BarEffect1;
import org.jensoft.core.plugin.symbol.painter.effect.BarEffect2;
import org.jensoft.core.plugin.symbol.painter.effect.BarEffect3;
import org.jensoft.core.plugin.symbol.painter.fill.BarDefaultFill;
import org.jensoft.core.plugin.symbol.painter.label.BarSymbolRelativeLabel;
import org.jensoft.core.plugin.translate.TranslatePlugin;
import org.jensoft.core.plugin.zoom.wheel.ZoomWheelPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.Portfolio;
import org.jensoft.core.view.View;
import org.jensoft.core.view.background.ViewDarkBackground;
import org.jensoft.core.view.background.ViewDefaultBackground;

@JenSoftView(background=ViewDarkBackground.class)
public class BarStackedStackEffectDemo
extends View {
    public static void main(String[] args) {
        ViewFrameUI ui = new ViewFrameUI(new BarStackedStackEffectDemo());
    }

    @Portfolio(name="SimpleVerticalBarStackedDemo22", width=500, height=250)
    public static View getPortofolio() {
        BarStackedStackEffectDemo demo = new BarStackedStackEffectDemo();
        ViewDefaultBackground viewBackground = new ViewDefaultBackground();
        Shader s = new Shader(new float[]{0.0f, 1.0f}, new Color[]{new Color(32, 39, 55), Color.BLACK});
        viewBackground.setShader(s);
        viewBackground.setOutlineStroke(new BasicStroke(2.5f));
        demo.setBackgroundPainter(viewBackground);
        return demo;
    }

    public BarStackedStackEffectDemo() {
        Projection.Linear w2d = new Projection.Linear(0.0, 0.0, -30.0, 120.0);
        this.registerProjection(w2d);
        SymbolPlugin barPlugin = new SymbolPlugin();
        barPlugin.setNature(SymbolPlugin.SymbolNature.Vertical);
        w2d.registerPlugin(barPlugin);
        Stack s1b1 = SymbolToolkit.createStack("s1", TangoPalette.CHAMELEON1, 12.0);
        Stack s2b1 = SymbolToolkit.createStack("s2", TangoPalette.CHAMELEON2, 20.0);
        Stack s3b1 = SymbolToolkit.createStack("s3", TangoPalette.CHAMELEON3, 40.0);
        StackedBarSymbol b1 = SymbolToolkit.createStackedBarSymbol("b1", 0.0, 30.0, BarSymbol.SymbolInflate.Ascent, 74.0, s1b1, s2b1, s3b1);
        b1.setBarDraw(null);
        b1.setBarFill(new BarDefaultFill());
        b1.setBarEffect(null);
        s3b1.setBarEffect(new BarEffect3());
        s2b1.setBarEffect(new BarEffect2());
        s1b1.setBarEffect(new BarEffect1());
        BarSymbolLayer barLayer = new BarSymbolLayer();
        barPlugin.addLayer(barLayer);
        barLayer.addSymbol(SymbolComponent.createGlue(BarSymbol.class));
        barLayer.addSymbol(b1);
        barLayer.addSymbol(SymbolComponent.createStrut(BarSymbol.class, 20.0));
        barLayer.addSymbol(SymbolComponent.createGlue(BarSymbol.class));
        StripePlugin.MultiplierStripe.H stripePlugin = new StripePlugin.MultiplierStripe.H(0.0, 20.0);
        StripePalette bp = new StripePalette();
        bp.addPaint(new Color(255, 255, 255, 40));
        bp.addPaint(ColorPalette.alpha(FilPalette.GREEN5, 120));
        stripePlugin.setStripePalette(bp);
        stripePlugin.setAlpha(0.3f);
        w2d.registerPlugin(stripePlugin);
        GridPlugin.MultiplierGrid gridLayout = new GridPlugin.MultiplierGrid(0.0, 20.0, Grid.GridOrientation.Horizontal);
        gridLayout.setGridColor(new Color(255, 255, 255, 60));
        w2d.registerPlugin(gridLayout);
        GridPlugin.FreeGrid grids = new GridPlugin.FreeGrid(Grid.GridOrientation.Horizontal);
        ((FreeGridManager)grids.getGridManager()).addGrid(-32.0, "JenSoft", PetalPalette.PETAL4_HC, 0.001f);
        w2d.registerPlugin(grids);
        TitleLegend legend = new TitleLegend("Simple Stacked Bar");
        legend.setLegendFill(new TitleLegendGradientFill(Color.WHITE, JennyPalette.JENNY8));
        Font f = new Font("Dialog", 0, 12);
        legend.setFont(f);
        legend.setConstraints(new TitleLegendConstraints(TitleLegendConstraints.LegendPosition.South, 0.8f, TitleLegendConstraints.LegendAlignment.Rigth));
        TitleLegendPlugin lgendL = new TitleLegendPlugin();
        lgendL.addLegend(legend);
        w2d.registerPlugin(lgendL);
        barLayer.addBarListener(new BarListener(){

            @Override
            public void barSymbolReleased(BarEvent e) {
                System.out.println("bar released : " + e.getBarSymbol().getName());
            }

            @Override
            public void barSymbolPressed(BarEvent e) {
                System.out.println("bar pressed : " + e.getBarSymbol().getName());
            }

            @Override
            public void barSymbolExited(BarEvent e) {
                System.out.println("bar exited : " + e.getBarSymbol().getName());
            }

            @Override
            public void barSymbolEntered(BarEvent e) {
                System.out.println("bar entered : " + e.getBarSymbol().getName());
            }

            @Override
            public void barSymbolClicked(BarEvent e) {
                if (!(e.getBarSymbol() instanceof StackedBarSymbol)) {
                    System.out.println("bar clicked : " + e.getBarSymbol().getClass());
                    if (e.getBarSymbol().getBarLabel() == null) {
                        BarSymbol symbol = e.getBarSymbol();
                        BarSymbolRelativeLabel rl = new BarSymbolRelativeLabel(BarSymbolRelativeLabel.VerticalAlignment.Middle, BarSymbolRelativeLabel.HorizontalAlignment.Middle, Color.WHITE, symbol.getThemeColor(), Color.BLACK);
                        symbol.setBarLabel(rl);
                        symbol.getHost().getProjection().getView().repaintDevice();
                    } else {
                        BarSymbol symbol = e.getBarSymbol();
                        symbol.setBarLabel(null);
                        symbol.getHost().getProjection().getView().repaintDevice();
                    }
                }
            }
        });
        TranslatePlugin toolTranslate = new TranslatePlugin();
        w2d.registerPlugin(toolTranslate);
        ZoomWheelPlugin zoomWheel = new ZoomWheelPlugin();
        w2d.registerPlugin(zoomWheel);
    }
}

