/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol;

import java.awt.Color;
import java.awt.Shape;
import org.jensoft.core.device.PartBuffer;
import org.jensoft.core.plugin.symbol.BarSymbolLayer;
import org.jensoft.core.plugin.symbol.SymbolComponent;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.plugin.symbol.painter.axis.AbstractBarAxisLabel;
import org.jensoft.core.plugin.symbol.painter.draw.AbstractBarDraw;
import org.jensoft.core.plugin.symbol.painter.effect.AbstractBarEffect;
import org.jensoft.core.plugin.symbol.painter.fill.AbstractBarFill;
import org.jensoft.core.plugin.symbol.painter.label.AbstractBarLabel;
import org.jensoft.core.view.View;

public class BarSymbol
extends SymbolComponent {
    private double value;
    private double base;
    private boolean baseSet;
    private Color themeColor;
    private String symbol;
    private int round = 5;
    private boolean ascent = false;
    private boolean descent = false;
    private MorpheStyle morpheStyle = MorpheStyle.Rectangle;
    private AbstractBarDraw barDraw;
    private AbstractBarFill barFill;
    private AbstractBarEffect barEffect;
    private AbstractBarLabel barLabel;
    private AbstractBarAxisLabel axisLabel;
    private Shape barShape;
    private PartBuffer part;
    private boolean inflating = false;
    private boolean deflating = false;
    private Inflate inflate;
    private Deflate deflate;

    public BarSymbol() {
    }

    public BarSymbol(String name) {
        this.setName(name);
        this.setSymbol(name);
    }

    public BarSymbol(String name, String symbol) {
        this.setName(name);
        this.setSymbol(symbol);
    }

    public AbstractBarLabel getBarLabel() {
        return this.barLabel;
    }

    public void setBarLabel(AbstractBarLabel barLabel) {
        this.barLabel = barLabel;
    }

    public AbstractBarAxisLabel getAxisLabel() {
        return this.axisLabel;
    }

    public void setAxisLabel(AbstractBarAxisLabel axisLabel) {
        this.axisLabel = axisLabel;
    }

    public PartBuffer getPart() {
        return this.part;
    }

    public void setPart(PartBuffer part) {
        this.part = part;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public MorpheStyle getMorpheStyle() {
        return this.morpheStyle;
    }

    public void setMorpheStyle(MorpheStyle morpheStyle) {
        this.morpheStyle = morpheStyle;
    }

    public Shape getBarShape() {
        return this.barShape;
    }

    public void setBarShape(Shape barShape) {
        this.barShape = barShape;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public Color getThemeColor() {
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public double getValue() {
        return this.value;
    }

    public void setAscentValue(double value) {
        this.ascent = true;
        this.descent = false;
        if (value < 0.0) {
            throw new IllegalArgumentException("bar value should be greater than 0");
        }
        this.value = value;
    }

    public boolean isInflating() {
        return this.inflating;
    }

    public void setInflating(boolean inflating) {
        this.inflating = inflating;
    }

    public boolean isDeflating() {
        return this.deflating;
    }

    public void setDeflating(boolean deflating) {
        this.deflating = deflating;
    }

    public void interruptInflating() {
        if (this.inflate != null && !this.inflate.isInterrupted()) {
            this.inflate.interrupt();
            try {
                this.inflate.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.deflate != null && !this.deflate.isInterrupted()) {
            this.deflate.interrupt();
            try {
                this.deflate.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void inflate(double deltaValue, int waitBeforeStarting, int delay, int step) {
        if (this.isInflating() || this.isDeflating()) {
            return;
        }
        this.inflate = new Inflate(deltaValue, waitBeforeStarting, delay, step);
        this.inflate.start();
    }

    public void deflate(double deltaValue, int waitBeforeStarting, int delay, int step) {
        if (this.isInflating() || this.isDeflating()) {
            return;
        }
        this.deflate = new Deflate(deltaValue, waitBeforeStarting, delay, step);
        this.deflate.start();
    }

    public void setDescentValue(double value) {
        this.ascent = false;
        this.descent = true;
        if (value < 0.0) {
            throw new IllegalArgumentException("bar value should be greater than 0");
        }
        this.value = value;
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.baseSet = true;
        this.base = base;
    }

    public boolean isBaseSet() {
        return this.baseSet;
    }

    public boolean isAscent() {
        return this.ascent;
    }

    public boolean isDescent() {
        return this.descent;
    }

    public boolean isValueSet() {
        return this.ascent || this.descent;
    }

    public AbstractBarDraw getBarDraw() {
        return this.barDraw;
    }

    public void setBarDraw(AbstractBarDraw barDraw) {
        this.barDraw = barDraw;
    }

    public AbstractBarFill getBarFill() {
        return this.barFill;
    }

    public void setBarFill(AbstractBarFill barFill) {
        this.barFill = barFill;
    }

    public AbstractBarEffect getBarEffect() {
        return this.barEffect;
    }

    public void setBarEffect(AbstractBarEffect barEffect) {
        this.barEffect = barEffect;
    }

    class Deflate
    extends Thread {
        private int waitBeforeStarting;
        private int step;
        private int delay;
        private double deltaValue;

        public Deflate(double deltaValue, int waitBeforeStarting, int delay, int step) {
            this.waitBeforeStarting = waitBeforeStarting;
            this.deltaValue = deltaValue;
            this.delay = delay;
            this.step = step;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BarSymbol.this.setDeflating(true);
            try {
                Thread.sleep(this.waitBeforeStarting);
                double val = BarSymbol.this.getValue();
                double valueByStep = this.deltaValue / (double)this.step;
                int delayByStep = this.delay / this.step;
                for (int i = 0; i < this.step; ++i) {
                    val -= valueByStep;
                    if (BarSymbol.this.isAscent()) {
                        BarSymbol.this.setAscentValue(val);
                    } else if (BarSymbol.this.isDescent()) {
                        BarSymbol.this.setDescentValue(val);
                    }
                    if (BarSymbol.this.getHost() == null || BarSymbol.this.getHost().getProjection() == null) {
                        this.interrupt();
                    }
                    if (BarSymbol.this.getHost() != null) {
                        ((BarSymbolLayer)BarSymbol.this.getLayer()).solveSymbolComponent(BarSymbol.this);
                    }
                    if (BarSymbol.this.getNature() == SymbolPlugin.SymbolNature.Vertical) {
                        BarSymbol.this.getHost().getProjection().getView().repaintDeviceBand(View.DeviceBand.XBand, (int)BarSymbol.this.getBarShape().getBounds().getX(), (int)BarSymbol.this.getBarShape().getBounds().getWidth() + 1);
                    } else if (BarSymbol.this.getNature() == SymbolPlugin.SymbolNature.Horizontal) {
                        BarSymbol.this.getHost().getProjection().getView().repaintDeviceBand(View.DeviceBand.YBand, (int)BarSymbol.this.getBarShape().getBounds().getY(), (int)BarSymbol.this.getBarShape().getBounds().getHeight() + 1);
                    }
                    Thread.sleep(delayByStep);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                BarSymbol.this.setDeflating(false);
            }
        }
    }

    class Inflate
    extends Thread {
        private int waitBeforeStarting;
        private int step;
        private int delay;
        private double deltaValue;

        public Inflate(double deltaValue, int waitBeforeStarting, int delay, int step) {
            this.waitBeforeStarting = waitBeforeStarting;
            this.deltaValue = deltaValue;
            this.delay = delay;
            this.step = step;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BarSymbol.this.setInflating(true);
            try {
                Thread.sleep(this.waitBeforeStarting);
                double val = BarSymbol.this.getValue();
                double valueByStep = this.deltaValue / (double)this.step;
                int delayByStep = this.delay / this.step;
                for (int i = 0; i < this.step; ++i) {
                    val += valueByStep;
                    if (BarSymbol.this.isAscent()) {
                        BarSymbol.this.setAscentValue(val);
                    } else if (BarSymbol.this.isDescent()) {
                        BarSymbol.this.setDescentValue(val);
                    }
                    if (BarSymbol.this.getHost() == null || BarSymbol.this.getHost().getProjection() == null) {
                        this.interrupt();
                    }
                    if (BarSymbol.this.getHost() != null) {
                        if (BarSymbol.this.getLayer() == null) {
                            return;
                        }
                        ((BarSymbolLayer)BarSymbol.this.getLayer()).solveSymbolComponent(BarSymbol.this);
                    }
                    if (BarSymbol.this.getNature() == SymbolPlugin.SymbolNature.Vertical) {
                        BarSymbol.this.getHost().getProjection().getView().repaintDeviceBand(View.DeviceBand.XBand, (int)BarSymbol.this.getBarShape().getBounds().getX(), (int)BarSymbol.this.getBarShape().getBounds().getWidth() + 1);
                    } else if (BarSymbol.this.getNature() == SymbolPlugin.SymbolNature.Horizontal) {
                        BarSymbol.this.getHost().getProjection().getView().repaintDeviceBand(View.DeviceBand.YBand, (int)BarSymbol.this.getBarShape().getBounds().getY(), (int)BarSymbol.this.getBarShape().getBounds().getHeight() + 1);
                    }
                    Thread.sleep(delayByStep);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                BarSymbol.this.setInflating(false);
            }
        }
    }

    public static enum SymbolInflate {
        Ascent,
        Descent;

    }

    public static enum MorpheStyle {
        Round,
        Rectangle;

    }
}

