/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.plugin.symbol.BarSymbol;
import org.jensoft.core.plugin.symbol.SymbolComponent;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.plugin.symbol.painter.draw.AbstractBarDraw;
import org.jensoft.core.plugin.symbol.painter.effect.AbstractBarEffect;
import org.jensoft.core.plugin.symbol.painter.fill.AbstractBarFill;

public class BarSymbolGroup
extends BarSymbol {
    private List<BarSymbol> symbolComponents = new ArrayList<BarSymbol>();
    public String symbol;
    private Color themeColor;
    private double barThickness;
    private boolean isThemeColorSet = false;
    private double base;
    private boolean isBaseSet = false;
    private int round = 5;
    private boolean isRoundSet = false;
    private BarSymbol.MorpheStyle morpheStyle = BarSymbol.MorpheStyle.Rectangle;
    private boolean isThicknessSet = false;
    private AbstractBarDraw barDraw;
    private boolean isBarDrawSet = false;
    private AbstractBarFill barFill;
    private boolean isBarFillSet = false;
    private AbstractBarEffect barEffect;
    private boolean isBarEffectSet = false;

    public BarSymbolGroup() {
    }

    public BarSymbolGroup(String symbol) {
        this.setName(symbol);
        this.setSymbol(symbol);
    }

    public BarSymbolGroup(String name, String symbol) {
        this.setName(name);
        this.setSymbol(symbol);
    }

    public void copyToBar() {
        this.copyBaseToBar(this.getBase());
        this.copyDrawToBar(this.getBarDraw());
        this.copyEffectStyleToBar(this.getBarEffect());
        this.copyFillStyleToBar(this.getBarFill());
        this.copyMorpheStyleToBar(this.getMorpheStyle());
        this.copyRoundToBar(this.getRound());
        this.copyThemeColorToBar(this.getThemeColor());
        this.copyBarThicknessToBar(this.getBarThickness());
    }

    @Override
    public SymbolPlugin.SymbolNature getNature() {
        return this.getHost().getNature();
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public Color getThemeColor() {
        if (this.themeColor == null) {
            this.themeColor = ColorPalette.getRandomColor();
        }
        return this.themeColor;
    }

    public boolean isThemeColorSet() {
        return this.isThemeColorSet;
    }

    public void setThemeColorSet(boolean isThemeColorSet) {
        this.isThemeColorSet = isThemeColorSet;
    }

    @Override
    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
        this.setThemeColorSet(true);
    }

    public void copyThemeColorToBar(Color themeColor) {
        if (!this.isThemeColorSet()) {
            return;
        }
        for (SymbolComponent symbolComponent : this.symbolComponents) {
            if (!(symbolComponent instanceof BarSymbol)) continue;
            ((BarSymbol)symbolComponent).setThemeColor(themeColor);
        }
    }

    @Override
    public double getBase() {
        return this.base;
    }

    @Override
    public boolean isBaseSet() {
        return this.isBaseSet;
    }

    public void setBaseSet(boolean isBaseSet) {
        this.isBaseSet = isBaseSet;
    }

    @Override
    public void setBase(double base) {
        this.base = base;
        this.setBaseSet(true);
    }

    public void copyBaseToBar(double base) {
        if (!this.isBaseSet()) {
            return;
        }
        for (SymbolComponent symbolComponent : this.symbolComponents) {
            if (!(symbolComponent instanceof BarSymbol)) continue;
            ((BarSymbol)symbolComponent).setBase(base);
        }
    }

    @Override
    public double getThickness() {
        double groupThickness = 0.0;
        for (SymbolComponent symbolComponent : this.symbolComponents) {
            groupThickness += symbolComponent.getThickness();
        }
        return groupThickness;
    }

    public double getMaxValue() {
        double max = -1.0;
        boolean setMax = false;
        for (BarSymbol b : this.getSymbolComponents()) {
            if (b.isFiller()) continue;
            Rectangle2D rect2D = b.getBarShape().getBounds2D();
            if (this.getNature() == SymbolPlugin.SymbolNature.Vertical) {
                if (!setMax) {
                    max = rect2D.getMaxY();
                    setMax = true;
                }
                max = Math.max(max, rect2D.getMaxY());
                continue;
            }
            if (this.getNature() != SymbolPlugin.SymbolNature.Horizontal) continue;
            if (!setMax) {
                max = rect2D.getMaxX();
                setMax = true;
            }
            max = Math.max(max, rect2D.getMaxX());
        }
        return max;
    }

    public double getMinValue() {
        double min = -1.0;
        boolean setMin = false;
        for (BarSymbol b : this.getSymbolComponents()) {
            if (b.isFiller()) continue;
            Rectangle2D rect2D = b.getBarShape().getBounds2D();
            if (this.getNature() == SymbolPlugin.SymbolNature.Vertical) {
                if (!setMin) {
                    min = rect2D.getMinY();
                    setMin = true;
                }
                min = Math.min(min, rect2D.getMinY());
                continue;
            }
            if (this.getNature() != SymbolPlugin.SymbolNature.Horizontal) continue;
            if (!setMin) {
                min = rect2D.getMinX();
                setMin = true;
            }
            min = Math.min(min, rect2D.getMinX());
        }
        return min;
    }

    public double getCenterValue() {
        double max = this.getMaxValue();
        double min = this.getMinValue();
        return min + Math.abs(max - min) / 2.0;
    }

    @Override
    public Shape getBarShape() {
        Area a = new Area();
        double max = this.getMaxValue();
        double min = this.getMinValue();
        for (BarSymbol b : this.getSymbolComponents()) {
            if (!b.isFiller()) {
                a.add(new Area(b.getBarShape()));
                continue;
            }
            if (!b.isFiller() || b.getFillerType() != SymbolComponent.FillerType.Strut) continue;
            Rectangle2D.Double strutShape = null;
            if (this.getNature() == SymbolPlugin.SymbolNature.Vertical) {
                strutShape = new Rectangle2D.Double(b.getLocationX(), max, b.getThickness(), max - min);
                continue;
            }
            if (this.getNature() != SymbolPlugin.SymbolNature.Horizontal) continue;
            strutShape = new Rectangle2D.Double(min, b.getLocationY(), max - min, b.getThickness());
        }
        return a.getBounds2D();
    }

    public boolean isThicknessSet() {
        return this.isThicknessSet;
    }

    public void setThicknessSet(boolean isThicknessSet) {
        this.isThicknessSet = isThicknessSet;
    }

    private double getBarThickness() {
        return this.barThickness;
    }

    @Override
    public void setThickness(double thickness) {
        this.barThickness = thickness;
        this.setThicknessSet(true);
    }

    public void copyBarThicknessToBar(double thickness) {
        if (!this.isThicknessSet()) {
            return;
        }
        for (SymbolComponent symbolComponent : this.symbolComponents) {
            if (!(symbolComponent instanceof BarSymbol) || symbolComponent.isFiller()) continue;
            ((BarSymbol)symbolComponent).setThickness(thickness);
        }
    }

    @Override
    public int getRound() {
        return this.round;
    }

    @Override
    public void setRound(int round) {
        this.round = round;
        this.setRoundSet(true);
    }

    public boolean isRoundSet() {
        return this.isRoundSet;
    }

    public void setRoundSet(boolean isRoundSet) {
        this.isRoundSet = isRoundSet;
    }

    public void copyRoundToBar(int round) {
        if (!this.isRoundSet()) {
            return;
        }
        for (SymbolComponent symbolComponent : this.symbolComponents) {
            if (!(symbolComponent instanceof BarSymbol)) continue;
            ((BarSymbol)symbolComponent).setRound(round);
        }
    }

    @Override
    public BarSymbol.MorpheStyle getMorpheStyle() {
        return this.morpheStyle;
    }

    @Override
    public void setMorpheStyle(BarSymbol.MorpheStyle morpheStyle) {
        this.morpheStyle = morpheStyle;
        this.copyMorpheStyleToBar(morpheStyle);
    }

    public void copyMorpheStyleToBar(BarSymbol.MorpheStyle morpheStyle) {
        for (SymbolComponent symbolComponent : this.symbolComponents) {
            if (!(symbolComponent instanceof BarSymbol)) continue;
            ((BarSymbol)symbolComponent).setMorpheStyle(morpheStyle);
        }
    }

    @Override
    public AbstractBarDraw getBarDraw() {
        return this.barDraw;
    }

    public boolean isBarDrawSet() {
        return this.isBarDrawSet;
    }

    public void setBarDrawSet(boolean isBarDrawSet) {
        this.isBarDrawSet = isBarDrawSet;
    }

    @Override
    public void setBarDraw(AbstractBarDraw barDraw) {
        this.barDraw = barDraw;
        this.setBarDrawSet(true);
    }

    public void copyDrawToBar(AbstractBarDraw barDraw) {
        if (!this.isBarDrawSet()) {
            return;
        }
        for (SymbolComponent symbolComponent : this.symbolComponents) {
            if (!(symbolComponent instanceof BarSymbol)) continue;
            ((BarSymbol)symbolComponent).setBarDraw(barDraw);
        }
    }

    @Override
    public AbstractBarFill getBarFill() {
        return this.barFill;
    }

    public boolean isBarFillSet() {
        return this.isBarFillSet;
    }

    public void setBarFillSet(boolean isBarFillSet) {
        this.isBarFillSet = isBarFillSet;
    }

    @Override
    public void setBarFill(AbstractBarFill barFill) {
        this.barFill = barFill;
        this.setBarFillSet(true);
    }

    public void copyFillStyleToBar(AbstractBarFill barFill) {
        if (!this.isBarFillSet()) {
            return;
        }
        for (SymbolComponent symbolComponent : this.symbolComponents) {
            if (!(symbolComponent instanceof BarSymbol)) continue;
            ((BarSymbol)symbolComponent).setBarFill(barFill);
        }
    }

    @Override
    public AbstractBarEffect getBarEffect() {
        return this.barEffect;
    }

    @Override
    public void setBarEffect(AbstractBarEffect barEffect) {
        this.barEffect = barEffect;
        this.setBarEffectSet(true);
    }

    public boolean isBarEffectSet() {
        return this.isBarEffectSet;
    }

    public void setBarEffectSet(boolean isBarEffectSet) {
        this.isBarEffectSet = isBarEffectSet;
    }

    public void copyEffectStyleToBar(AbstractBarEffect barEffect) {
        if (!this.isBarEffectSet()) {
            return;
        }
        for (SymbolComponent symbolComponent : this.symbolComponents) {
            if (!(symbolComponent instanceof BarSymbol)) continue;
            ((BarSymbol)symbolComponent).setBarEffect(barEffect);
        }
    }

    public void addSymbol(BarSymbol symbol) {
        if (symbol.isFiller() && symbol.getFillerType() == SymbolComponent.FillerType.Glue) {
            throw new IllegalArgumentException("Glue can not be add in group.");
        }
        this.symbolComponents.add(symbol);
    }

    public void removeSymbolComponent(SymbolComponent symbol) {
        this.symbolComponents.remove(symbol);
    }

    public List<BarSymbol> getSymbolComponents() {
        return this.symbolComponents;
    }

    public void setSymbolComponents(List<BarSymbol> symbolComponents) {
        this.symbolComponents = symbolComponents;
    }
}

