/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jensoft.core.plugin.symbol.PointEvent;
import org.jensoft.core.plugin.symbol.PointListener;
import org.jensoft.core.plugin.symbol.PointSymbol;
import org.jensoft.core.plugin.symbol.PolylinePointSymbol;
import org.jensoft.core.plugin.symbol.SymbolComponent;
import org.jensoft.core.plugin.symbol.SymbolLayer;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.plugin.symbol.painter.point.AbstractPointSymbolPainter;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class PointSymbolLayer
extends SymbolLayer<PointSymbol> {
    private EventListenerList symbolListenerList = new EventListenerList();

    public void addPointListener(PointListener listener) {
        this.symbolListenerList.add(PointListener.class, listener);
    }

    public void removePointListener(PointListener listener) {
        this.symbolListenerList.remove(PointListener.class, listener);
    }

    @Override
    public List<PointSymbol> getFlattenSymbolComponents() {
        ArrayList<PointSymbol> flattenSymbolComponents = new ArrayList<PointSymbol>();
        for (PointSymbol comp : this.getSymbols()) {
            if (!(comp instanceof PointSymbol) || comp instanceof PolylinePointSymbol) continue;
            flattenSymbolComponents.add(comp);
        }
        return flattenSymbolComponents;
    }

    @Override
    public void paintLayer(View view, Graphics2D g2d, ViewPart viewPart, SymbolPlugin.PaintRequest paintRequest) {
        if (viewPart == ViewPart.Device && paintRequest == SymbolPlugin.PaintRequest.SymbolLayer) {
            for (PointSymbol ps : this.getSymbols()) {
                if (ps.isFiller()) continue;
                if (ps instanceof PointSymbol && !(ps instanceof PolylinePointSymbol)) {
                    if (ps.getPointSymbolPainters() == null) continue;
                    for (AbstractPointSymbolPainter painter : ps.getPointSymbolPainters()) {
                        painter.paintSymbol(g2d, ps, viewPart);
                    }
                    continue;
                }
                if (!(ps instanceof PolylinePointSymbol) || ((PolylinePointSymbol)ps).getPolylinePainter() == null) continue;
                ((PolylinePointSymbol)ps).getPolylinePainter().paintSymbol(g2d, ps, viewPart);
            }
        }
    }

    @Override
    public void solveSymbolComponent(PointSymbol symbol) {
        if (symbol.isFiller()) {
            return;
        }
        if (this.getHost().getNature() == SymbolPlugin.SymbolNature.Vertical) {
            this.solveVSymbolComponent(symbol);
        }
        if (this.getHost().getNature() == SymbolPlugin.SymbolNature.Horizontal) {
            this.solveHSymbolComponent(symbol);
        }
    }

    private void solveVSymbolComponent(SymbolComponent symbol) {
        symbol.setNature(SymbolPlugin.SymbolNature.Vertical);
        if (symbol instanceof PointSymbol && !(symbol instanceof PolylinePointSymbol)) {
            this.solveVPointSymbol((PointSymbol)symbol);
        } else if (symbol instanceof PolylinePointSymbol) {
            // empty if block
        }
    }

    private void solveHSymbolComponent(SymbolComponent symbol) {
        symbol.setNature(SymbolPlugin.SymbolNature.Horizontal);
        if (symbol instanceof PointSymbol && !(symbol instanceof PolylinePointSymbol)) {
            this.solveHPointSymbol((PointSymbol)symbol);
        } else if (symbol instanceof PolylinePointSymbol) {
            // empty if block
        }
    }

    private void solveVPointSymbol(PointSymbol pointSymbol) {
        Projection w2d = this.getHost().getProjection();
        pointSymbol.setHost(this.getHost());
        Point2D.Double p2dUser = new Point2D.Double(0.0, pointSymbol.getValue());
        Point2D p2ddevice = w2d.userToPixel(p2dUser);
        pointSymbol.setDeviceValue(p2ddevice.getY());
        double x = this.getComponentXLocation(pointSymbol);
        Point2D.Double devicePoint = new Point2D.Double(x, p2ddevice.getY());
        Rectangle2D.Double rectangle = new Rectangle2D.Double(((Point2D)devicePoint).getX() - (double)pointSymbol.getSensibleRadius(), ((Point2D)devicePoint).getY() - (double)pointSymbol.getSensibleRadius(), 2 * pointSymbol.getSensibleRadius(), 2 * pointSymbol.getSensibleRadius());
        pointSymbol.setSensibleShape(rectangle);
        pointSymbol.setDevicePoint(devicePoint);
    }

    private void solveHPointSymbol(PointSymbol pointSymbol) {
        Projection w2d = this.getHost().getProjection();
        pointSymbol.setHost(this.getHost());
        Point2D.Double p2dUser = new Point2D.Double(pointSymbol.getValue(), 0.0);
        Point2D p2ddevice = w2d.userToPixel(p2dUser);
        pointSymbol.setDeviceValue(p2ddevice.getX());
        double y = this.getComponentYLocation(pointSymbol);
        pointSymbol.setDevicePoint(new Point2D.Double(p2ddevice.getX(), pointSymbol.getLocationY()));
    }

    @Override
    public void onRelease(MouseEvent me) {
        List points = this.getSymbols();
        for (SymbolComponent symbolComponent : points) {
            if (!(symbolComponent instanceof PointSymbol) || ((PointSymbol)symbolComponent).getSensibleShape() == null || !((PointSymbol)symbolComponent).getSensibleShape().contains(me.getX(), me.getY()) || !((PointSymbol)symbolComponent).isLockEnter()) continue;
            this.fireBarReleased((PointSymbol)symbolComponent);
        }
    }

    @Override
    public void onPress(MouseEvent me) {
        List points = this.getSymbols();
        for (SymbolComponent symbolComponent : points) {
            if (!(symbolComponent instanceof PointSymbol) || ((PointSymbol)symbolComponent).getSensibleShape() == null || !((PointSymbol)symbolComponent).getSensibleShape().contains(me.getX(), me.getY()) || !((PointSymbol)symbolComponent).isLockEnter()) continue;
            this.fireBarPressed((PointSymbol)symbolComponent);
        }
    }

    @Override
    public void onExit(MouseEvent me) {
    }

    @Override
    public void onEnter(MouseEvent me) {
    }

    @Override
    public void onClick(MouseEvent me) {
        List bars = this.getSymbols();
        for (SymbolComponent symbolComponent : bars) {
            if (!(symbolComponent instanceof PointSymbol) || ((PointSymbol)symbolComponent).getSensibleShape() == null || !((PointSymbol)symbolComponent).getSensibleShape().contains(me.getX(), me.getY()) || !((PointSymbol)symbolComponent).isLockEnter()) continue;
            this.fireBarClicked((PointSymbol)symbolComponent);
        }
    }

    @Override
    public void onMove(MouseEvent me) {
        List bars = this.getSymbols();
        for (SymbolComponent symbolComponent : bars) {
            if (!(symbolComponent instanceof PointSymbol)) continue;
            this.barEnterExitTracker((PointSymbol)symbolComponent, me.getX(), me.getY());
        }
    }

    private void barEnterExitTracker(PointSymbol point, int x, int y) {
        if (point.getSensibleShape() == null) {
            return;
        }
        if (point.getSensibleShape().contains(x, y) && !point.isLockEnter()) {
            point.lockEnter();
            this.fireBarEntered(point);
        } else if (!point.getSensibleShape().contains(x, y) && point.isLockEnter()) {
            point.unlockEnter();
            this.fireBarExited(point);
        }
    }

    @Override
    public void onDrag(MouseEvent me) {
        List bars = this.getSymbols();
        for (SymbolComponent symbolComponent : bars) {
            if (!(symbolComponent instanceof PointSymbol)) continue;
            this.barEnterExitTracker((PointSymbol)symbolComponent, me.getX(), me.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBarEntered(PointSymbol point) {
        Object[] listeners;
        Object[] objectArray = listeners = this.symbolListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PointListener.class) continue;
                ((PointListener)listeners[i + 1]).pointSymbolEntered(new PointEvent(point));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBarExited(PointSymbol point) {
        Object[] listeners;
        Object[] objectArray = listeners = this.symbolListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PointListener.class) continue;
                ((PointListener)listeners[i + 1]).pointSymbolExited(new PointEvent(point));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBarClicked(PointSymbol point) {
        Object[] listeners;
        Object[] objectArray = listeners = this.symbolListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PointListener.class) continue;
                ((PointListener)listeners[i + 1]).pointSymbolClicked(new PointEvent(point));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBarPressed(PointSymbol point) {
        Object[] listeners;
        Object[] objectArray = listeners = this.symbolListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PointListener.class) continue;
                ((PointListener)listeners[i + 1]).pointSymbolPressed(new PointEvent(point));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBarReleased(PointSymbol point) {
        Object[] listeners;
        Object[] objectArray = listeners = this.symbolListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PointListener.class) continue;
                ((PointListener)listeners[i + 1]).pointSymbolReleased(new PointEvent(point));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

