/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Fractional;
import org.jensoft.core.graphics.Interpolation;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.symbol.SymbolComponent;
import org.jensoft.core.plugin.symbol.SymbolLayer;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class SymbolPlugin
extends AbstractPlugin
implements AbstractPlugin.OnClickListener,
AbstractPlugin.OnEnterListener,
AbstractPlugin.OnExitListener,
AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnMoveListener,
AbstractPlugin.OnDragListener {
    private SymbolNature symbolNature;
    private List<SymbolLayer<? extends SymbolComponent>> layers = new ArrayList<SymbolLayer<? extends SymbolComponent>>();

    public SymbolPlugin() {
        this.setName(this.getClass().getSimpleName());
        this.setAntialiasing(Antialiasing.On);
        this.setTextAntialising(TextAntialiasing.On);
        this.setFractionalMetrics(Fractional.On);
        this.setInterpolation(Interpolation.Bicubic);
        this.setOnMoveListener(this);
        this.setOnClickListener(this);
        this.setOnReleaseListener(this);
        this.setOnPressListener(this);
        this.setOnDragListener(this);
        this.setPriority(500);
    }

    public SymbolNature getNature() {
        return this.symbolNature;
    }

    public void setNature(SymbolNature symbolNature) {
        this.symbolNature = symbolNature;
    }

    public void addLayer(SymbolLayer<? extends SymbolComponent> layer) {
        layer.setHost(this);
        this.layers.add(layer);
    }

    public void removeLayer(SymbolLayer<? extends SymbolComponent> layer) {
        layer.setHost(null);
        this.layers.remove(layer);
    }

    public int countLayers() {
        return this.layers.size();
    }

    public SymbolLayer<? extends SymbolComponent> getLayer(int index) {
        return this.layers.get(index);
    }

    @Override
    public final void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        this.solveLayers();
        for (int i = 0; i < this.countLayers(); ++i) {
            SymbolLayer<? extends SymbolComponent> layer = this.getLayer(i);
            layer.paintLayer(v2d, g2d, viewPart, PaintRequest.SymbolLayer);
            layer.paintLayer(v2d, g2d, viewPart, PaintRequest.LabelLayer);
        }
    }

    private void solveLayers() {
        for (int i = 0; i < this.countLayers(); ++i) {
            SymbolLayer<? extends SymbolComponent> layer = this.getLayer(i);
            layer.solveGeometry();
        }
    }

    @Override
    public void onRelease(MouseEvent me) {
        for (int i = 0; i < this.countLayers(); ++i) {
            SymbolLayer<? extends SymbolComponent> layer = this.getLayer(i);
            layer.onRelease(me);
        }
    }

    @Override
    public void onPress(MouseEvent me) {
        for (int i = 0; i < this.countLayers(); ++i) {
            SymbolLayer<? extends SymbolComponent> layer = this.getLayer(i);
            layer.onPress(me);
        }
    }

    @Override
    public void onExit(MouseEvent me) {
        for (int i = 0; i < this.countLayers(); ++i) {
            SymbolLayer<? extends SymbolComponent> layer = this.getLayer(i);
            layer.onExit(me);
        }
    }

    @Override
    public void onEnter(MouseEvent me) {
        for (int i = 0; i < this.countLayers(); ++i) {
            SymbolLayer<? extends SymbolComponent> layer = this.getLayer(i);
            layer.onEnter(me);
        }
    }

    @Override
    public void onClick(MouseEvent me) {
        for (int i = 0; i < this.countLayers(); ++i) {
            SymbolLayer<? extends SymbolComponent> layer = this.getLayer(i);
            layer.onClick(me);
        }
    }

    @Override
    public void onMove(MouseEvent me) {
        for (int i = 0; i < this.countLayers(); ++i) {
            SymbolLayer<? extends SymbolComponent> layer = this.getLayer(i);
            layer.onMove(me);
        }
    }

    @Override
    public void onDrag(MouseEvent me) {
        for (int i = 0; i < this.countLayers(); ++i) {
            SymbolLayer<? extends SymbolComponent> layer = this.getLayer(i);
            layer.onDrag(me);
        }
    }

    public static enum PaintRequest {
        SymbolLayer,
        LabelLayer;

    }

    public static enum SymbolNature {
        Vertical("vertical"),
        Horizontal("horizontal");

        private String symbolNature;

        private SymbolNature(String nature) {
            this.symbolNature = nature;
        }

        public String getBarNature() {
            return this.symbolNature;
        }

        public static SymbolNature parse(String nature) {
            if (Vertical.getBarNature().equals(nature)) {
                return Vertical;
            }
            if (Horizontal.getBarNature().equals(nature)) {
                return Horizontal;
            }
            return null;
        }
    }
}

