/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol.painter.effect;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.plugin.symbol.BarSymbol;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.plugin.symbol.painter.effect.AbstractBarEffect;
import org.jensoft.core.projection.Projection;

public class BarEffect4
extends AbstractBarEffect {
    @Override
    public void paintBarEffect(Graphics2D g2d, BarSymbol bar) {
        if (bar.getNature() == SymbolPlugin.SymbolNature.Vertical) {
            this.paintEffectVBar_ef2(g2d, bar);
        }
        if (bar.getNature() == SymbolPlugin.SymbolNature.Horizontal) {
            this.paintEffectHBar_ef2(g2d, bar);
        }
    }

    private void paintEffectVBar_ef2(Graphics2D g2d, BarSymbol bar) {
        if (bar.getHost() == null || bar.getHost().getProjection() == null) {
            return;
        }
        Projection w2d = bar.getHost().getProjection();
        Point2D.Double p2dUser = null;
        if (bar.isAscent()) {
            p2dUser = new Point2D.Double(0.0, bar.getBase() + bar.getValue());
        }
        if (bar.isDescent()) {
            p2dUser = new Point2D.Double(0.0, bar.getBase() - bar.getValue());
        }
        Point2D p2ddevice = w2d.userToPixel(p2dUser);
        Point2D.Double p2dUserBase = new Point2D.Double(0.0, bar.getBase());
        Point2D p2ddeviceBase = w2d.userToPixel(p2dUserBase);
        double x = bar.getLocationX();
        double y = (int)p2ddevice.getY();
        if (bar.isDescent()) {
            y = (int)p2ddeviceBase.getY();
        }
        double width = bar.getThickness();
        double height = Math.abs(p2ddeviceBase.getY() - p2ddevice.getY());
        Shape shapeEffect = null;
        int inset = 2;
        x += (double)inset;
        y += (double)inset;
        width -= (double)(2 * inset);
        height -= (double)(2 * inset);
        if (bar.getMorpheStyle() == BarSymbol.MorpheStyle.Round) {
            GeneralPath barPath;
            double round = bar.getRound();
            if (bar.isAscent()) {
                barPath = new GeneralPath();
                barPath.moveTo(x, y + round);
                barPath.quadTo(x + width / 2.0, y + height / 2.0, x, y + height);
                barPath.lineTo(x + width, y + height);
                barPath.quadTo(x + width / 2.0, y + height / 2.0, x + width, y + round);
                barPath.quadTo(x + width, y, x + width - round, y);
                barPath.lineTo(x + round, y);
                barPath.quadTo(x, y, x, y + round);
                barPath.closePath();
                shapeEffect = barPath;
            } else if (bar.isDescent()) {
                barPath = new GeneralPath();
                barPath.moveTo(x, y);
                barPath.quadTo(x + width / 2.0, y + height / 2.0, x, y + height - round);
                barPath.quadTo(x, y + height, x + round, y + height);
                barPath.lineTo(x + width - round, y + height);
                barPath.quadTo(x + width, y + height, x + width, y + height - round);
                barPath.quadTo(x + width / 2.0, y + height / 2.0, x + width, y);
                barPath.closePath();
                shapeEffect = barPath;
            }
        } else if (bar.getMorpheStyle() == BarSymbol.MorpheStyle.Rectangle) {
            GeneralPath barPath = new GeneralPath();
            barPath.moveTo(x, y);
            barPath.quadTo(x + width / 2.0, y + height / 2.0, x, y + height);
            barPath.lineTo(x + width, y + height);
            barPath.quadTo(x + width / 2.0, y + height / 2.0, x + width, y);
            barPath.closePath();
            shapeEffect = barPath;
        }
        Rectangle2D boun2D2 = shapeEffect.getBounds2D();
        Point2D.Double start = null;
        Point2D.Double end = null;
        if (bar.isAscent()) {
            start = new Point2D.Double(boun2D2.getX(), boun2D2.getY());
            end = new Point2D.Double(boun2D2.getX(), boun2D2.getY() + boun2D2.getHeight());
        } else if (bar.isDescent()) {
            start = new Point2D.Double(boun2D2.getX(), boun2D2.getY() + boun2D2.getHeight());
            end = new Point2D.Double(boun2D2.getX(), boun2D2.getY());
        }
        float[] dist = new float[]{0.0f, 0.33f, 0.66f, 1.0f};
        Color[] colors = new Color[]{new Color(255, 255, 255, 180), new Color(255, 255, 255, 0), new Color(40, 40, 40, 0), new Color(40, 40, 40, 100)};
        LinearGradientPaint p2 = new LinearGradientPaint(start, end, dist, colors);
        g2d.setPaint(p2);
        g2d.fill(shapeEffect);
    }

    private void paintEffectHBar_ef2(Graphics2D g2d, BarSymbol bar) {
        Projection w2d = bar.getHost().getProjection();
        Point2D.Double p2dUser = null;
        if (bar.isAscent()) {
            p2dUser = new Point2D.Double(bar.getBase() + bar.getValue(), 0.0);
        }
        if (bar.isDescent()) {
            p2dUser = new Point2D.Double(bar.getBase() - bar.getValue(), 0.0);
        }
        Point2D p2ddevice = w2d.userToPixel(p2dUser);
        Point2D.Double p2dUserBase = new Point2D.Double(bar.getBase(), 0.0);
        Point2D p2ddeviceBase = w2d.userToPixel(p2dUserBase);
        double y = bar.getLocationY();
        double x = (int)p2ddeviceBase.getX();
        if (bar.isAscent()) {
            x = (int)p2ddeviceBase.getX();
        }
        if (bar.isDescent()) {
            x = (int)p2ddevice.getX();
        }
        double height = bar.getThickness();
        double width = Math.abs(p2ddevice.getX() - p2ddeviceBase.getX());
        GeneralPath shapeEffect = null;
        int inset = 2;
        x += (double)inset;
        y += (double)inset;
        width -= (double)(2 * inset);
        height -= (double)(2 * inset);
        if (bar.getMorpheStyle() == BarSymbol.MorpheStyle.Round) {
            double round = bar.getRound();
            GeneralPath barPath = new GeneralPath();
            if (bar.isAscent()) {
                barPath.moveTo(x, y);
                barPath.quadTo(x + width / 2.0, y + height / 2.0, x + width - round, y);
                barPath.quadTo(x + width, y, x + width, y + round);
                barPath.lineTo(x + width, y + height - round);
                barPath.quadTo(x + width, y + height, x + width - round, y + height);
                barPath.quadTo(x + width / 2.0, y + height / 2.0, x, y + height);
                barPath.closePath();
            } else if (bar.isDescent()) {
                barPath.moveTo(x + round, y);
                barPath.quadTo(x + width / 2.0, y + height / 2.0, x + width, y);
                barPath.lineTo(x + width, y + height);
                barPath.quadTo(x + width / 2.0, y + height / 2.0, x + round, y + height);
                barPath.quadTo(x, y + height, x, y + height - round);
                barPath.lineTo(x, y + round);
                barPath.quadTo(x, y, x + round, y);
                barPath.closePath();
            }
            shapeEffect = barPath;
        } else {
            GeneralPath barPath = new GeneralPath();
            barPath.moveTo(x, y);
            barPath.quadTo(x + width / 2.0, y + height / 2.0, x + width, y);
            barPath.lineTo(x + width, y + height);
            barPath.quadTo(x + width / 2.0, y + height / 2.0, x, y + height);
            barPath.closePath();
            shapeEffect = barPath;
        }
        Rectangle2D boun2D2 = shapeEffect.getBounds2D();
        Point2D.Double start = null;
        Point2D.Double end = null;
        if (bar.isAscent()) {
            start = new Point2D.Double(boun2D2.getX() + boun2D2.getWidth(), boun2D2.getY());
            end = new Point2D.Double(boun2D2.getX(), boun2D2.getY());
        } else if (bar.isDescent()) {
            start = new Point2D.Double(boun2D2.getX(), boun2D2.getY());
            end = new Point2D.Double(boun2D2.getX() + boun2D2.getWidth(), boun2D2.getY());
        }
        float[] dist = new float[]{0.0f, 0.33f, 0.66f, 1.0f};
        Color[] colors2 = new Color[]{new Color(255, 255, 255, 180), new Color(255, 255, 255, 0), new Color(40, 40, 40, 0), new Color(40, 40, 40, 100)};
        LinearGradientPaint p2 = new LinearGradientPaint(start, end, dist, colors2);
        g2d.setPaint(p2);
        g2d.fill(shapeEffect);
    }
}

