/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol.painter.label;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.symbol.BarSymbol;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.plugin.symbol.painter.label.AbstractBarLabel;

public class BarSymbolRelativeLabel
extends AbstractBarLabel {
    private VerticalAlignment verticalAlignment = VerticalAlignment.Middle;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.Middle;
    private Font font;
    private Color drawColor;
    private Color fillColor;
    private DecimalFormat decimalFormat = new DecimalFormat("##.00");
    private String label;
    private Color labelColor;
    private int offsetX = 5;
    private int offsetY = 5;
    private int textPaddingX = 5;
    private int textPaddingY = 2;
    private int outlineRound = 6;
    private float alpha = 1.0f;
    private Stroke outlineStroke = new BasicStroke();
    private Shader shader;

    public BarSymbolRelativeLabel() {
    }

    public BarSymbolRelativeLabel(Color drawColor, Color fillColor, Color labelColor) {
        this.drawColor = drawColor;
        this.fillColor = fillColor;
        this.labelColor = labelColor;
    }

    public BarSymbolRelativeLabel(VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment, Color drawColor, Color fillColor, Color labelColor) {
        this.verticalAlignment = verticalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        this.drawColor = drawColor;
        this.fillColor = fillColor;
        this.labelColor = labelColor;
    }

    public BarSymbolRelativeLabel(VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment, Color drawColor, Color fillColor, Color labelColor, float alpha) {
        this(verticalAlignment, horizontalAlignment, drawColor, fillColor, labelColor);
        this.alpha = alpha;
    }

    public BarSymbolRelativeLabel(String label, Color labelColor, Font font) {
        this.label = label;
        this.labelColor = labelColor;
        this.font = font;
    }

    public BarSymbolRelativeLabel(VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.horizontalAlignment = horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public Shader getShader() {
        return this.shader;
    }

    public void setShader(Shader shader) {
        this.shader = shader;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setTextColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public String getLabel() {
        return this.label;
    }

    public void setText(String label) {
        this.label = label;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public int getTextPaddingX() {
        return this.textPaddingX;
    }

    public void setTextPaddingX(int textPaddingX) {
        this.textPaddingX = textPaddingX;
    }

    public int getTextPaddingY() {
        return this.textPaddingY;
    }

    public void setTextPaddingY(int testPaddingY) {
        this.textPaddingY = testPaddingY;
    }

    public int getOutlineRound() {
        return this.outlineRound;
    }

    public void setOutlineRound(int outlineRound) {
        this.outlineRound = outlineRound;
    }

    @Override
    public void paintBarLabel(Graphics2D g2d, BarSymbol bar) {
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        if (bar.getHost().getNature() == SymbolPlugin.SymbolNature.Vertical) {
            this.paintVLabel(g2d, bar);
        }
        if (bar.getHost().getNature() == SymbolPlugin.SymbolNature.Horizontal) {
            this.paintHLabel(g2d, bar);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    private void paintHLabel(Graphics2D g2d, BarSymbol bar) {
        double value = bar.getValue();
        String sVal = this.decimalFormat.format(value);
        if (this.getLabel() != null) {
            sVal = this.getLabel();
        }
        this.drawStickers(g2d, bar);
        if (this.getLabelColor() == null) {
            this.setTextColor(Color.DARK_GRAY);
        }
        g2d.setColor(this.getLabelColor());
        g2d.drawString(sVal, (int)this.getX(g2d, bar), (int)this.getY(g2d, bar));
    }

    private void paintVLabel(Graphics2D g2d, BarSymbol bar) {
        double value = bar.getValue();
        String sVal = this.decimalFormat.format(value);
        if (this.getLabel() != null) {
            sVal = this.getLabel();
        }
        this.drawStickers(g2d, bar);
        if (this.getLabelColor() == null) {
            this.setTextColor(Color.DARK_GRAY);
        }
        g2d.setColor(this.getLabelColor());
        g2d.drawString(sVal, (int)this.getX(g2d, bar), (int)this.getY(g2d, bar));
    }

    private void drawStickers(Graphics2D g2d, BarSymbol bar) {
        if (this.getFillColor() != null || this.getDrawColor() != null || this.getShader() != null) {
            if (this.font == null) {
                this.setFont(new Font("Dialog", 0, 12));
            }
            g2d.setFont(this.getFont());
            FontMetrics fm = g2d.getFontMetrics();
            RoundRectangle2D.Double sticker = new RoundRectangle2D.Double((int)this.getX(g2d, bar) - this.textPaddingX, (int)this.getY(g2d, bar) - fm.getAscent() - this.textPaddingY, this.getLabelWidth(g2d, bar) + (double)(2 * this.textPaddingX), fm.getHeight() + 2 * this.textPaddingY, this.outlineRound, this.outlineRound);
            if (this.getFillColor() != null && this.getShader() == null) {
                g2d.setColor(this.getFillColor());
                g2d.fill(sticker);
            }
            if (this.getShader() != null) {
                Point2D.Double start = new Point2D.Double(sticker.getCenterX(), ((RectangularShape)sticker).getY());
                Point2D.Double end = new Point2D.Double(sticker.getCenterX(), ((RectangularShape)sticker).getY() + ((RectangularShape)sticker).getHeight());
                if (start != null && end != null && !start.equals(end)) {
                    LinearGradientPaint lgp = new LinearGradientPaint(start, end, this.getShader().getFractions(), this.getShader().getColors());
                    g2d.setPaint(lgp);
                    g2d.fill(sticker);
                }
            }
            if (this.getDrawColor() != null) {
                g2d.setColor(this.getDrawColor());
                if (this.outlineStroke != null) {
                    g2d.setStroke(this.getOutlineStroke());
                }
                g2d.draw(sticker);
            }
        }
    }

    public double getLabelWidth(Graphics2D g2d, BarSymbol bar) {
        if (this.font == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        double value = bar.getValue();
        String sVal = this.decimalFormat.format(value);
        if (this.getLabel() != null) {
            sVal = this.getLabel();
        }
        int labelWidth = fm.stringWidth(sVal);
        return labelWidth;
    }

    private double getX(Graphics2D g2d, BarSymbol bar) {
        double x = 0.0;
        Shape barShape = bar.getBarShape();
        if (this.horizontalAlignment == HorizontalAlignment.WestLeft) {
            double west = barShape.getBounds2D().getX();
            x = west - this.getLabelWidth(g2d, bar) - (double)this.offsetX - (double)this.textPaddingX;
        } else if (this.horizontalAlignment == HorizontalAlignment.WestAcross) {
            double west = barShape.getBounds2D().getX();
            x = west - this.getLabelWidth(g2d, bar) / 2.0;
        } else if (this.horizontalAlignment == HorizontalAlignment.WestRight) {
            double west = barShape.getBounds2D().getX();
            x = west + (double)this.offsetX + (double)this.textPaddingX;
        } else if (this.horizontalAlignment == HorizontalAlignment.Middle) {
            double centerX = barShape.getBounds2D().getCenterX();
            x = centerX - this.getLabelWidth(g2d, bar) / 2.0;
        } else if (this.horizontalAlignment == HorizontalAlignment.EastLeft) {
            double east = barShape.getBounds2D().getX() + barShape.getBounds2D().getWidth();
            x = east - this.getLabelWidth(g2d, bar) - (double)this.offsetX - (double)this.textPaddingX;
        } else if (this.horizontalAlignment == HorizontalAlignment.EastAcross) {
            double east = barShape.getBounds2D().getX() + barShape.getBounds2D().getWidth();
            x = east - this.getLabelWidth(g2d, bar) / 2.0;
        } else if (this.horizontalAlignment == HorizontalAlignment.EastRight) {
            double east = barShape.getBounds2D().getX() + barShape.getBounds2D().getWidth() + (double)this.offsetX;
            x = east + (double)this.textPaddingX;
        }
        return x;
    }

    private double getY(Graphics2D g2d, BarSymbol bar) {
        double y = 0.0;
        if (this.font == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        Shape barShape = bar.getBarShape();
        if (this.verticalAlignment == VerticalAlignment.NorthTop) {
            y = barShape.getBounds2D().getY() - (double)(fm.getDescent() + this.offsetY + this.textPaddingY);
        } else if (this.verticalAlignment == VerticalAlignment.NorthAcross) {
            y = barShape.getBounds2D().getY() + (double)(fm.getAscent() / 2);
        } else if (this.verticalAlignment == VerticalAlignment.NorthBottom) {
            y = barShape.getBounds2D().getY() + (double)(fm.getHeight() + this.offsetY + this.textPaddingY);
        } else if (this.verticalAlignment == VerticalAlignment.Middle) {
            y = barShape.getBounds2D().getY() + barShape.getBounds2D().getHeight() / 2.0 + (double)(fm.getAscent() / 2);
        } else if (this.verticalAlignment == VerticalAlignment.SouthTop) {
            y = barShape.getBounds2D().getY() + barShape.getBounds2D().getHeight() - (double)(fm.getAscent() + this.offsetY + this.textPaddingY);
        } else if (this.verticalAlignment == VerticalAlignment.SouthAcross) {
            y = barShape.getBounds2D().getY() + barShape.getBounds2D().getHeight() + (double)(fm.getAscent() / 2);
        } else if (this.verticalAlignment == VerticalAlignment.SouthBottom) {
            y = barShape.getBounds2D().getY() + barShape.getBounds2D().getHeight() + (double)(fm.getAscent() + this.offsetY + this.textPaddingY);
        }
        return y;
    }

    public static enum HorizontalAlignment {
        WestLeft("WestLeft"),
        WestAcross("WestAcross"),
        WestRight("WestRight"),
        Middle("Middle"),
        EastLeft("EastLeft"),
        EastAcross("EastAcross"),
        EastRight("EastRight");

        private String horizontalAlign;

        private HorizontalAlignment(String horizontalAlign) {
            this.horizontalAlign = horizontalAlign;
        }

        public String getHorizontalAlign() {
            return this.horizontalAlign;
        }

        public static HorizontalAlignment parse(String align) {
            if (WestLeft.getHorizontalAlign().equalsIgnoreCase(align)) {
                return WestLeft;
            }
            if (WestAcross.getHorizontalAlign().equalsIgnoreCase(align)) {
                return WestAcross;
            }
            if (WestRight.getHorizontalAlign().equalsIgnoreCase(align)) {
                return WestRight;
            }
            if (Middle.getHorizontalAlign().equalsIgnoreCase(align)) {
                return Middle;
            }
            if (EastLeft.getHorizontalAlign().equalsIgnoreCase(align)) {
                return EastLeft;
            }
            if (EastAcross.getHorizontalAlign().equalsIgnoreCase(align)) {
                return EastAcross;
            }
            if (EastRight.getHorizontalAlign().equalsIgnoreCase(align)) {
                return EastRight;
            }
            return Middle;
        }
    }

    public static enum VerticalAlignment {
        NorthTop("NorthTop"),
        NorthAcross("NorthAcross"),
        NorthBottom("NorthBottom"),
        Middle("Middle"),
        SouthTop("SouthTop"),
        SouthAcross("SouthAcross"),
        SouthBottom("SouthBottom");

        private String verticalAlign;

        private VerticalAlignment(String verticalAlign) {
            this.verticalAlign = verticalAlign;
        }

        public String getVerticalAlign() {
            return this.verticalAlign;
        }

        public static VerticalAlignment parse(String align) {
            if (NorthTop.getVerticalAlign().equalsIgnoreCase(align)) {
                return NorthTop;
            }
            if (NorthAcross.getVerticalAlign().equalsIgnoreCase(align)) {
                return NorthAcross;
            }
            if (NorthBottom.getVerticalAlign().equalsIgnoreCase(align)) {
                return NorthBottom;
            }
            if (Middle.getVerticalAlign().equalsIgnoreCase(align)) {
                return Middle;
            }
            if (SouthTop.getVerticalAlign().equalsIgnoreCase(align)) {
                return SouthTop;
            }
            if (SouthAcross.getVerticalAlign().equalsIgnoreCase(align)) {
                return SouthAcross;
            }
            if (SouthBottom.getVerticalAlign().equalsIgnoreCase(align)) {
                return SouthBottom;
            }
            return Middle;
        }
    }
}

