/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol.painter.point;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import org.jensoft.core.drawable.ImageDrawable;
import org.jensoft.core.plugin.symbol.PointSymbol;
import org.jensoft.core.plugin.symbol.painter.point.AbstractPointSymbolPainter;

public class PointSymbolImage
extends AbstractPointSymbolPainter {
    private ImageDrawable imageDrawable;
    private int offsetX;
    private int offsetY;

    public PointSymbolImage(Image image) {
        this.imageDrawable = new ImageDrawable(image);
    }

    public PointSymbolImage(Image image, int offsetX, int offsetY) {
        this.imageDrawable = new ImageDrawable(image);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    @Override
    protected void paintPointSymbol(Graphics2D g2d, PointSymbol point) {
        Point2D p = point.getDevicePoint();
        this.imageDrawable.setX((int)(p.getX() + (double)this.offsetX));
        this.imageDrawable.setY((int)(p.getY() + (double)this.offsetY));
        this.imageDrawable.draw(g2d);
    }
}

