/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol.painter.polyline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.List;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.symbol.PointSymbol;
import org.jensoft.core.plugin.symbol.PolylinePointSymbol;
import org.jensoft.core.plugin.symbol.painter.polyline.AbstractPolylinePointSymbolPainter;

public class PolylinePointSymbolDefaultPainter
extends AbstractPolylinePointSymbolPainter {
    private Color polylineColor = TangoPalette.SCARLETRED1;
    private Stroke polylineStroke = new BasicStroke();

    public PolylinePointSymbolDefaultPainter() {
    }

    public PolylinePointSymbolDefaultPainter(Color polylineColor) {
        this.polylineColor = polylineColor;
    }

    public Color getPolylineColor() {
        return this.polylineColor;
    }

    public void setPolylineColor(Color polylineColor) {
        this.polylineColor = polylineColor;
    }

    public Stroke getPolylineStroke() {
        return this.polylineStroke;
    }

    public void setPolylineStroke(Stroke polylineStroke) {
        this.polylineStroke = polylineStroke;
    }

    @Override
    protected void paintPolylinePointSymbol(Graphics2D g2d, PolylinePointSymbol polyline) {
        g2d.setColor(this.polylineColor);
        GeneralPath path = new GeneralPath();
        List<PointSymbol> points = polyline.getSymbolComponents();
        for (int i = 0; i < points.size(); ++i) {
            PointSymbol point = points.get(i);
            if (point.isFiller()) continue;
            if (i == 0) {
                path.moveTo(point.getDevicePoint().getX(), point.getDevicePoint().getY());
                continue;
            }
            path.lineTo(point.getDevicePoint().getX(), point.getDevicePoint().getY());
        }
        if (path != null) {
            g2d.draw(path);
        }
    }
}

