/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.translate;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jensoft.core.device.ContextEntry;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.translate.TranslatePlugin;
import org.jensoft.core.plugin.translate.TranslatePluginEvent;
import org.jensoft.core.plugin.translate.TranslatePluginListener;
import org.jensoft.core.sharedicon.SharedIcon;
import org.jensoft.core.sharedicon.common.Common;

public class TranslateDefaultDeviceContext
extends ContextEntry<TranslatePlugin> {
    private JMenu translateMenu;
    private JMenuItem translateActive;
    private JMenuItem translateR2LActive;
    private JMenuItem translateB2TActive;
    private JMenuItem replayItem;
    private ImageIcon translateIcon;
    private ImageIcon lockIcon;
    private ImageIcon unlockIcon;
    private ImageIcon replayIcon;

    private void updateState() {
        if (((TranslatePlugin)this.getHost()).isLockSelected()) {
            this.translateActive.setIcon(this.lockIcon);
            this.translateActive.setText("release");
            this.translateR2LActive.setEnabled(true);
            this.translateB2TActive.setEnabled(true);
            this.replayItem.setEnabled(true);
        } else {
            this.translateActive.setIcon(this.unlockIcon);
            this.translateActive.setText("lock");
            this.translateR2LActive.setEnabled(false);
            this.translateB2TActive.setEnabled(false);
            this.replayItem.setEnabled(false);
        }
    }

    @Override
    public void buildContext() {
        if (this.getHost() == null) {
            return;
        }
        this.translateIcon = SharedIcon.getCommon(Common.TRANSLATE);
        this.lockIcon = SharedIcon.getCommon(Common.LOCK);
        this.unlockIcon = SharedIcon.getCommon(Common.UNLOCK);
        this.replayIcon = SharedIcon.getCommon(Common.RUN);
        this.translateMenu = new JMenu("Translate");
        this.translateMenu.setIcon(this.translateIcon);
        this.translateActive = new JMenuItem();
        this.translateActive.addActionListener(((TranslatePlugin)this.getHost()).getTranslateLockUnlockAction());
        this.translateMenu.add(this.translateActive);
        this.translateMenu.addSeparator();
        this.translateR2LActive = new JMenuItem("R2L");
        this.translateR2LActive.addActionListener(((TranslatePlugin)this.getHost()).getTranslateL2RAction());
        if (((TranslatePlugin)this.getHost()).isLockL2R()) {
            this.translateR2LActive.setIcon(this.lockIcon);
        } else {
            this.translateR2LActive.setIcon(this.unlockIcon);
        }
        this.translateB2TActive = new JMenuItem("B2T");
        this.translateB2TActive.addActionListener(((TranslatePlugin)this.getHost()).getTranslateB2TAction());
        if (((TranslatePlugin)this.getHost()).isLockB2T()) {
            this.translateB2TActive.setIcon(this.lockIcon);
        } else {
            this.translateB2TActive.setIcon(this.unlockIcon);
        }
        this.translateMenu.add(this.translateB2TActive);
        this.translateMenu.add(this.translateR2LActive);
        this.translateMenu.addSeparator();
        this.replayItem = new JMenuItem("Replay");
        this.replayItem.setIcon(this.replayIcon);
        this.replayItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((TranslatePlugin)TranslateDefaultDeviceContext.this.getHost()).startReplay();
            }
        });
        this.translateMenu.add(this.replayItem);
        this.setGroup("translate");
        this.setItem(this.translateMenu);
        ((TranslatePlugin)this.getHost()).addTranslateListener(new TranslatePluginListener(){

            @Override
            public void pluginSelected(PluginEvent<TranslatePlugin> pluginEvent) {
                TranslateDefaultDeviceContext.this.updateState();
            }

            @Override
            public void pluginUnlockSelected(PluginEvent<TranslatePlugin> pluginEvent) {
                TranslateDefaultDeviceContext.this.updateState();
            }

            @Override
            public void translated(TranslatePluginEvent pluginEvent) {
            }

            @Override
            public void translateStoped(TranslatePluginEvent pluginEvent) {
            }

            @Override
            public void translateStarted(TranslatePluginEvent pluginEvent) {
            }

            @Override
            public void translateL2RChanged(TranslatePluginEvent pluginEvent) {
                TranslatePlugin t = (TranslatePlugin)pluginEvent.getPlugin();
                if (t.isLockL2R()) {
                    TranslateDefaultDeviceContext.this.translateR2LActive.setIcon(TranslateDefaultDeviceContext.this.lockIcon);
                } else {
                    TranslateDefaultDeviceContext.this.translateR2LActive.setIcon(TranslateDefaultDeviceContext.this.unlockIcon);
                }
            }

            @Override
            public void translateB2TChanged(TranslatePluginEvent pluginEvent) {
                TranslatePlugin t = (TranslatePlugin)pluginEvent.getPlugin();
                if (t.isLockB2T()) {
                    TranslateDefaultDeviceContext.this.translateB2TActive.setIcon(TranslateDefaultDeviceContext.this.lockIcon);
                } else {
                    TranslateDefaultDeviceContext.this.translateB2TActive.setIcon(TranslateDefaultDeviceContext.this.unlockIcon);
                }
            }
        });
        this.updateState();
        this.setGroup("translate");
        this.setItem(this.translateMenu);
    }

    @Override
    public boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof TranslatePlugin;
    }
}

