/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.translate;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.plugin.translate.TranslatePlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.widget.pad.AbstractBackwardForwardPadWidget;

public class TranslatePad
extends AbstractBackwardForwardPadWidget<TranslatePlugin> {
    public static final String translatePadID = "@widget/translate/pad";
    private static final int widgetRadius = 32;
    private Color baseDrawColor;
    private Color controlDrawColor;
    private Color buttonDrawColor;
    private Color buttonRolloverDrawColor = RosePalette.LEMONPEEL;
    private Stroke buttonStroke = new BasicStroke(1.6f, 2, 0);

    public TranslatePad(String id, double squarePad, int xIndex, int yIndex) {
        super(translatePadID, squarePad, xIndex, yIndex);
        this.init();
    }

    public TranslatePad() {
        super(translatePadID, 64.0, 60, 100);
        this.init();
    }

    private void init() {
        this.setFillBaseColor(Color.BLACK);
        this.setFillControlColor(ColorPalette.BLACK);
        this.setDrawBaseColor(this.baseDrawColor);
        this.setDrawControlColor(this.controlDrawColor);
        this.setDrawButtonColor(this.buttonDrawColor);
        this.setDrawButtonStroke(this.buttonStroke);
        this.setDrawButtonRolloverColor(this.buttonRolloverDrawColor);
        this.getPadGeometry().setInset(6);
    }

    @Override
    protected void paintWidget(View v2d, Graphics2D g2d) {
        super.paintWidget(v2d, g2d);
    }

    @Override
    public boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof TranslatePlugin;
    }

    @Override
    public void onNorthButtonPress() {
        if (!((TranslatePlugin)this.getHost()).isLockSelected()) {
            return;
        }
        ((TranslatePlugin)this.getHost()).shift(TranslatePlugin.ShiftDirection.North);
        super.onNorthButtonPress();
    }

    @Override
    public void onNorthButtonReleased() {
        super.onNorthButtonReleased();
    }

    @Override
    public void onSouthButtonPress() {
        if (!((TranslatePlugin)this.getHost()).isLockSelected()) {
            return;
        }
        ((TranslatePlugin)this.getHost()).shift(TranslatePlugin.ShiftDirection.South);
        super.onSouthButtonPress();
    }

    @Override
    public void onSouthButtonReleased() {
        super.onSouthButtonReleased();
    }

    @Override
    public void onWestButtonPress() {
        if (!((TranslatePlugin)this.getHost()).isLockSelected()) {
            return;
        }
        ((TranslatePlugin)this.getHost()).shift(TranslatePlugin.ShiftDirection.West);
        super.onWestButtonPress();
    }

    @Override
    public void onWestButtonReleased() {
        super.onWestButtonReleased();
    }

    @Override
    public void onEastButtonPress() {
        if (!((TranslatePlugin)this.getHost()).isLockSelected()) {
            return;
        }
        ((TranslatePlugin)this.getHost()).shift(TranslatePlugin.ShiftDirection.East);
        super.onEastButtonPress();
    }

    @Override
    public void onEastButtonReleased() {
        super.onEastButtonReleased();
    }
}

