/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.window;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jensoft.core.device.ContextEntry;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.sharedicon.SharedIcon;
import org.jensoft.core.sharedicon.common.Common;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class ProjectionBoundPlugin
extends AbstractPlugin {
    public ProjectionBoundPlugin() {
        this.registerContext(new WindowShiftPluginDeviceContext());
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
    }

    public class WindowShiftPluginDeviceContext
    extends ContextEntry<ProjectionBoundPlugin> {
        private JMenu shiftMenu;
        private ImageIcon shiftIcon;

        @Override
        public void buildContext() {
            if (this.getHost() == null) {
                return;
            }
            this.shiftIcon = SharedIcon.getCommon(Common.TRANSLATE);
            this.shiftMenu = new JMenu("Windows");
            this.shiftMenu.setIcon(this.shiftIcon);
            List<Projection> windows = ((ProjectionBoundPlugin)this.getHost()).getProjection().getView().getProjections();
            int count = 1;
            for (final Projection window2d : windows) {
                if (window2d.getName() == null) {
                    window2d.setName("window-" + count);
                }
                ++count;
                JMenuItem windowSwitch = new JMenuItem(window2d.getName());
                if (window2d.isLockActive()) {
                    windowSwitch.setIcon(SharedIcon.getCommon(Common.LOCK));
                }
                this.shiftMenu.add(windowSwitch);
                windowSwitch.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((ProjectionBoundPlugin)WindowShiftPluginDeviceContext.this.getHost()).getProjection().getView().setActiveProjection(window2d);
                        ((ProjectionBoundPlugin)WindowShiftPluginDeviceContext.this.getHost()).getProjection().getView().repaintView();
                    }
                });
            }
            this.setGroup("window");
            this.setItem(this.shiftMenu);
        }

        @Override
        public boolean isCompatiblePlugin() {
            return true;
        }
    }
}

