/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.zoom.box;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.PluginException;
import org.jensoft.core.plugin.metrics.format.IMetricsFormat;
import org.jensoft.core.plugin.zoom.box.ZoomBoxEvent;
import org.jensoft.core.plugin.zoom.box.ZoomBoxListener;
import org.jensoft.core.plugin.zoom.box.ZoomBoxSynchronizer;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class ZoomBoxPlugin
extends AbstractPlugin
implements AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnDragListener {
    private Color zoomBoxDrawColor = RosePalette.LEMONPEEL;
    private Color zoomBoxFillColor = RosePalette.CALYPSOBLUE;
    private boolean lockZoomingTransaction = false;
    private int zoomBoxStartX;
    private int zoomBoxStartY;
    private int zoomBoxCurrentX;
    private int zoomBoxCurrentY;
    private int zoomBoxWidth;
    private int zoomBoxHeight;
    private boolean dynEffect = true;
    private ActionListener zoomLockAction;
    private List<BoundBox> zoomHistory = new Vector<BoundBox>();
    private Shape shapeZoomBox;
    private double zoomEffectX;
    private double zoomEffectY;
    private double zoomEffectWidth;
    private double zoomEffectHeight;
    private Point2D userWindowMinxMaxY;
    private Point2D userWindowMaxXMinY;
    private Point2D userWindowStartPoint;
    private Point2D userWindowCurrentPoint;
    private boolean lockEffect = false;
    private int curentBoxIndex = -1;
    private Vector<DynamicSequenceItem> dynSequence = new Vector();
    private SequencePlayer sequencePlayer;
    private EventListenerList zoomBoxListenerList;
    private BoxType boxType = BoxType.BoxXY;
    private int minimalDelatX = 16;
    private int minimalDeltaY = 16;
    private IMetricsFormat zoomBoxInfoMetricsFormat;
    private Font font = new Font("Tahoma", 0, 10);
    private TransactionType transactionType = TransactionType.DeviceTransaction;
    private int maxHistory = 8;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;

    public ZoomBoxPlugin() {
        this.setSelectable(true);
        this.setName(ZoomBoxPlugin.class.getCanonicalName());
        this.zoomBoxListenerList = new EventListenerList();
        this.zoomLockAction = new ZoomLockAction();
        this.setOnDragListener(this);
        this.setOnPressListener(this);
        this.setOnReleaseListener(this);
        this.setTextAntialising(TextAntialiasing.On);
        this.setPriority(10000);
        if (this.getPropertyFileName() == null) {
            try {
                Properties p = this.getProperties("plugin-zoombox.properties");
                this.setProperties(p);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public UserZoomBox createUserZoom(double minX, double maxX, double minY, double maxY) {
        return new UserZoomBox(minX, maxX, minY, maxY);
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public boolean isSequencePlaying() {
        return this.sequencePlayer != null && this.sequencePlayer.isAlive();
    }

    public IMetricsFormat getZoomBoxInfoMetricsFormat() {
        return this.zoomBoxInfoMetricsFormat;
    }

    public void setZoomBoxInfoMetricsFormat(IMetricsFormat zoomBoxInfoMetricsFormat) {
        this.zoomBoxInfoMetricsFormat = zoomBoxInfoMetricsFormat;
    }

    public void addZoomBoxListener(ZoomBoxListener listener) {
        this.zoomBoxListenerList.add(ZoomBoxListener.class, listener);
    }

    public void removeZoomBoxListener(ZoomBoxListener listener) {
        this.zoomBoxListenerList.remove(ZoomBoxListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireZoomStart() {
        Object[] listeners;
        Object[] objectArray = listeners = this.zoomBoxListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ZoomBoxListener.class) continue;
                ((ZoomBoxListener)listeners[i + 1]).zoomStart(new ZoomBoxEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireZoomBounded() {
        Object[] listeners;
        Object[] objectArray = listeners = this.zoomBoxListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ZoomBoxListener.class) continue;
                ((ZoomBoxListener)listeners[i + 1]).zoomBounded(new ZoomBoxEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireZoomIn() {
        Object[] listeners;
        Object[] objectArray = listeners = this.zoomBoxListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ZoomBoxListener.class) continue;
                ((ZoomBoxListener)listeners[i + 1]).zoomIn(new ZoomBoxEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireZoomOut() {
        Object[] listeners;
        Object[] objectArray = listeners = this.zoomBoxListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ZoomBoxListener.class) continue;
                ((ZoomBoxListener)listeners[i + 1]).zoomOut(new ZoomBoxEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireZoomHistory() {
        Object[] listeners;
        Object[] objectArray = listeners = this.zoomBoxListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ZoomBoxListener.class) continue;
                ((ZoomBoxListener)listeners[i + 1]).zoomHistory(new ZoomBoxEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireZoomClearHistory() {
        Object[] listeners;
        Object[] objectArray = listeners = this.zoomBoxListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ZoomBoxListener.class) continue;
                ((ZoomBoxListener)listeners[i + 1]).zoomClearHistory(new ZoomBoxEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void playCurrentSequence(ZoomPlayerCallback callback) {
        if (this.sequencePlayer != null && this.sequencePlayer.isAlive()) {
            this.sequencePlayer.interrupt();
        }
        this.sequencePlayer = new SequencePlayer(callback);
        this.sequencePlayer.start();
    }

    public ActionListener getZoomLockAction() {
        return this.zoomLockAction;
    }

    public static ZoomBoxSynchronizer createSynchronizer(ZoomBoxPlugin ... boxes) {
        ZoomBoxSynchronizer synchronizer = new ZoomBoxSynchronizer(boxes);
        return synchronizer;
    }

    public static ZoomBoxSynchronizer createSynchronizer(List<ZoomBoxPlugin> boxes) {
        ZoomBoxSynchronizer synchronizer = new ZoomBoxSynchronizer(boxes);
        return synchronizer;
    }

    private boolean isForwardCondition() {
        if (this.transactionType == TransactionType.UserTransaction) {
            return true;
        }
        return this.getBoxType() == BoxType.BoxXY ? this.zoomBoxCurrentX < this.zoomBoxStartX && this.zoomBoxCurrentY < this.zoomBoxStartY : (this.getBoxType() == BoxType.BoxX ? this.zoomBoxCurrentX < this.zoomBoxStartX : this.getBoxType() == BoxType.BoxY && this.zoomBoxCurrentY < this.zoomBoxStartY);
    }

    public void joinZoomIn() {
        if (this.zoomIn != null) {
            try {
                this.zoomIn.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void joinZoomOut() {
        if (this.zoomOut != null) {
            try {
                this.zoomOut.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processZoomIn() {
        try {
            Projection proj = this.getProjection();
            if (proj instanceof Projection.Linear) {
                Projection.Linear wl = (Projection.Linear)proj;
                if (this.isValidateBound()) {
                    Point2D.Double deviceStart = new Point2D.Double(this.zoomBoxStartX, this.zoomBoxStartY);
                    Point2D.Double deviceCurrent = new Point2D.Double(this.zoomBoxCurrentX, this.zoomBoxCurrentY);
                    this.userWindowStartPoint = proj.pixelToUser(deviceStart);
                    this.userWindowCurrentPoint = proj.pixelToUser(deviceCurrent);
                    if (this.userWindowStartPoint.getX() == Double.POSITIVE_INFINITY || this.userWindowStartPoint.getY() == Double.POSITIVE_INFINITY || this.userWindowCurrentPoint.getX() == Double.POSITIVE_INFINITY || this.userWindowCurrentPoint.getY() == Double.POSITIVE_INFINITY) {
                        return;
                    }
                    if (this.userWindowStartPoint.getX() == Double.NEGATIVE_INFINITY || this.userWindowStartPoint.getY() == Double.NEGATIVE_INFINITY || this.userWindowCurrentPoint.getX() == Double.NEGATIVE_INFINITY || this.userWindowCurrentPoint.getY() == Double.NEGATIVE_INFINITY) {
                        return;
                    }
                    if (this.dynEffect) {
                        this.zoomIn = new ZoomIn();
                        this.zoomIn.start();
                    } else {
                        if (this.getBoxType() == BoxType.BoxXY) {
                            wl.bound(this.userWindowStartPoint.getX(), this.userWindowCurrentPoint.getX(), this.userWindowCurrentPoint.getY(), this.userWindowStartPoint.getY());
                        } else if (this.getBoxType() == BoxType.BoxX) {
                            wl.bound(this.userWindowStartPoint.getX(), this.userWindowCurrentPoint.getX(), proj.getMinY(), proj.getMaxY());
                        } else if (this.getBoxType() == BoxType.BoxY) {
                            wl.bound(proj.getMinX(), proj.getMaxX(), this.userWindowCurrentPoint.getY(), this.userWindowStartPoint.getY());
                        }
                        this.getProjection().getView().repaintDevice();
                        this.unlockZoomTransaction();
                    }
                    if (this.zoomHistory != null && this.userWindowStartPoint != null && this.userWindowCurrentPoint != null) {
                        if (this.zoomHistory.size() >= this.maxHistory) {
                            this.processZoomClearHistory();
                        }
                        if (this.zoomHistory.size() == 0) {
                            this.zoomHistory.add(new BoundBox(wl.getInitialMinX(), wl.getInitialMaxX(), wl.getInitialMinY(), wl.getInitialMaxY()));
                        }
                        if (this.getBoxType() == BoxType.BoxXY) {
                            this.zoomHistory.add(new BoundBox(this.userWindowStartPoint.getX(), this.userWindowCurrentPoint.getX(), this.userWindowCurrentPoint.getY(), this.userWindowStartPoint.getY()));
                        } else if (this.getBoxType() == BoxType.BoxX) {
                            this.zoomHistory.add(new BoundBox(this.userWindowStartPoint.getX(), this.userWindowCurrentPoint.getX(), proj.getMinY(), proj.getMaxY()));
                        } else if (this.getBoxType() == BoxType.BoxY) {
                            this.zoomHistory.add(new BoundBox(proj.getMinX(), proj.getMaxX(), this.userWindowCurrentPoint.getY(), this.userWindowStartPoint.getY()));
                        }
                        this.setCurentBoxIndex(this.zoomHistory.size() - 1);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.fireZoomIn();
        }
    }

    private void lockZoomingTransaction() {
        this.lockZoomingTransaction = true;
    }

    private void unlockZoomTransaction() {
        this.lockZoomingTransaction = false;
    }

    private boolean isLockZoomingTransaction() {
        return this.lockZoomingTransaction;
    }

    @Override
    public void onDrag(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
        if (this.isLockPassive()) {
            return;
        }
        if (!this.isLockZoomingTransaction()) {
            return;
        }
        if (this.transactionType == TransactionType.UserTransaction) {
            return;
        }
        if (this.transactionType == TransactionType.DeviceTransaction) {
            this.processZoomBound(new Point2D.Double(me.getX(), me.getY()));
            this.getProjection().getView().repaintDevice();
        }
    }

    public void processZoomBound(Point2D currentBox) {
        if (this.transactionType == TransactionType.DeviceTransaction) {
            this.zoomBoxCurrentX = (int)currentBox.getX();
            this.zoomBoxCurrentY = (int)currentBox.getY();
        } else if (this.transactionType == TransactionType.UserTransaction) {
            Point2D deviceCurrentBox = this.getProjection().userToPixel(currentBox);
            if ((int)deviceCurrentBox.getY() < this.zoomBoxStartY) {
                throw new PluginException("Bad User Zoom Transaction, invalid zoom user y value, y should be smaller than previous start y value");
            }
            if ((int)deviceCurrentBox.getX() < this.zoomBoxStartX) {
                throw new PluginException("Bad User Zoom Transaction, invalid zoom user x value, x should be smaller than previous start x value");
            }
            this.zoomBoxCurrentX = (int)deviceCurrentBox.getX();
            this.zoomBoxCurrentY = (int)deviceCurrentBox.getY();
        }
        if (!this.isValidateBound()) {
            // empty if block
        }
        this.fireZoomBounded();
    }

    public Point2D getBoxStartDevicePoint() {
        return new Point2D.Double(this.zoomBoxStartX, this.zoomBoxStartY);
    }

    public Point2D getBoxCurrentDevicePoint() {
        return new Point2D.Double(this.zoomBoxCurrentX, this.zoomBoxCurrentY);
    }

    public Point2D getBoxStartUserPoint() {
        return this.getProjection().pixelToUser(this.getBoxStartDevicePoint());
    }

    public Point2D getBoxCurrentUserPoint() {
        return this.getProjection().pixelToUser(this.getBoxCurrentDevicePoint());
    }

    @Override
    public void onPress(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
        if (this.isLockPassive()) {
            return;
        }
        if (me.getModifiers() != 16) {
            return;
        }
        if (this.transactionType == TransactionType.UserTransaction) {
            return;
        }
        if (this.transactionType == TransactionType.DeviceTransaction) {
            this.processZoomStart(new Point2D.Double(me.getX(), me.getY()));
        }
    }

    public void processZoomStart(Point2D startBox) {
        if (this.transactionType == TransactionType.DeviceTransaction) {
            this.zoomBoxStartX = (int)startBox.getX();
            this.zoomBoxStartY = (int)startBox.getY();
            this.zoomBoxCurrentX = this.zoomBoxStartX;
            this.zoomBoxCurrentY = this.zoomBoxStartY;
        } else if (this.transactionType == TransactionType.UserTransaction) {
            Point2D deviceStartBox = this.getProjection().userToPixel(startBox);
            this.zoomBoxStartX = (int)deviceStartBox.getX();
            this.zoomBoxStartY = (int)deviceStartBox.getY();
            this.zoomBoxCurrentX = this.zoomBoxStartX;
            this.zoomBoxCurrentY = this.zoomBoxStartY;
        }
        this.fireZoomStart();
        this.lockZoomingTransaction();
    }

    @Override
    public void onRelease(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
        if (this.isLockPassive()) {
            return;
        }
        if (!this.isLockZoomingTransaction()) {
            return;
        }
        if (this.transactionType == TransactionType.UserTransaction) {
            return;
        }
        if (this.transactionType == TransactionType.DeviceTransaction) {
            if (this.isForwardCondition()) {
                this.processZoomOut();
                this.fireZoomOut();
            } else if (this.isValidateBound()) {
                this.processZoomIn();
            } else if (!this.isValidateBound()) {
                this.fireZoomIn();
            }
        }
    }

    public void processZoomOut() {
        this.zoomOut = new ZoomOut();
        this.zoomOut.start();
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart == ViewPart.Device) {
            if (!this.isLockSelected()) {
                return;
            }
            if (!this.isLockZoomingTransaction()) {
                return;
            }
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            if (this.isValidateBound()) {
                if (!this.lockEffect) {
                    this.paintBox(g2d);
                    this.paintMetricsInfo(g2d);
                } else {
                    this.paintEffect(g2d);
                }
            }
        }
    }

    private void paintEffect(Graphics2D g2d) {
        if (this.zoomBoxDrawColor != null) {
            g2d.setColor(this.zoomBoxDrawColor);
        } else {
            g2d.setColor(this.getThemeColor());
        }
        RoundRectangle2D.Double shapeEffect = null;
        if (this.getBoxType() == BoxType.BoxXY) {
            shapeEffect = new RoundRectangle2D.Double(this.zoomEffectX, this.zoomEffectY, this.zoomEffectWidth, this.zoomEffectHeight, 10.0, 10.0);
        } else if (this.getBoxType() == BoxType.BoxX) {
            shapeEffect = new RoundRectangle2D.Double(this.zoomEffectX, 0.0, this.zoomEffectWidth, this.getProjection().getDevice2D().getDeviceHeight(), 10.0, 10.0);
        } else if (this.getBoxType() == BoxType.BoxY) {
            shapeEffect = new RoundRectangle2D.Double(0.0, this.zoomEffectY, this.getProjection().getDevice2D().getDeviceWidth(), this.zoomEffectHeight, 10.0, 10.0);
        }
        if (this.zoomBoxFillColor != null) {
            g2d.setColor(this.zoomBoxFillColor);
        } else {
            g2d.setColor(this.getThemeColor());
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
        g2d.fill(shapeEffect);
        if (this.zoomBoxDrawColor != null) {
            g2d.setColor(this.zoomBoxDrawColor);
        } else {
            g2d.setColor(this.getThemeColor());
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.draw(shapeEffect);
    }

    private void paintBox(Graphics2D g2d) {
        this.zoomBoxWidth = this.zoomBoxCurrentX - this.zoomBoxStartX;
        this.zoomBoxHeight = this.zoomBoxCurrentY - this.zoomBoxStartY;
        if (this.getBoxType() == BoxType.BoxXY) {
            this.shapeZoomBox = new Rectangle2D.Double(this.zoomBoxStartX, this.zoomBoxStartY, this.zoomBoxWidth, this.zoomBoxHeight);
        } else if (this.getBoxType() == BoxType.BoxX) {
            this.shapeZoomBox = new Rectangle2D.Double(this.zoomBoxStartX, 0.0, this.zoomBoxWidth, this.getProjection().getDevice2D().getDeviceHeight());
        } else if (this.getBoxType() == BoxType.BoxY) {
            this.shapeZoomBox = new Rectangle2D.Double(0.0, this.zoomBoxStartY, this.getProjection().getDevice2D().getDeviceWidth(), this.zoomBoxHeight);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        if (this.zoomBoxDrawColor != null) {
            g2d.setColor(this.zoomBoxDrawColor);
        } else {
            g2d.setColor(this.getThemeColor());
        }
        g2d.draw(this.shapeZoomBox);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
        if (this.zoomBoxFillColor != null) {
            g2d.setColor(this.zoomBoxFillColor);
        } else {
            g2d.setColor(this.getThemeColor());
        }
        g2d.fill(this.shapeZoomBox);
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    private boolean isValidateBound() {
        if (this.transactionType == TransactionType.UserTransaction) {
            return true;
        }
        return this.getBoxType() == BoxType.BoxXY ? this.zoomBoxCurrentX > this.zoomBoxStartX + this.minimalDelatX && this.zoomBoxCurrentY > this.zoomBoxStartY + this.minimalDeltaY : (this.getBoxType() == BoxType.BoxX ? this.zoomBoxCurrentX > this.zoomBoxStartX + this.minimalDelatX : this.getBoxType() == BoxType.BoxY && this.zoomBoxCurrentY > this.zoomBoxStartY + this.minimalDeltaY);
    }

    private void paintMetricsInfo(Graphics2D g2d) {
        String metricsLabel;
        Projection w2d = this.getProjection().getView().getActiveProjection();
        if (this.zoomBoxDrawColor != null) {
            g2d.setColor(this.zoomBoxDrawColor);
        } else {
            g2d.setColor(this.getThemeColor());
        }
        Point2D.Double deviceMinXMaxY = new Point2D.Double(this.zoomBoxStartX, this.zoomBoxStartY);
        Point2D.Double deviceMaxXMinY = new Point2D.Double(this.zoomBoxCurrentX, this.zoomBoxCurrentY);
        Point2D p2dU1 = w2d.pixelToUser(deviceMinXMaxY);
        Point2D p2dU2 = w2d.pixelToUser(deviceMaxXMinY);
        Double userMinX = p2dU1.getX();
        Double userMaxY = p2dU1.getY();
        Double userMaxX = p2dU2.getX();
        Double userMinY = p2dU2.getY();
        DecimalFormat dc = new DecimalFormat("#.##");
        g2d.setFont(this.font);
        FontMetrics metrics = g2d.getFontMetrics(this.font);
        int hgt = metrics.getHeight();
        int deltaX = 20;
        int defilY = this.zoomBoxStartY - 50;
        if (this.getBoxType() == BoxType.BoxXY || this.getBoxType() == BoxType.BoxX) {
            if (userMinX > 0.0) {
                metricsLabel = null;
                metricsLabel = this.getZoomBoxInfoMetricsFormat() != null ? this.getZoomBoxInfoMetricsFormat().format(userMinX) : dc.format(userMinX);
                g2d.drawString("min  X  = + " + metricsLabel, this.zoomBoxCurrentX + deltaX, defilY);
            } else {
                metricsLabel = null;
                metricsLabel = this.getZoomBoxInfoMetricsFormat() != null ? this.getZoomBoxInfoMetricsFormat().format(Math.abs(userMinX)) : dc.format(Math.abs(userMinX));
                g2d.drawString("min  X  = - " + metricsLabel, this.zoomBoxCurrentX + deltaX, defilY);
            }
            defilY += 15;
            if (userMaxX > 0.0) {
                metricsLabel = null;
                metricsLabel = this.getZoomBoxInfoMetricsFormat() != null ? this.getZoomBoxInfoMetricsFormat().format(userMaxX) : dc.format(userMaxX);
                g2d.drawString("max X  = + " + metricsLabel, this.zoomBoxCurrentX + deltaX, defilY);
            } else {
                metricsLabel = null;
                metricsLabel = this.getZoomBoxInfoMetricsFormat() != null ? this.getZoomBoxInfoMetricsFormat().format(Math.abs(userMaxX)) : dc.format(Math.abs(userMaxX));
                g2d.drawString("max X  = - " + metricsLabel, this.zoomBoxCurrentX + deltaX, defilY);
            }
            defilY += 15;
        }
        if (this.getBoxType() == BoxType.BoxXY || this.getBoxType() == BoxType.BoxY) {
            if (userMaxY > 0.0) {
                metricsLabel = null;
                metricsLabel = this.getZoomBoxInfoMetricsFormat() != null ? this.getZoomBoxInfoMetricsFormat().format(userMaxY) : dc.format(userMaxY);
                g2d.drawString("max Y  = + " + metricsLabel, this.zoomBoxCurrentX + deltaX, defilY);
            } else {
                metricsLabel = null;
                metricsLabel = this.getZoomBoxInfoMetricsFormat() != null ? this.getZoomBoxInfoMetricsFormat().format(Math.abs(userMaxY)) : dc.format(Math.abs(userMaxY));
                g2d.drawString("max Y  = - " + metricsLabel, this.zoomBoxCurrentX + deltaX, defilY);
            }
            defilY += 15;
            if (userMinY > 0.0) {
                metricsLabel = null;
                metricsLabel = this.getZoomBoxInfoMetricsFormat() != null ? this.getZoomBoxInfoMetricsFormat().format(userMinY) : dc.format(userMinY);
                g2d.drawString("min  Y  = + " + metricsLabel, this.zoomBoxCurrentX + deltaX, defilY);
            } else {
                metricsLabel = null;
                metricsLabel = this.getZoomBoxInfoMetricsFormat() != null ? this.getZoomBoxInfoMetricsFormat().format(Math.abs(userMinY)) : dc.format(Math.abs(userMinY));
                g2d.drawString("min  Y  = - " + metricsLabel, this.zoomBoxCurrentX + deltaX, defilY);
            }
        }
    }

    public BoxType getBoxType() {
        return this.boxType;
    }

    public void setBoxType(BoxType boxType) {
        this.boxType = boxType;
    }

    public Color getZoomBoxDrawColor() {
        return this.zoomBoxDrawColor;
    }

    public void setZoomBoxDrawColor(Color zoomBoxDrawColor) {
        this.zoomBoxDrawColor = zoomBoxDrawColor;
    }

    public Color getZoomBoxFillColor() {
        return this.zoomBoxFillColor;
    }

    public void setZoomBoxFillColor(Color zoomBoxFillColor) {
        this.zoomBoxFillColor = zoomBoxFillColor;
    }

    public List<BoundBox> getZoomHistory() {
        return this.zoomHistory;
    }

    public int getCurentBoxIndex() {
        return this.curentBoxIndex;
    }

    public void setCurentBoxIndex(int curentBoxIndex) {
        this.curentBoxIndex = curentBoxIndex;
    }

    public void historyNext() {
        int index = this.getCurentBoxIndex();
        if (index + 1 <= 0) {
            return;
        }
        if (index + 1 >= this.zoomHistory.size()) {
            return;
        }
        this.processZoomHistory(index + 1);
    }

    public void historyPrevious() {
        int index = this.getCurentBoxIndex();
        if (index - 1 < 0) {
            return;
        }
        this.processZoomHistory(index - 1);
    }

    public int getHistoryIndex(BoundBox boundBox) {
        int index = 0;
        for (BoundBox box : this.zoomHistory) {
            if (box.equals(boundBox)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void processZoomHistory(int requestHistory) {
        if (requestHistory != -1) {
            BoundBox box = this.zoomHistory.get(requestHistory);
            if (box == null) {
                return;
            }
            this.setCurentBoxIndex(requestHistory);
            if (this.getProjection() instanceof Projection.Linear) {
                Projection.Linear wl = (Projection.Linear)this.getProjection();
                wl.bound(box.minX, box.maxX, box.minY, box.maxY);
            }
        }
    }

    public void processZoomClearHistory() {
        this.zoomHistory.clear();
        this.curentBoxIndex = -1;
        this.fireZoomClearHistory();
        this.getProjection().getView().repaintDevice();
    }

    public void lockDynEffect() {
        this.dynEffect = true;
    }

    public void unlockDynEffect() {
        this.dynEffect = false;
    }

    public class BoundBox {
        public double minX;
        public double maxX;
        public double minY;
        public double maxY;

        public BoundBox(double minX, double maxX, double minY, double maxY) {
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BoundBox other = (BoundBox)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (Double.doubleToLongBits(this.maxX) != Double.doubleToLongBits(other.maxX)) {
                return false;
            }
            if (Double.doubleToLongBits(this.maxY) != Double.doubleToLongBits(other.maxY)) {
                return false;
            }
            if (Double.doubleToLongBits(this.minX) != Double.doubleToLongBits(other.minX)) {
                return false;
            }
            return Double.doubleToLongBits(this.minY) == Double.doubleToLongBits(other.minY);
        }

        private ZoomBoxPlugin getOuterType() {
            return ZoomBoxPlugin.this;
        }
    }

    class DynamicSequenceItem {
        double zoomEffectX;
        double zoomEffectY;
        double zoomEffectWidth;
        double zoomEffectHeight;
        Point2D up1;
        Point2D up2;
        Point2D up3;
        Point2D up4;

        public DynamicSequenceItem(double zoomEffectX, double zoomEffectY, double zoomEffectWidth, double zoomEffectHeight, Point2D up1, Point2D up2, Point2D up3, Point2D up4) {
            this.zoomEffectX = zoomEffectX;
            this.zoomEffectY = zoomEffectY;
            this.zoomEffectWidth = zoomEffectWidth;
            this.zoomEffectHeight = zoomEffectHeight;
            this.up1 = up1;
            this.up2 = up2;
            this.up3 = up3;
            this.up4 = up4;
        }
    }

    public class ZoomIn
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Projection proj = ZoomBoxPlugin.this.getProjection();
            if (proj instanceof Projection.Linear) {
                Projection.Linear wl = (Projection.Linear)proj;
                try {
                    ZoomBoxPlugin.this.lockEffect = true;
                    ZoomBoxPlugin.this.userWindowMinxMaxY = new Point2D.Double(proj.getMinX(), proj.getMaxY());
                    ZoomBoxPlugin.this.userWindowMaxXMinY = new Point2D.Double(proj.getMaxX(), proj.getMinY());
                    Point2D.Double devicepd2_1 = new Point2D.Double(ZoomBoxPlugin.this.zoomBoxStartX, ZoomBoxPlugin.this.zoomBoxStartY);
                    ZoomBoxPlugin.this.userWindowStartPoint = proj.pixelToUser(devicepd2_1);
                    Point2D.Double devicepd2_2 = new Point2D.Double(ZoomBoxPlugin.this.zoomBoxCurrentX, ZoomBoxPlugin.this.zoomBoxCurrentY);
                    ZoomBoxPlugin.this.userWindowCurrentPoint = proj.pixelToUser(devicepd2_2);
                    int pas = 20;
                    double deltaNorth = ZoomBoxPlugin.this.zoomBoxStartY / pas;
                    double deltaEast = (ZoomBoxPlugin.this.getProjection().getView().getDevice2D().getDeviceWidth() - ZoomBoxPlugin.this.zoomBoxCurrentX) / pas;
                    double deltaWest = ZoomBoxPlugin.this.zoomBoxStartX / pas;
                    double deltaSouth = (ZoomBoxPlugin.this.getProjection().getView().getDevice2D().getDeviceHeight() - ZoomBoxPlugin.this.zoomBoxCurrentY) / pas;
                    ZoomBoxPlugin.this.dynSequence.clear();
                    for (int i = 1; i <= pas; ++i) {
                        double izoomEffectX = (double)ZoomBoxPlugin.this.zoomBoxStartX - (double)i * deltaWest;
                        double izoomEffectY = (double)ZoomBoxPlugin.this.zoomBoxStartY - (double)i * deltaNorth;
                        double izoomEffectWidth = (double)ZoomBoxPlugin.this.zoomBoxWidth + (double)i * deltaWest + (double)i * deltaEast;
                        double izoomEffectHeight = (double)ZoomBoxPlugin.this.zoomBoxHeight + (double)i * deltaNorth + (double)i * deltaSouth;
                        Point2D.Double dp1 = new Point2D.Double((double)i * deltaWest, (double)i * deltaNorth);
                        Point2D.Double dp2 = new Point2D.Double((double)i * deltaWest, (double)ZoomBoxPlugin.this.getProjection().getView().getDevice2D().getDeviceHeight() - (double)i * deltaSouth);
                        Point2D.Double dp3 = new Point2D.Double((double)ZoomBoxPlugin.this.getProjection().getView().getDevice2D().getDeviceWidth() - (double)i * deltaEast, (double)ZoomBoxPlugin.this.getProjection().getView().getDevice2D().getDeviceHeight() - (double)i * deltaSouth);
                        Point2D.Double dp4 = new Point2D.Double((double)ZoomBoxPlugin.this.getProjection().getView().getDevice2D().getDeviceWidth() - (double)i * deltaEast, (double)i * deltaNorth);
                        Point2D up1 = proj.pixelToUser(dp1);
                        Point2D up2 = proj.pixelToUser(dp2);
                        Point2D up3 = proj.pixelToUser(dp3);
                        Point2D up4 = proj.pixelToUser(dp4);
                        DynamicSequenceItem q = null;
                        q = new DynamicSequenceItem(izoomEffectX, izoomEffectY, izoomEffectWidth, izoomEffectHeight, up1, up2, up3, up4);
                        ZoomBoxPlugin.this.dynSequence.add(q);
                    }
                    for (int j = 0; j < ZoomBoxPlugin.this.dynSequence.size(); ++j) {
                        DynamicSequenceItem q = (DynamicSequenceItem)ZoomBoxPlugin.this.dynSequence.get(j);
                        ZoomBoxPlugin.this.zoomEffectX = q.zoomEffectX;
                        ZoomBoxPlugin.this.zoomEffectY = q.zoomEffectY;
                        ZoomBoxPlugin.this.zoomEffectWidth = q.zoomEffectWidth;
                        ZoomBoxPlugin.this.zoomEffectHeight = q.zoomEffectHeight;
                        if (ZoomBoxPlugin.this.getBoxType() == BoxType.BoxXY) {
                            wl.bound(q.up1.getX(), q.up3.getX(), q.up3.getY(), q.up1.getY());
                        } else if (ZoomBoxPlugin.this.getBoxType() == BoxType.BoxX) {
                            wl.bound(q.up1.getX(), q.up3.getX(), proj.getMinY(), proj.getMaxY());
                        } else if (ZoomBoxPlugin.this.getBoxType() == BoxType.BoxY) {
                            wl.bound(proj.getMinX(), proj.getMaxX(), q.up3.getY(), q.up1.getY());
                        }
                        ZoomBoxPlugin.this.getProjection().getView().getDevice2D().repaintDevice();
                        Thread.sleep(25L);
                    }
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                    e.printStackTrace();
                }
                finally {
                    ZoomBoxPlugin.this.lockEffect = false;
                    if (ZoomBoxPlugin.this.getBoxType() == BoxType.BoxXY) {
                        wl.bound(ZoomBoxPlugin.this.userWindowStartPoint.getX(), ZoomBoxPlugin.this.userWindowCurrentPoint.getX(), ZoomBoxPlugin.this.userWindowCurrentPoint.getY(), ZoomBoxPlugin.this.userWindowStartPoint.getY());
                    } else if (ZoomBoxPlugin.this.getBoxType() == BoxType.BoxX) {
                        wl.bound(ZoomBoxPlugin.this.userWindowStartPoint.getX(), ZoomBoxPlugin.this.userWindowCurrentPoint.getX(), proj.getMinY(), proj.getMaxY());
                    } else if (ZoomBoxPlugin.this.getBoxType() == BoxType.BoxY) {
                        wl.bound(proj.getMinX(), proj.getMaxX(), ZoomBoxPlugin.this.userWindowCurrentPoint.getY(), ZoomBoxPlugin.this.userWindowStartPoint.getY());
                    }
                    ZoomBoxPlugin.this.getProjection().getView().getDevice2D().repaintDevice();
                    ZoomBoxPlugin.this.unlockZoomTransaction();
                }
            }
        }
    }

    public class ZoomOut
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Projection proj = ZoomBoxPlugin.this.getProjection();
            if (proj instanceof Projection.Linear) {
                Projection.Linear wl = (Projection.Linear)proj;
                if (ZoomBoxPlugin.this.dynSequence.size() > 0) {
                    try {
                        for (int j = ZoomBoxPlugin.this.dynSequence.size() - 1; j >= 0; --j) {
                            DynamicSequenceItem q = (DynamicSequenceItem)ZoomBoxPlugin.this.dynSequence.get(j);
                            ZoomBoxPlugin.this.zoomEffectX = q.zoomEffectX;
                            ZoomBoxPlugin.this.zoomEffectY = q.zoomEffectY;
                            ZoomBoxPlugin.this.zoomEffectWidth = q.zoomEffectWidth;
                            ZoomBoxPlugin.this.zoomEffectHeight = q.zoomEffectHeight;
                            if (ZoomBoxPlugin.this.getBoxType() == BoxType.BoxXY) {
                                wl.bound(q.up1.getX(), q.up3.getX(), q.up3.getY(), q.up1.getY());
                            } else if (ZoomBoxPlugin.this.getBoxType() == BoxType.BoxX) {
                                wl.bound(q.up1.getX(), q.up3.getX(), proj.getMinY(), proj.getMaxY());
                            } else if (ZoomBoxPlugin.this.getBoxType() == BoxType.BoxY) {
                                wl.bound(proj.getMinX(), proj.getMaxX(), q.up3.getY(), q.up1.getY());
                            }
                            ZoomBoxPlugin.this.getProjection().getView().repaintDevice();
                            Thread.sleep(25L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        wl.bound(ZoomBoxPlugin.this.userWindowMinxMaxY.getX(), ZoomBoxPlugin.this.userWindowMaxXMinY.getX(), ZoomBoxPlugin.this.userWindowMaxXMinY.getY(), ZoomBoxPlugin.this.userWindowMinxMaxY.getY());
                        ZoomBoxPlugin.this.getProjection().getView().repaintDevice();
                        ZoomBoxPlugin.this.dynSequence.clear();
                        ZoomBoxPlugin.this.unlockZoomTransaction();
                    }
                }
            }
        }
    }

    public class ZoomLockAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (ZoomBoxPlugin.this.isLockSelected()) {
                ZoomBoxPlugin.this.unlockSelected();
            } else {
                ZoomBoxPlugin.this.lockSelected();
            }
        }
    }

    class SequencePlayer
    extends Thread {
        private ZoomPlayerCallback playerCallback;

        public SequencePlayer(ZoomPlayerCallback playerCallback) {
            this.playerCallback = playerCallback;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(10L);
                int initialIndex = 0;
                ZoomBoxPlugin.this.processZoomHistory(0);
                ZoomBoxPlugin.this.fireZoomHistory();
                Thread.sleep(1000L);
                for (int index = initialIndex + 1; index < ZoomBoxPlugin.this.zoomHistory.size(); ++index) {
                    ZoomBoxPlugin.this.historyNext();
                    ZoomBoxPlugin.this.getProjection().getDevice2D().repaintDevice();
                    int i = ZoomBoxPlugin.this.getCurentBoxIndex();
                    if (this.playerCallback != null) {
                        BoundBox bb = (BoundBox)ZoomBoxPlugin.this.zoomHistory.get(i);
                        this.playerCallback.play(bb);
                    }
                    ZoomBoxPlugin.this.fireZoomHistory();
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface ZoomPlayerCallback {
        public void play(BoundBox var1);
    }

    public class UserZoomBox {
        private double minX;
        private double maxX;
        private double minY;
        private double maxY;
        private int startDelay = 0;
        private Runner zoomInRunner;

        public UserZoomBox(double minX, double maxX, double minY, double maxY) {
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
        }

        public void zoomIn() {
            this.zoomInRunner = new Runner();
            this.zoomInRunner.start();
            try {
                this.zoomInRunner.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void zoomIn(int startDelay) {
            this.startDelay = startDelay;
            this.zoomInRunner = new Runner();
            this.zoomInRunner.start();
            try {
                this.zoomInRunner.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void zoomOut() {
            ZoomBoxPlugin.this.lockSelected();
            ZoomBoxPlugin.this.processZoomOut();
            ZoomBoxPlugin.this.joinZoomOut();
            ZoomBoxPlugin.this.fireZoomOut();
            ZoomBoxPlugin.this.unlockSelected();
        }

        class Runner
        extends Thread {
            Runner() {
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(UserZoomBox.this.startDelay);
                    ZoomBoxPlugin.this.lockSelected();
                    ZoomBoxPlugin.this.setTransactionType(TransactionType.UserTransaction);
                    ZoomBoxPlugin.this.processZoomStart(new Point2D.Double(UserZoomBox.this.minX, UserZoomBox.this.maxY));
                    double deltaX = UserZoomBox.this.maxX - UserZoomBox.this.minX;
                    double deltaY = UserZoomBox.this.maxY - UserZoomBox.this.minY;
                    int step = 20;
                    double stepX = deltaX / (double)step;
                    double stepY = deltaY / (double)step;
                    for (double i = 0.0; i < (double)step; i += 1.0) {
                        double w = UserZoomBox.this.minX + stepX * i;
                        double h = UserZoomBox.this.maxY - stepY * i;
                        Point2D.Double p = new Point2D.Double(w, h);
                        ZoomBoxPlugin.this.processZoomBound(p);
                        ZoomBoxPlugin.this.getProjection().getView().repaintDevice();
                        Thread.sleep(10L);
                    }
                    Thread.sleep(300L);
                    ZoomBoxPlugin.this.processZoomIn();
                    ZoomBoxPlugin.this.joinZoomIn();
                    ZoomBoxPlugin.this.setTransactionType(TransactionType.DeviceTransaction);
                    ZoomBoxPlugin.this.unlockSelected();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static enum TransactionType {
        DeviceTransaction,
        UserTransaction;

    }

    public static enum BoxType {
        BoxXY,
        BoxX,
        BoxY;

    }
}

