/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.zoom.lens;

import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jensoft.core.device.ContextEntry;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.PluginListener;
import org.jensoft.core.plugin.zoom.lens.ZoomLensPlugin;
import org.jensoft.core.sharedicon.SharedIcon;
import org.jensoft.core.sharedicon.common.Common;

public class LensDefaultDeviceContext
extends ContextEntry<ZoomLensPlugin> {
    private JMenu rootMenu;
    private JMenuItem objectifLocker;
    private ImageIcon objectifRootIcon = SharedIcon.getCommon(Common.LENS16);
    private ImageIcon lockIcon = SharedIcon.getCommon(Common.LOCK);
    private ImageIcon unlockIcon = SharedIcon.getCommon(Common.UNLOCK);

    @Override
    public void buildContext() {
        if (this.getHost() == null) {
            return;
        }
        this.rootMenu = new JMenu("Zoom Lens");
        this.rootMenu.setIcon(this.objectifRootIcon);
        this.objectifLocker = new JMenuItem("Lock");
        this.rootMenu.add(this.objectifLocker);
        if (((ZoomLensPlugin)this.getHost()).isLockSelected()) {
            this.objectifLocker.setIcon(this.lockIcon);
            this.objectifLocker.setText("unlock");
        } else {
            this.objectifLocker.setIcon(this.unlockIcon);
            this.objectifLocker.setText("lock");
        }
        this.objectifLocker.addActionListener(((ZoomLensPlugin)this.getHost()).getObjectifLockUnlockAction());
        ((ZoomLensPlugin)this.getHost()).addPluginListener(new PluginListener(){

            public void pluginUnlockSelected(PluginEvent pluginEvent) {
                LensDefaultDeviceContext.this.objectifLocker.setText("lock");
                LensDefaultDeviceContext.this.objectifLocker.setIcon(LensDefaultDeviceContext.this.unlockIcon);
            }

            public void pluginSelected(PluginEvent pluginEvent) {
                LensDefaultDeviceContext.this.objectifLocker.setText("unlock");
                LensDefaultDeviceContext.this.objectifLocker.setIcon(LensDefaultDeviceContext.this.lockIcon);
            }
        });
        this.setGroup("zoom");
        this.setItem(this.rootMenu);
    }

    @Override
    public boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof ZoomLensPlugin;
    }
}

