/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.zoom.lens;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.zoom.lens.ZoomLensEvent;
import org.jensoft.core.plugin.zoom.lens.ZoomLensListener;
import org.jensoft.core.plugin.zoom.lens.ZoomLensSynchronizer;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;
import org.jensoft.core.view.WidgetPlugin;

public class ZoomLensPlugin
extends AbstractPlugin
implements AbstractPlugin.OnReleaseListener {
    private boolean zoomInLock = false;
    private boolean zoomOutLock = false;
    private int zoomMiliTempo = 100;
    private int factor = 30;
    private ZoomNature processNature;
    private ZoomOutProcess zoomOutXY;
    private ZoomOutProcess zoomOutX;
    private ZoomOutProcess zoomOutY;
    private ZoomInProcess zoomInXY;
    private ZoomInProcess zoomInX;
    private ZoomInProcess zoomInY;
    private ZoomLensType zoomLensType = ZoomLensType.ZoomXY;
    private EventListenerList zoomObjectifListenerList;

    protected ZoomNature getProcessNature() {
        return this.processNature;
    }

    public ZoomLensType getZoomLensType() {
        return this.zoomLensType;
    }

    public void setZoomLensType(ZoomLensType zoomLensType) {
        this.zoomLensType = zoomLensType;
    }

    public ZoomLensPlugin() {
        this.setName("ObjectifPlugin");
        this.setSelectable(true);
        this.createProcess();
        this.setOnReleaseListener(this);
        this.setTextAntialising(TextAntialiasing.On);
        this.zoomObjectifListenerList = new EventListenerList();
        this.setPriority(100);
    }

    public void addZoomObjectifListener(ZoomLensListener listener) {
        this.zoomObjectifListenerList.add(ZoomLensListener.class, listener);
    }

    public void removeZoomObjectifListener(ZoomLensListener listener) {
        this.zoomObjectifListenerList.remove(ZoomLensListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireZoomIn() {
        Object[] listeners;
        Object[] objectArray = listeners = this.zoomObjectifListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ZoomLensListener.class) continue;
                ((ZoomLensListener)listeners[i + 1]).zoomIn(new ZoomLensEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireZoomOut() {
        Object[] listeners;
        Object[] objectArray = listeners = this.zoomObjectifListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ZoomLensListener.class) continue;
                ((ZoomLensListener)listeners[i + 1]).zoomOut(new ZoomLensEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ObjectifLockUnlockAction getObjectifLockUnlockAction() {
        return new ObjectifLockUnlockAction();
    }

    public static ZoomLensSynchronizer createSynchronizer(ZoomLensPlugin ... objectifs) {
        ZoomLensSynchronizer synchronizer = new ZoomLensSynchronizer(objectifs);
        return synchronizer;
    }

    @Override
    public void lockSelected() {
        super.lockSelected();
        if (this.getProjection() == null || this.getProjection().getView() == null) {
            return;
        }
        this.getProjection().getView().getWidgetPlugin().pushMessage("LOCK OBJECTIF", this, WidgetPlugin.PushingBehavior.Fast);
    }

    @Override
    public void unlockSelected() {
        super.unlockSelected();
        if (this.getProjection() == null) {
            return;
        }
        this.getProjection().getDevice2D().repaintDevice();
    }

    private void createProcess() {
        this.zoomOutXY = new ZoomOutProcess(ZoomNature.ZoomXY);
        this.zoomOutX = new ZoomOutProcess(ZoomNature.ZoomX);
        this.zoomOutY = new ZoomOutProcess(ZoomNature.ZoomY);
        this.zoomInXY = new ZoomInProcess(ZoomNature.ZoomXY);
        this.zoomInX = new ZoomInProcess(ZoomNature.ZoomX);
        this.zoomInY = new ZoomInProcess(ZoomNature.ZoomY);
    }

    public void zoomIn(ZoomNature zoomNature) {
        this.processNature = zoomNature;
        Projection w2d = this.getProjection();
        double w = this.getProjection().getDevice2D().getDeviceWidth();
        double h = this.getProjection().getDevice2D().getDeviceHeight();
        Point2D.Double pMinXMinYDevice = null;
        Point2D.Double pMaxXMaxYDevice = null;
        if (zoomNature == ZoomNature.ZoomXY) {
            pMinXMinYDevice = new Point2D.Double(w / (double)this.factor, h - h / (double)this.factor);
            pMaxXMaxYDevice = new Point2D.Double(w - w / (double)this.factor, h / (double)this.factor);
        } else if (zoomNature == ZoomNature.ZoomX) {
            pMinXMinYDevice = new Point2D.Double(w / (double)this.factor, h);
            pMaxXMaxYDevice = new Point2D.Double(w - w / (double)this.factor, 0.0);
        } else if (zoomNature == ZoomNature.ZoomY) {
            pMinXMinYDevice = new Point2D.Double(0.0, h - h / (double)this.factor);
            pMaxXMaxYDevice = new Point2D.Double(w, h / (double)this.factor);
        }
        Point2D pMinXMinYUser = w2d.pixelToUser(pMinXMinYDevice);
        Point2D pMaxXMaxYUser = w2d.pixelToUser(pMaxXMaxYDevice);
        if (w2d instanceof Projection.Linear) {
            Projection.Linear wl = (Projection.Linear)w2d;
            if (this.zoomLensType == ZoomLensType.ZoomXY) {
                wl.bound(pMinXMinYUser.getX(), pMaxXMaxYUser.getX(), pMinXMinYUser.getY(), pMaxXMaxYUser.getY());
            } else if (this.zoomLensType == ZoomLensType.ZoomX) {
                wl.bound(pMinXMinYUser.getX(), pMaxXMaxYUser.getX(), wl.getMinY(), wl.getMaxY());
            } else if (this.zoomLensType == ZoomLensType.ZoomY) {
                wl.bound(wl.getMinX(), wl.getMaxX(), pMinXMinYUser.getY(), pMaxXMaxYUser.getY());
            }
        }
    }

    public void zoomOut(ZoomNature zoomNature) {
        this.processNature = zoomNature;
        double w = this.getProjection().getDevice2D().getDeviceWidth();
        double h = this.getProjection().getDevice2D().getDeviceHeight();
        Point2D.Double pMinXMinYDevice = null;
        Point2D.Double pMaxXMaxYDevice = null;
        if (zoomNature == ZoomNature.ZoomXY) {
            pMinXMinYDevice = new Point2D.Double(-w / (double)this.factor, h + h / (double)this.factor);
            pMaxXMaxYDevice = new Point2D.Double(w + w / (double)this.factor, -h / (double)this.factor);
        } else if (zoomNature == ZoomNature.ZoomX) {
            pMinXMinYDevice = new Point2D.Double(-w / (double)this.factor, h);
            pMaxXMaxYDevice = new Point2D.Double(w + w / (double)this.factor, 0.0);
        } else if (zoomNature == ZoomNature.ZoomY) {
            pMinXMinYDevice = new Point2D.Double(0.0, h + h / (double)this.factor);
            pMaxXMaxYDevice = new Point2D.Double(w, -h / (double)this.factor);
        }
        Point2D pMinXMinYUser = this.getProjection().pixelToUser(pMinXMinYDevice);
        Point2D pMaxXMaxYUser = this.getProjection().pixelToUser(pMaxXMaxYDevice);
        if (this.getProjection() instanceof Projection.Linear) {
            Projection.Linear wl = (Projection.Linear)this.getProjection();
            if (this.zoomLensType == ZoomLensType.ZoomXY) {
                wl.bound(pMinXMinYUser.getX(), pMaxXMaxYUser.getX(), pMinXMinYUser.getY(), pMaxXMaxYUser.getY());
            } else if (this.zoomLensType == ZoomLensType.ZoomX) {
                wl.bound(pMinXMinYUser.getX(), pMaxXMaxYUser.getX(), wl.getMinY(), wl.getMaxY());
            } else if (this.zoomLensType == ZoomLensType.ZoomY) {
                wl.bound(wl.getMinX(), wl.getMaxX(), pMinXMinYUser.getY(), pMaxXMaxYUser.getY());
            }
        }
    }

    public void startZoomOut(ZoomNature zoomNature) {
        this.zoomOutLock = true;
        Thread zoomOutThread = new Thread((Runnable)this.getZoomOutProcess(zoomNature), "zoom out run");
        zoomOutThread.start();
    }

    private ZoomOutProcess getZoomOutProcess(ZoomNature zoomNature) {
        if (zoomNature == ZoomNature.ZoomXY) {
            return this.zoomOutXY;
        }
        if (zoomNature == ZoomNature.ZoomX) {
            return this.zoomOutX;
        }
        if (zoomNature == ZoomNature.ZoomY) {
            return this.zoomOutY;
        }
        return null;
    }

    public void stopZoomOut() {
        this.zoomOutLock = false;
    }

    public void startZoomIn(ZoomNature zoomNature) {
        this.zoomInLock = true;
        Thread zoomInThread = new Thread((Runnable)this.getZoomInProcess(zoomNature), "zoom in run");
        zoomInThread.start();
    }

    private ZoomInProcess getZoomInProcess(ZoomNature zoomNature) {
        if (zoomNature == ZoomNature.ZoomXY) {
            return this.zoomInXY;
        }
        if (zoomNature == ZoomNature.ZoomX) {
            return this.zoomInX;
        }
        if (zoomNature == ZoomNature.ZoomY) {
            return this.zoomInY;
        }
        return null;
    }

    public void stopZoomIn() {
        this.zoomInLock = false;
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
    }

    @Override
    public void onRelease(MouseEvent me) {
        this.stopZoomIn();
        this.stopZoomOut();
    }

    class ZoomInProcess
    implements Runnable {
        private ZoomNature processNature;

        public ZoomInProcess(ZoomNature processNature) {
            this.processNature = processNature;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (ZoomLensPlugin.this.zoomInLock) {
                    ZoomLensPlugin.this.zoomIn(this.processNature);
                    ZoomLensPlugin.this.fireZoomIn();
                    ZoomLensPlugin.this.getProjection().getDevice2D().repaintDevice();
                    Thread.sleep(ZoomLensPlugin.this.zoomMiliTempo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    class ZoomOutProcess
    implements Runnable {
        private ZoomNature processNature;

        public ZoomOutProcess(ZoomNature processNature) {
            this.processNature = processNature;
        }

        @Override
        public void run() {
            try {
                while (ZoomLensPlugin.this.zoomOutLock) {
                    ZoomLensPlugin.this.zoomOut(this.processNature);
                    ZoomLensPlugin.this.fireZoomOut();
                    ZoomLensPlugin.this.getProjection().getDevice2D().repaintDevice();
                    Thread.sleep(ZoomLensPlugin.this.zoomMiliTempo);
                }
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    class ObjectifLockUnlockAction
    implements ActionListener {
        ObjectifLockUnlockAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ZoomLensPlugin.this.isLockSelected()) {
                        ZoomLensPlugin.this.unlockSelected();
                    } else {
                        ZoomLensPlugin.this.lockSelected();
                    }
                }
            });
        }
    }

    public static enum ZoomNature {
        ZoomXY,
        ZoomX,
        ZoomY;

    }

    public static enum ZoomLensType {
        ZoomXY,
        ZoomX,
        ZoomY;

    }
}

