/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.zoom.wheel;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.zoom.wheel.ZoomWheelEvent;
import org.jensoft.core.plugin.zoom.wheel.ZoomWheelListener;
import org.jensoft.core.plugin.zoom.wheel.ZoomWheelSynchronizer;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class ZoomWheelPlugin
extends AbstractPlugin
implements AbstractPlugin.OnWheelListener {
    private EventListenerList zoomWheelListenerList;
    private boolean zoomEnabled = true;
    public ZoomWheelType zoomWheelType = ZoomWheelType.ZoomXY;
    boolean lockWheel = false;
    private int factor = 30;
    private String zoomMessage = null;
    private MessageCleaner messageCleaner;

    public ZoomWheelPlugin() {
        this.setName(ZoomWheelPlugin.class.getCanonicalName());
        this.setSelectable(false);
        this.setOnWheelListener(this);
        this.setTextAntialising(TextAntialiasing.On);
        this.zoomWheelListenerList = new EventListenerList();
        this.setPriority(100);
    }

    public ZoomWheelPlugin(ZoomWheelType zoomWheelType) {
        this();
        this.setZoomWheelType(zoomWheelType);
    }

    public ZoomWheelType getZoomWheelType() {
        return this.zoomWheelType;
    }

    public void setZoomWheelType(ZoomWheelType zoomWheelMode) {
        this.zoomWheelType = zoomWheelMode;
    }

    public static ZoomWheelSynchronizer createSynchronizer(ZoomWheelPlugin ... zoomWheels) {
        ZoomWheelSynchronizer synchronizer = new ZoomWheelSynchronizer(zoomWheels);
        return synchronizer;
    }

    public static ZoomWheelSynchronizer createSynchronizer(List<ZoomWheelPlugin> zoomWheels) {
        ZoomWheelSynchronizer synchronizer = new ZoomWheelSynchronizer(zoomWheels);
        return synchronizer;
    }

    public void addZoomWheelListener(ZoomWheelListener listener) {
        this.zoomWheelListenerList.add(ZoomWheelListener.class, listener);
    }

    public void removeZoomBoxListener(ZoomWheelListener listener) {
        this.zoomWheelListenerList.remove(ZoomWheelListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireZoomIn() {
        Object[] listeners;
        Object[] objectArray = listeners = this.zoomWheelListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ZoomWheelListener.class) continue;
                ((ZoomWheelListener)listeners[i + 1]).zoomIn(new ZoomWheelEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireZoomOut() {
        Object[] listeners;
        Object[] objectArray = listeners = this.zoomWheelListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ZoomWheelListener.class) continue;
                ((ZoomWheelListener)listeners[i + 1]).zoomOut(new ZoomWheelEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean isLockWheel() {
        return this.lockWheel;
    }

    public void lockWheel() {
        this.lockWheel = true;
    }

    public void unlockWheel() {
        this.lockWheel = false;
    }

    public int getZoomFactor() {
        return this.factor;
    }

    public void setZoomFactor(int factor) {
        this.factor = factor;
    }

    private void boundZoomIn() {
        double w = this.getProjection().getDevice2D().getDeviceWidth();
        double h = this.getProjection().getDevice2D().getDeviceHeight();
        Point2D.Double pMinXMinYDevice = null;
        Point2D.Double pMaxXMaxYDevice = null;
        if (this.zoomWheelType == ZoomWheelType.ZoomXY) {
            pMinXMinYDevice = new Point2D.Double(w / (double)this.factor, h - h / (double)this.factor);
            pMaxXMaxYDevice = new Point2D.Double(w - w / (double)this.factor, h / (double)this.factor);
        } else if (this.zoomWheelType == ZoomWheelType.ZoomX) {
            pMinXMinYDevice = new Point2D.Double(w / (double)this.factor, h);
            pMaxXMaxYDevice = new Point2D.Double(w - w / (double)this.factor, 0.0);
        } else if (this.zoomWheelType == ZoomWheelType.ZoomY) {
            pMinXMinYDevice = new Point2D.Double(0.0, h - h / (double)this.factor);
            pMaxXMaxYDevice = new Point2D.Double(w, h / (double)this.factor);
        }
        Point2D pMinXMinYUser = this.getProjection().pixelToUser(pMinXMinYDevice);
        Point2D pMaxXMaxYUser = this.getProjection().pixelToUser(pMaxXMaxYDevice);
        if (this.getProjection() instanceof Projection.Linear) {
            Projection.Linear wl = (Projection.Linear)this.getProjection();
            wl.bound(pMinXMinYUser.getX(), pMaxXMaxYUser.getX(), pMinXMinYUser.getY(), pMaxXMaxYUser.getY());
        }
    }

    private void boundZoomOut() {
        Projection w2d = this.getProjection();
        double w = w2d.getDevice2D().getDeviceWidth();
        double h = w2d.getDevice2D().getDeviceHeight();
        Point2D.Double pMinXMinYDevice = null;
        Point2D.Double pMaxXMaxYDevice = null;
        if (this.zoomWheelType == ZoomWheelType.ZoomXY) {
            pMinXMinYDevice = new Point2D.Double(-w / (double)this.factor, h + h / (double)this.factor);
            pMaxXMaxYDevice = new Point2D.Double(w + w / (double)this.factor, -h / (double)this.factor);
        } else if (this.zoomWheelType == ZoomWheelType.ZoomX) {
            pMinXMinYDevice = new Point2D.Double(-w / (double)this.factor, h);
            pMaxXMaxYDevice = new Point2D.Double(w + w / (double)this.factor, 0.0);
        } else if (this.zoomWheelType == ZoomWheelType.ZoomY) {
            pMinXMinYDevice = new Point2D.Double(0.0, h + h / (double)this.factor);
            pMaxXMaxYDevice = new Point2D.Double(w, -h / (double)this.factor);
        }
        Point2D pMinXMinYUser = w2d.pixelToUser(pMinXMinYDevice);
        Point2D pMaxXMaxYUser = w2d.pixelToUser(pMaxXMaxYDevice);
        if (this.getProjection() instanceof Projection.Linear) {
            Projection.Linear wl = (Projection.Linear)this.getProjection();
            wl.bound(pMinXMinYUser.getX(), pMaxXMaxYUser.getX(), pMinXMinYUser.getY(), pMaxXMaxYUser.getY());
        }
    }

    public void zoomIn() {
        this.boundZoomIn();
        this.zoomMessage = "ZOOM IN";
        this.getProjection().getDevice2D().repaintDevice();
    }

    public void zoomOut() {
        this.boundZoomOut();
        this.zoomMessage = "ZOOM OUT";
        this.getProjection().getDevice2D().repaintDevice();
    }

    @Override
    public void onWheel(MouseWheelEvent mwe) {
        if (!this.zoomEnabled) {
            return;
        }
        this.lockWheel();
        int rotation = mwe.getWheelRotation();
        if (rotation < 0) {
            int count = -rotation;
            for (int i = 0; i < count; ++i) {
                this.zoomIn();
                this.fireZoomIn();
                mwe.consume();
            }
        } else {
            int count = rotation;
            for (int i = 0; i < count; ++i) {
                this.zoomOut();
                this.fireZoomOut();
                mwe.consume();
            }
        }
    }

    private void paintZooming(Graphics2D g2d) {
        if (this.zoomMessage != null) {
            g2d.setColor(this.getProjection().getThemeColor().darker());
            Font f = new Font("Dialog", 0, 12);
            g2d.setFont(f);
            JComponent comp = this.getProjection().getView().getViewPartComponent(ViewPart.North);
            if (this.zoomMessage != null) {
                g2d.drawString(this.zoomMessage, this.getProjection().getView().getPlaceHolderAxisWest(), comp.getHeight() - 5);
            }
            if (this.messageCleaner == null) {
                this.messageCleaner = new MessageCleaner();
                this.messageCleaner.start();
            } else if (!this.messageCleaner.isAlive()) {
                this.messageCleaner = new MessageCleaner();
                this.messageCleaner.start();
            }
        }
    }

    @Override
    public void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
    }

    class MessageCleaner
    extends Thread {
        MessageCleaner() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                ZoomWheelPlugin.this.unlockWheel();
                ZoomWheelPlugin.this.zoomMessage = null;
                if (ZoomWheelPlugin.this.getProjection() != null && ZoomWheelPlugin.this.getProjection().getView() != null) {
                    ZoomWheelPlugin.this.getProjection().getView().getViewPartComponent(ViewPart.North).repaint();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class ZoomWheelEnabledAction
    implements ActionListener {
        private boolean enabled;

        public ZoomWheelEnabledAction(boolean status) {
            this.enabled = status;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ZoomWheelPlugin.this.zoomEnabled = ZoomWheelEnabledAction.this.enabled;
                }
            });
        }
    }

    public static enum ZoomWheelType {
        ZoomXY,
        ZoomX,
        ZoomY;

    }
}

