/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.projection;

public class ProjectionBound {
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    public ProjectionBound(double minX, double maxX, double minY, double maxY) {
        if (minX > maxX) {
            throw new IllegalArgumentException("maximum x should be greater or equal than minimum x");
        }
        if (minY > maxY) {
            throw new IllegalArgumentException("maximum y should be greater or equal than minimum y");
        }
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }
}

