/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.jensoft.core.device.DevicePartComponent;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.projection.ProjectionEvent;
import org.jensoft.core.projection.ProjectionListener;
import org.jensoft.core.view.ViewEmitter;
import org.jensoft.core.view.ViewEvent;
import org.jensoft.core.view.ViewListener;
import org.jensoft.core.view.ViewPart;
import org.jensoft.core.view.ViewPartComponent;
import org.jensoft.core.view.WidgetPlugin;
import org.jensoft.core.view.background.ViewBackgroundPainter;
import org.jensoft.core.widget.WidgetFolder;

public class View
extends JComponent
implements ProjectionListener,
ComponentListener,
FocusListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private int placeHolderAxisWest = 40;
    private int placeHolderAxisEast = 40;
    private int placeHolderAxisSouth = 40;
    private int placeHolderAxisNorth = 40;
    private ViewPartComponent axisSouth;
    private ViewPartComponent axisNorth;
    private ViewPartComponent axisWest;
    private ViewPartComponent axisEast;
    private DevicePartComponent device2D;
    private JPanel projectionContainer;
    private JPanel headerContainer;
    private JPanel footerContainer;
    private ViewBackgroundPainter backgroundPainter;
    private WidgetPlugin widgetPlugin = new WidgetPlugin();
    protected EventListenerList viewListenerList = new EventListenerList();
    private int folderGuardInterval = 4;
    private List<Projection> projections = new Vector<Projection>();
    private Projection activeProjection;
    private String viewKey;
    private String apiKey;

    public View() {
        this.initComponent();
    }

    public View(int placeHolderAxisWest, int placeHolderAxisEast, int placeHolderAxisSouth, int placeHolderAxisNorth) {
        this.placeHolderAxisWest = placeHolderAxisWest;
        this.placeHolderAxisEast = placeHolderAxisEast;
        this.placeHolderAxisSouth = placeHolderAxisSouth;
        this.placeHolderAxisNorth = placeHolderAxisNorth;
        this.initComponent();
    }

    public View(int placeHolderAxis) {
        this.placeHolderAxisWest = placeHolderAxis;
        this.placeHolderAxisEast = placeHolderAxis;
        this.placeHolderAxisSouth = placeHolderAxis;
        this.placeHolderAxisNorth = placeHolderAxis;
        this.initComponent();
    }

    public JPanel getHeaderContainer() {
        return this.headerContainer;
    }

    public JPanel getFooterContainer() {
        return this.footerContainer;
    }

    public DevicePartComponent getDevice2D() {
        return this.device2D;
    }

    public void repaintDevice() {
        this.device2D.repaintDevice();
    }

    public void repaintDevice(int x, int y, int width, int height) {
        this.device2D.repaint(x - 2, y - 2, width + 4, height + 4);
    }

    public void repaintDevice(Rectangle rect) {
        this.device2D.repaint((int)(rect.getX() - 2.0), (int)(rect.getY() - 2.0), (int)(rect.getWidth() + 4.0), (int)(rect.getHeight() + 4.0));
    }

    public void repaintDeviceBand(DeviceBand deviceBand, int start, int delta) {
        if (deviceBand == DeviceBand.XBand) {
            this.device2D.repaint(start, 0, delta, this.device2D.getHeight());
        }
        if (deviceBand == DeviceBand.YBand) {
            this.device2D.repaint(0, start, this.device2D.getWidth(), delta);
        }
    }

    public void repaintView() {
        this.projectionContainer.repaint();
    }

    public void repaintPart(ViewPart viewPart) {
        if (viewPart == ViewPart.North) {
            this.axisNorth.repaint();
        } else if (viewPart == ViewPart.South) {
            this.axisSouth.repaint();
        } else if (viewPart == ViewPart.West) {
            this.axisWest.repaint();
        } else if (viewPart == ViewPart.East) {
            this.axisEast.repaint();
        } else if (viewPart == ViewPart.Device) {
            this.device2D.repaintDevice();
        }
        this.projectionContainer.repaint();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.projectionContainer = new JPanel();
        this.projectionContainer.setLayout(new BorderLayout());
        this.projectionContainer.setOpaque(false);
        this.createView();
        this.add((Component)this.projectionContainer, "Center");
        this.headerContainer = new JPanel();
        this.headerContainer.setLayout(new BorderLayout());
        this.headerContainer.setOpaque(false);
        this.add((Component)this.headerContainer, "North");
        this.footerContainer = new JPanel();
        this.footerContainer.setLayout(new BorderLayout());
        this.footerContainer.setOpaque(false);
        this.add((Component)this.footerContainer, "South");
        this.widgetPlugin.setView(this);
        this.addComponentListener(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    public Projection getActiveProjection() {
        return this.activeProjection;
    }

    public void setActiveProjection(Projection active) {
        for (Projection w2d : this.getProjections()) {
            w2d.unlockActive();
        }
        this.activeProjection = active;
        if (active != null) {
            this.activeProjection.lockActive();
            this.fireProjectionSelected();
        }
    }

    public void addViewListener(ViewListener listener) {
        this.viewListenerList.add(ViewListener.class, listener);
    }

    public void removeViewListener(ViewListener listener) {
        this.viewListenerList.remove(ViewListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProjectionSelected() {
        Object[] listeners;
        ViewEvent v2dEvent = new ViewEvent(this);
        Object[] objectArray = listeners = this.viewListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ViewListener.class) continue;
                ((ViewListener)listeners[i + 1]).viewProjectionSelected(v2dEvent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public List<Projection> getProjections() {
        return this.projections;
    }

    public void registerProjection(Projection proj) {
        if (this.projections.contains(proj)) {
            return;
        }
        if (proj.getName() == null) {
            proj.setName("Proj " + this.projections.size());
        }
        this.projections.add(proj);
        proj.setDevice2D(this.device2D);
        proj.setView(this);
        proj.addProjectionListener(this);
        this.setActiveProjection(proj);
        this.device2D.registerProjection(proj);
        proj.onViewRegister();
    }

    public void unregisterProjection(Projection proj) {
        if (proj == null) {
            return;
        }
        if (proj.equals(this.getActiveProjection())) {
            this.setActiveProjection(null);
        }
        this.projections.remove(proj);
        this.device2D.unregisterProjection(proj);
        if (this.projections.size() > 0) {
            this.setActiveProjection(this.projections.get(this.projections.size() - 1));
        }
    }

    public JComponent getViewPartComponent(ViewPart viewPart) {
        if (viewPart == ViewPart.North) {
            return this.axisNorth;
        }
        if (viewPart == ViewPart.South) {
            return this.axisSouth;
        }
        if (viewPart == ViewPart.West) {
            return this.axisWest;
        }
        if (viewPart == ViewPart.East) {
            return this.axisEast;
        }
        if (viewPart == ViewPart.Device) {
            return this.device2D;
        }
        return null;
    }

    private void createView() {
        this.setDoubleBuffered(false);
        this.axisEast = new ViewPartComponent(ViewPart.East, this);
        Dimension dimMarginRight = new Dimension(this.placeHolderAxisEast, 10);
        this.axisEast.setPreferredSize(dimMarginRight);
        this.axisEast.setDoubleBuffered(false);
        this.axisWest = new ViewPartComponent(ViewPart.West, this);
        Dimension dimMarginLeft = new Dimension(this.placeHolderAxisWest, 10);
        this.axisWest.setPreferredSize(dimMarginLeft);
        this.axisWest.setDoubleBuffered(false);
        this.axisNorth = new ViewPartComponent(ViewPart.North, this);
        Dimension dimMarginNorth = new Dimension(10, this.placeHolderAxisNorth);
        this.axisNorth.setPreferredSize(dimMarginNorth);
        this.axisNorth.setDoubleBuffered(false);
        this.axisSouth = new ViewPartComponent(ViewPart.South, this);
        Dimension dimMarginSouth = new Dimension(10, this.placeHolderAxisSouth);
        this.axisSouth.setPreferredSize(dimMarginSouth);
        this.axisSouth.setDoubleBuffered(false);
        this.device2D = new DevicePartComponent();
        this.device2D.setDoubleBuffered(false);
        this.device2D.setView(this);
        this.addViewListener(this.device2D);
        this.projectionContainer.add((Component)this.axisNorth, "North");
        this.projectionContainer.add((Component)this.axisSouth, "South");
        this.projectionContainer.add((Component)this.axisEast, "East");
        this.projectionContainer.add((Component)this.axisWest, "West");
        this.projectionContainer.add((Component)this.device2D, "Center");
    }

    public void setDeviceBackground(Color deviceBackground) {
        this.device2D.setOpaque(true);
        this.device2D.setBackground(deviceBackground);
    }

    public void setPartBackground(Color partBackground, ViewPart ... windowParts) {
        for (int i = 0; i < windowParts.length; ++i) {
            JComponent compPart = this.getViewPartComponent(windowParts[i]);
            if (compPart == null) continue;
            compPart.setOpaque(true);
            compPart.setBackground(partBackground);
        }
    }

    @Override
    public void setBackground(Color bg) {
        this.setPartBackground(bg, ViewPart.Device, ViewPart.East, ViewPart.West, ViewPart.North, ViewPart.South);
    }

    public WidgetPlugin getWidgetPlugin() {
        return this.widgetPlugin;
    }

    @Override
    public void projectionBoundChanged(ProjectionEvent w2dEvent) {
        this.axisEast.repaint();
        this.axisWest.repaint();
        this.axisNorth.repaint();
        this.axisSouth.repaint();
        this.device2D.repaintDevice();
    }

    @Override
    public void projectionLockActive(ProjectionEvent w2dEvent) {
    }

    @Override
    public void projectionUnlockActive(ProjectionEvent w2dEvent) {
    }

    @Override
    public void projectionResized(ProjectionEvent w2dEvent) {
    }

    public void setPlaceHolder(int placeHolder, ViewPart ... viewParts) {
        for (int i = 0; i < viewParts.length; ++i) {
            ViewPart viewPart = viewParts[i];
            if (viewPart == ViewPart.North) {
                this.setPlaceHolderAxisNorth(placeHolder);
                continue;
            }
            if (viewPart == ViewPart.South) {
                this.setPlaceHolderAxisSouth(placeHolder);
                continue;
            }
            if (viewPart == ViewPart.West) {
                this.setPlaceHolderAxisWest(placeHolder);
                continue;
            }
            if (viewPart != ViewPart.East) continue;
            this.setPlaceHolderAxisEast(placeHolder);
        }
    }

    public void setPlaceHolder(int placeHolder, ViewPart viewPart) {
        if (viewPart == ViewPart.North) {
            this.setPlaceHolderAxisNorth(placeHolder);
        } else if (viewPart == ViewPart.South) {
            this.setPlaceHolderAxisSouth(placeHolder);
        } else if (viewPart == ViewPart.West) {
            this.setPlaceHolderAxisWest(placeHolder);
        } else if (viewPart == ViewPart.East) {
            this.setPlaceHolderAxisEast(placeHolder);
        }
    }

    public void setPlaceHolder(int placeHolder) {
        this.setPlaceHolderAxisEast(placeHolder);
        this.setPlaceHolderAxisWest(placeHolder);
        this.setPlaceHolderAxisNorth(placeHolder);
        this.setPlaceHolderAxisSouth(placeHolder);
    }

    public int getPlaceHolderAxisWest() {
        return this.placeHolderAxisWest;
    }

    public void setPlaceHolderAxisWest(int placeHolderAxisWest) {
        int old = this.getPlaceHolderAxisWest();
        this.placeHolderAxisWest = placeHolderAxisWest;
        Dimension dimMarginLeft = new Dimension(placeHolderAxisWest, 10);
        this.axisWest.setPreferredSize(dimMarginLeft);
        this.axisWest.setSize(dimMarginLeft);
        this.firePropertyChange("placeHolderAxisWEST", old, this.getPlaceHolderAxisWest());
        this.revalidate();
    }

    public int getPlaceHolderAxisEast() {
        return this.placeHolderAxisEast;
    }

    public void setPlaceHolderAxisEast(int placeHolderAxisEast) {
        int old = this.getPlaceHolderAxisEast();
        this.placeHolderAxisEast = placeHolderAxisEast;
        Dimension dimMarginRight = new Dimension(placeHolderAxisEast, 10);
        this.axisEast.setPreferredSize(dimMarginRight);
        this.axisEast.setSize(dimMarginRight);
        this.firePropertyChange("placeHolderAxisEAST", old, this.getPlaceHolderAxisEast());
        this.revalidate();
    }

    public int getPlaceHolderAxisSouth() {
        return this.placeHolderAxisSouth;
    }

    public void setPlaceHolderAxisSouth(int placeHolderAxisSouth) {
        int old = this.getPlaceHolderAxisSouth();
        this.placeHolderAxisSouth = placeHolderAxisSouth;
        Dimension dimMarginSouth = new Dimension(10, placeHolderAxisSouth);
        this.axisSouth.setPreferredSize(dimMarginSouth);
        this.axisSouth.setSize(dimMarginSouth);
        this.firePropertyChange("placeHolderAxisSOUTH", old, this.getPlaceHolderAxisSouth());
        this.revalidate();
    }

    public int getPlaceHolderAxisNorth() {
        return this.placeHolderAxisNorth;
    }

    public void setPlaceHolderAxisNorth(int placeHolderAxisNorth) {
        int old = this.getPlaceHolderAxisNorth();
        this.placeHolderAxisNorth = placeHolderAxisNorth;
        Dimension dimMarginNorth = new Dimension(10, placeHolderAxisNorth);
        this.axisNorth.setPreferredSize(dimMarginNorth);
        this.axisNorth.setSize(dimMarginNorth);
        this.firePropertyChange("placeHolderAxisNORTH", old, this.getPlaceHolderAxisNorth());
        this.revalidate();
    }

    public WidgetFolder newFolderIntanceByPosition(String id, double width, double height, int xp, int yp) {
        double deviceWidth = this.device2D.getWidth();
        double deviceHeight = this.device2D.getHeight();
        int folderMaxX = (int)(deviceWidth / (width + (double)(2 * this.folderGuardInterval)));
        int folderMaxY = (int)(deviceHeight / (height + (double)(2 * this.folderGuardInterval)));
        ArrayList<WidgetFolder> volatilesFolders = new ArrayList<WidgetFolder>();
        for (int x = 0; x <= folderMaxX; ++x) {
            for (int y = 0; y <= folderMaxY; ++y) {
                WidgetFolder folder = new WidgetFolder();
                folder.setId(id);
                folder.setWidth(width);
                folder.setHeight(height);
                folder.setxIndex(x);
                folder.setyIndex(y);
                folder.setGuardInterval(this.folderGuardInterval);
                volatilesFolders.add(folder);
                if (x < folderMaxX && y < folderMaxY) {
                    folder.setX((width + (double)(2 * this.folderGuardInterval)) * (double)x + (double)this.folderGuardInterval);
                    folder.setY((height + (double)(2 * this.folderGuardInterval)) * (double)y + (double)this.folderGuardInterval);
                    continue;
                }
                if (x == folderMaxX && y == folderMaxY) {
                    folder.setX(deviceWidth - width - (double)this.folderGuardInterval);
                    folder.setY(deviceHeight - height - (double)this.folderGuardInterval);
                    continue;
                }
                if (x < folderMaxX && y == folderMaxY) {
                    folder.setX((width + (double)(2 * this.folderGuardInterval)) * (double)x + (double)this.folderGuardInterval);
                    folder.setY(deviceHeight - height - (double)this.folderGuardInterval);
                    continue;
                }
                if (x != folderMaxX || y >= folderMaxY) continue;
                folder.setX(deviceWidth - width - (double)this.folderGuardInterval);
                folder.setY((height + (double)(2 * this.folderGuardInterval)) * (double)y + (double)this.folderGuardInterval);
            }
        }
        for (WidgetFolder vdf : volatilesFolders) {
            if (!((double)xp > vdf.getX()) || !((double)xp < vdf.getX() + vdf.getWidth()) || !((double)yp > vdf.getY()) || !((double)yp < vdf.getY() + vdf.getHeight())) continue;
            return vdf;
        }
        return null;
    }

    public WidgetFolder newWidgetFolderIntance(String id, double width, double height, int xIndex, int yIndex) {
        double deviceWidth = this.device2D.getWidth();
        double deviceHeight = this.device2D.getHeight();
        int folderMaxX = (int)(deviceWidth / (width + (double)(2 * this.folderGuardInterval)));
        int folderMaxY = (int)(deviceHeight / (height + (double)(2 * this.folderGuardInterval)));
        if (xIndex < 0) {
            xIndex = 0;
        }
        if (xIndex > folderMaxX) {
            xIndex = folderMaxX;
        }
        if (yIndex < 0) {
            yIndex = 0;
        }
        if (yIndex > folderMaxY) {
            yIndex = folderMaxY;
        }
        WidgetFolder folder = new WidgetFolder();
        folder.setId(id);
        folder.setWidth(width);
        folder.setHeight(height);
        folder.setxIndex(xIndex);
        folder.setyIndex(yIndex);
        folder.setGuardInterval(this.folderGuardInterval);
        if (xIndex < folderMaxX && yIndex < folderMaxY) {
            folder.setX((width + (double)(2 * this.folderGuardInterval)) * (double)xIndex + (double)this.folderGuardInterval);
            folder.setY((height + (double)(2 * this.folderGuardInterval)) * (double)yIndex + (double)this.folderGuardInterval);
        } else if (xIndex == folderMaxX && yIndex == folderMaxY) {
            folder.setX(deviceWidth - width - (double)this.folderGuardInterval);
            folder.setY(deviceHeight - height - (double)this.folderGuardInterval);
        } else if (xIndex < folderMaxX && yIndex == folderMaxY) {
            folder.setX((width + (double)(2 * this.folderGuardInterval)) * (double)xIndex + (double)this.folderGuardInterval);
            folder.setY(deviceHeight - height - (double)this.folderGuardInterval);
        } else if (xIndex == folderMaxX && yIndex < folderMaxY) {
            folder.setX(deviceWidth - width - (double)this.folderGuardInterval);
            folder.setY((height + (double)(2 * this.folderGuardInterval)) * (double)yIndex + (double)this.folderGuardInterval);
        }
        return folder;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.fireViewResized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireViewResized() {
        Object[] listeners;
        ViewEvent v2dEvent = new ViewEvent(this);
        Object[] objectArray = listeners = this.viewListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ViewListener.class) continue;
                ((ViewListener)listeners[i + 1]).viewResized(v2dEvent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.fireViewMoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireViewMoved() {
        Object[] listeners;
        ViewEvent v2dEvent = new ViewEvent(this);
        Object[] objectArray = listeners = this.viewListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ViewListener.class) continue;
                ((ViewListener)listeners[i + 1]).viewMoved(v2dEvent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.fireViewShown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireViewShown() {
        Object[] listeners;
        ViewEvent v2dEvent = new ViewEvent(this);
        Object[] objectArray = listeners = this.viewListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ViewListener.class) continue;
                ((ViewListener)listeners[i + 1]).viewShown(v2dEvent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.fireViewHidden();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireViewHidden() {
        Object[] listeners;
        ViewEvent v2dEvent = new ViewEvent(this);
        Object[] objectArray = listeners = this.viewListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ViewListener.class) continue;
                ((ViewListener)listeners[i + 1]).viewHidden(v2dEvent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.fireViewFocusGained();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireViewFocusGained() {
        Object[] listeners;
        ViewEvent v2dEvent = new ViewEvent(this);
        Object[] objectArray = listeners = this.viewListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ViewListener.class) continue;
                ((ViewListener)listeners[i + 1]).viewFocusGained(v2dEvent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.fireViewFocusLost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireViewFocusLost() {
        Object[] listeners;
        ViewEvent v2dEvent = new ViewEvent(this);
        Object[] objectArray = listeners = this.viewListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ViewListener.class) continue;
                ((ViewListener)listeners[i + 1]).viewFocusLost(v2dEvent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public ViewBackgroundPainter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public void setBackgroundPainter(ViewBackgroundPainter backgroundPainter) {
        this.backgroundPainter = backgroundPainter;
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        Graphics2D g2 = (Graphics2D)g;
        this.paintPlugins(g2);
        this.copyright((Graphics2D)g);
    }

    public void copyright(Graphics2D g2d) {
        String copyright = "\u00a9JenSoftAPI http://wwww.jensoftapi.com";
        Color c = ColorPalette.getRandomColor();
        g2d.setColor(c);
        g2d.setFont(new Font("Verdana", 0, 10));
        g2d.drawString(copyright, this.getPlaceHolderAxisWest(), this.getPlaceHolderAxisNorth() - 10);
    }

    protected void paintPlugins(Graphics2D g2d) {
        List<AbstractPlugin> plugins;
        List<Projection> projections = this.getProjections();
        for (Projection proj : projections) {
            if (!proj.isVisible() || proj.equals(this.getActiveProjection())) continue;
            List<AbstractPlugin> plugins2 = proj.getPluginRegistry();
            Collections.sort(plugins2, AbstractPlugin.getPriorityComparator());
            if (plugins2 == null) continue;
            for (int j = 0; j < plugins2.size(); ++j) {
                AbstractPlugin plugin = plugins2.get(j);
                plugin.paint(this, g2d, ViewPart.View);
            }
        }
        if (this.getActiveProjection() != null && this.getActiveProjection().isVisible() && (plugins = this.getActiveProjection().getPluginRegistry()) != null) {
            Collections.sort(plugins, AbstractPlugin.getPriorityComparator());
            for (int j = 0; j < plugins.size(); ++j) {
                AbstractPlugin plugin = plugins.get(j);
                plugin.paint(this, g2d, ViewPart.View);
            }
        }
        try {
            this.getWidgetPlugin().paint(this, g2d, ViewPart.View);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.backgroundPainter != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.backgroundPainter.paintViewBackground(this, this.getWidth(), this.getHeight(), g2d);
        }
    }

    public String getViewKey() {
        return this.viewKey;
    }

    public void setViewKey(String viewKey) {
        this.viewKey = viewKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public ViewEmitter createViewEmitter() {
        return new ViewEmitter(this);
    }

    public static enum DeviceBand {
        YBand,
        XBand;

    }
}

