/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.jensoft.core.device.DevicePartComponent;
import org.jensoft.core.view.Base64;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;
import org.jensoft.core.view.ViewPartComponent;

public class ViewEmitter {
    private View view;

    public ViewEmitter() {
    }

    public ViewEmitter(View view) {
        this.view = view;
    }

    public BufferedImage getImageView(int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("view width and view height should be greater than zero");
        }
        BufferedImage viewImage = new BufferedImage(width, height, 2);
        Graphics viewGraphics = viewImage.getGraphics();
        Graphics2D g2d = (Graphics2D)viewGraphics;
        Dimension old = this.view.getSize();
        this.view.setSize(new Dimension(width, height));
        ViewPartComponent northPart = (ViewPartComponent)this.view.getViewPartComponent(ViewPart.North);
        ViewPartComponent southPart = (ViewPartComponent)this.view.getViewPartComponent(ViewPart.South);
        ViewPartComponent eastPart = (ViewPartComponent)this.view.getViewPartComponent(ViewPart.East);
        ViewPartComponent westPart = (ViewPartComponent)this.view.getViewPartComponent(ViewPart.West);
        DevicePartComponent devicePart = (DevicePartComponent)this.view.getViewPartComponent(ViewPart.Device);
        northPart.setSize(width, this.view.getPlaceHolderAxisNorth());
        southPart.setSize(width, this.view.getPlaceHolderAxisSouth());
        eastPart.setSize(this.view.getPlaceHolderAxisEast(), this.view.getHeight() - this.view.getPlaceHolderAxisNorth() - this.view.getPlaceHolderAxisSouth());
        westPart.setSize(this.view.getPlaceHolderAxisWest(), this.view.getHeight() - this.view.getPlaceHolderAxisNorth() - this.view.getPlaceHolderAxisSouth());
        devicePart.setSize(this.view.getWidth() - this.view.getPlaceHolderAxisWest() - this.view.getPlaceHolderAxisEast(), this.view.getHeight() - this.view.getPlaceHolderAxisNorth() - this.view.getPlaceHolderAxisSouth());
        BufferedImage northImage = null;
        if (this.view.getPlaceHolderAxisNorth() > 0) {
            northImage = new BufferedImage(this.view.getWidth(), this.view.getPlaceHolderAxisNorth(), 2);
            Graphics2D ng2d = (Graphics2D)northImage.getGraphics();
            northPart.paintComponent(ng2d);
            ng2d.dispose();
        }
        BufferedImage southImage = null;
        if (this.view.getPlaceHolderAxisSouth() > 0) {
            southImage = new BufferedImage(this.view.getWidth(), this.view.getPlaceHolderAxisSouth(), 2);
            Graphics2D sg2d = (Graphics2D)southImage.getGraphics();
            southPart.paintComponent(sg2d);
            sg2d.dispose();
        }
        BufferedImage eastImage = null;
        if (this.view.getPlaceHolderAxisEast() > 0) {
            eastImage = new BufferedImage(this.view.getPlaceHolderAxisEast(), this.view.getHeight() - this.view.getPlaceHolderAxisNorth() - this.view.getPlaceHolderAxisSouth(), 2);
            Graphics2D eg2d = (Graphics2D)eastImage.getGraphics();
            eastPart.paintComponent(eg2d);
            eg2d.dispose();
        }
        BufferedImage westImage = null;
        if (this.view.getPlaceHolderAxisWest() > 0) {
            westImage = new BufferedImage(this.view.getPlaceHolderAxisWest(), this.view.getHeight() - this.view.getPlaceHolderAxisNorth() - this.view.getPlaceHolderAxisSouth(), 2);
            Graphics2D wg2d = (Graphics2D)westImage.getGraphics();
            westPart.paintComponent(wg2d);
            wg2d.dispose();
        }
        BufferedImage deviceImage = null;
        if (this.view.getWidth() - this.view.getPlaceHolderAxisWest() - this.view.getPlaceHolderAxisEast() > 0 && this.view.getHeight() - this.view.getPlaceHolderAxisNorth() - this.view.getPlaceHolderAxisSouth() > 0) {
            deviceImage = new BufferedImage(this.view.getWidth() - this.view.getPlaceHolderAxisWest() - this.view.getPlaceHolderAxisEast(), this.view.getHeight() - this.view.getPlaceHolderAxisNorth() - this.view.getPlaceHolderAxisSouth(), 2);
            Graphics2D dg2d = (Graphics2D)deviceImage.getGraphics();
            devicePart.paintComponent(dg2d);
            dg2d.dispose();
        }
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        qualityHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        qualityHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHints(qualityHints);
        if (this.view.getBackgroundPainter() != null) {
            this.view.getBackgroundPainter().paintViewBackground(this.view, width, height, g2d);
        }
        if (northImage != null) {
            g2d.drawImage(northImage, 0, 0, northImage.getWidth(), northImage.getHeight(), null);
        }
        if (southImage != null) {
            g2d.drawImage(southImage, 0, this.view.getHeight() - this.view.getPlaceHolderAxisSouth(), southImage.getWidth(), southImage.getHeight(), null);
            southImage.flush();
        }
        if (eastImage != null) {
            g2d.drawImage(eastImage, this.view.getWidth() - this.view.getPlaceHolderAxisEast(), this.view.getPlaceHolderAxisNorth(), eastImage.getWidth(), eastImage.getHeight(), null);
            eastImage.flush();
        }
        if (westImage != null) {
            g2d.drawImage(westImage, 0, this.view.getPlaceHolderAxisNorth(), westImage.getWidth(), westImage.getHeight(), null);
            westImage.flush();
        }
        if (deviceImage != null) {
            g2d.drawImage(deviceImage, this.view.getPlaceHolderAxisWest(), this.view.getPlaceHolderAxisNorth(), deviceImage.getWidth(), deviceImage.getHeight(), null);
            deviceImage.flush();
        }
        g2d.dispose();
        viewImage.flush();
        if (old != null) {
            this.view.setSize(old);
        }
        return viewImage;
    }

    public BufferedImage emitAsBufferedImage() {
        return this.getImageView(this.view.getWidth(), this.view.getHeight());
    }

    public BufferedImage emitAsBufferedImage(int width, int height) {
        return this.getImageView(width, height);
    }

    public String emitAsImageBase64(int width, int height) {
        BufferedImage img = this.emitAsBufferedImage(width, height);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Base64 b64 = new Base64();
        String result = b64.encode(os.toByteArray());
        try {
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String emitAsImageBase64() {
        BufferedImage img = this.emitAsBufferedImage();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Base64 b64 = new Base64();
        String result = b64.encode(os.toByteArray());
        try {
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public View emitAsView() {
        return this.view;
    }

    public void emitPNGImageOnStream(OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)this.emitAsBufferedImage(), "png", outputStream);
    }

    public void emitPNGImageOnStream(OutputStream outputStream, int width, int height) throws IOException {
        ImageIO.write((RenderedImage)this.emitAsBufferedImage(width, height), "png", outputStream);
    }

    public void emitJPGImageOnStream(OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)this.emitAsBufferedImage(), "jpg", outputStream);
    }

    public void emitGIFImageOnStream(OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)this.emitAsBufferedImage(), "gif", outputStream);
    }

    public void emitAsImageFile(String directoryName, String imageFileName) throws IOException {
        File directoryFile = new File(directoryName);
        if (!directoryFile.exists()) {
            directoryFile.mkdir();
        }
        ImageIO.write((RenderedImage)this.emitAsBufferedImage(), "png", new FileOutputStream(directoryName + File.separator + imageFileName + ".png"));
    }
}

