/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.view;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class ViewPartComponent
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final long serialVersionUID = 651449492959746328L;
    private ViewPart viewPart;
    private View view;
    boolean lockPlugins = true;

    public ViewPartComponent(ViewPart viewPart, View view) {
        this.viewPart = viewPart;
        this.view = view;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public void unlockPlugins() {
        this.lockPlugins = false;
    }

    public void lockPlugins() {
        this.lockPlugins = true;
    }

    private void paintBackdrop(Graphics2D g2d) {
        if (!this.isOpaque()) {
            return;
        }
        if (this.getBackground() != null) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.lockPlugins) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        this.paintBackdrop(g2d);
        this.paintPlugins(g2d);
        g2d.dispose();
    }

    protected void paintPlugins(Graphics2D g2d) {
        List<AbstractPlugin> plugins;
        List<Projection> projections = this.view.getProjections();
        for (Projection proj : projections) {
            if (!proj.isVisible() || proj.equals(this.view.getActiveProjection())) continue;
            List<AbstractPlugin> plugins2 = proj.getPluginRegistry();
            Collections.sort(plugins2, AbstractPlugin.getPriorityComparator());
            if (plugins2 == null) continue;
            for (int j = 0; j < plugins2.size(); ++j) {
                AbstractPlugin plugin = plugins2.get(j);
                plugin.paint(this.view, g2d, this.viewPart);
            }
        }
        if (this.view.getActiveProjection() != null && this.view.getActiveProjection().isVisible() && (plugins = this.view.getActiveProjection().getPluginRegistry()) != null) {
            Collections.sort(plugins, AbstractPlugin.getPriorityComparator());
            for (int j = 0; j < plugins.size(); ++j) {
                AbstractPlugin plugin = plugins.get(j);
                plugin.paint(this.view, g2d, this.viewPart);
            }
        }
        try {
            this.view.getWidgetPlugin().paint(this.view, g2d, this.viewPart);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

