/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.view;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Dithering;
import org.jensoft.core.graphics.Fractional;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.PluginListener;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;
import org.jensoft.core.widget.Widget;
import org.jensoft.core.widget.WidgetFolder;

public class WidgetPlugin
extends AbstractPlugin
implements AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnMoveListener,
AbstractPlugin.OnDragListener,
AbstractPlugin.OnWheelListener {
    private boolean lockAboutFolderMessage = true;
    private Font font = new Font("Tahoma", 0, 10);
    private boolean destroyMessage = false;
    private List<PushingMessage> pushingMessages = new ArrayList<PushingMessage>();
    private String northMessage;

    public WidgetPlugin() {
        this.setName("WidgetPlugin");
        this.setOnPressListener(this);
        this.setOnMoveListener(this);
        this.setOnReleaseListener(this);
        this.setOnDragListener(this);
        this.setOnWheelListener(this);
        this.setTextAntialising(TextAntialiasing.On);
        this.setAntialiasing(Antialiasing.On);
        this.setDithering(Dithering.On);
        this.setFractionalMetrics(Fractional.On);
        this.setPriority(2000);
    }

    @Override
    public View getView() {
        return super.getView();
    }

    public boolean isLockAboutFolderMessage() {
        return this.lockAboutFolderMessage;
    }

    public void lockPostFolderMessage() {
        this.lockAboutFolderMessage = true;
    }

    public void unlockPostFolderMessage() {
        this.lockAboutFolderMessage = false;
    }

    public boolean isDestroyMessage() {
        return this.destroyMessage;
    }

    public void setDestroyMessage(boolean destroyMessage) {
        this.destroyMessage = destroyMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyMessage() {
        if (!this.destroyMessage) {
            return;
        }
        List<PushingMessage> list = this.pushingMessages;
        synchronized (list) {
            for (PushingMessage pushingMessage : this.pushingMessages) {
                if (!pushingMessage.isAlive()) continue;
                pushingMessage.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessage(String message, AbstractPlugin plugin, PushingBehavior pushingBehavior) {
        PushingMessage pm = null;
        Font f = new Font("Dialog", 0, 12);
        if (plugin != null) {
            pm = new PushingMessage(message, pushingBehavior, plugin.getThemeColor(), f);
        } else if (this.getView().getActiveProjection() != null) {
            pm = new PushingMessage(message, pushingBehavior, this.getView().getActiveProjection().getThemeColor(), f);
        }
        if (pm != null) {
            this.destroyMessage();
            List<PushingMessage> list = this.pushingMessages;
            synchronized (list) {
                this.pushingMessages.add(pm);
            }
            pm.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessage(String message, AbstractPlugin plugin, PushingBehavior pushingBehavior, Color color) {
        PushingMessage pm = null;
        Font f = new Font("Dialog", 0, 12);
        pm = new PushingMessage(message, pushingBehavior, color, f);
        if (pm != null) {
            this.destroyMessage();
            List<PushingMessage> list = this.pushingMessages;
            synchronized (list) {
                this.pushingMessages.add(pm);
            }
            pm.start();
        }
    }

    public void pushMessage(String message, AbstractPlugin plugin, PushingBehavior pushingBehavior, Font f) {
        PushingMessage pm = null;
        if (plugin != null) {
            pm = new PushingMessage(message, pushingBehavior, plugin.getThemeColor(), f);
        } else if (this.getView().getActiveProjection() != null) {
            pm = new PushingMessage(message, pushingBehavior, this.getView().getActiveProjection().getThemeColor(), f);
        }
        if (pm != null) {
            this.destroyMessage();
            this.pushingMessages.add(pm);
            pm.start();
        }
    }

    public void pushMessage(String message, int startDelay, AbstractPlugin plugin, PushingBehavior pushingBehavior, Font f) {
        PushingMessage pm = null;
        if (plugin != null) {
            pm = new PushingMessage(message, startDelay, pushingBehavior, plugin.getThemeColor(), f);
        } else if (this.getView().getActiveProjection() != null) {
            pm = new PushingMessage(message, startDelay, pushingBehavior, this.getView().getActiveProjection().getThemeColor(), f);
        }
        if (pm != null) {
            this.destroyMessage();
            this.pushingMessages.add(pm);
            pm.start();
        }
    }

    public void pushMessage(String message, int startDelay, AbstractPlugin plugin, PushingBehavior pushingBehavior, Font f, Color c) {
        PushingMessage pm = null;
        pm = new PushingMessage(message, startDelay, pushingBehavior, c, f);
        if (pm != null) {
            this.destroyMessage();
            this.pushingMessages.add(pm);
            pm.start();
        }
    }

    public void pushMessage(String message, int startDelay, AbstractPlugin plugin, PushingBehavior pushingBehavior, Font f, Color c, boolean alphaTransition) {
        PushingMessage pm = null;
        pm = new PushingMessage(message, startDelay, pushingBehavior, c, f, alphaTransition);
        if (pm != null) {
            this.destroyMessage();
            this.pushingMessages.add(pm);
            pm.start();
        }
    }

    public void setNorthMessage(String msg) {
        this.northMessage = msg;
        this.getView().getViewPartComponent(ViewPart.North).repaint();
    }

    private void paintNorthMessage(Graphics2D g2d) {
        if (this.northMessage == null) {
            return;
        }
        if (this.getView().getActiveProjection() == null) {
            return;
        }
        g2d.setColor(this.getView().getActiveProjection().getThemeColor().darker());
        g2d.setFont(this.font);
        JComponent comp = this.getView().getViewPartComponent(ViewPart.North);
        g2d.drawString(this.northMessage, this.getView().getPlaceHolderAxisWest(), comp.getHeight() - 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintPushingMessage(Graphics2D g2d) {
        Antialiasing a = Antialiasing.On;
        a.configureGraphics(g2d);
        int northHeight = this.getView().getViewPartComponent(ViewPart.North).getHeight();
        List<PushingMessage> list = this.pushingMessages;
        synchronized (list) {
            for (PushingMessage pm : this.pushingMessages) {
                if (pm.message == null || !pm.isAlive()) continue;
                g2d.setFont(pm.font);
                if (pm.alpha < 0.0f) {
                    pm.alpha = 0.0f;
                }
                g2d.setColor(ColorPalette.alpha(pm.color, (int)(250.0f * pm.alpha)));
                g2d.setComposite(AlphaComposite.getInstance(3, pm.alpha));
                g2d.drawString(pm.message, this.getView().getPlaceHolderAxisWest() + pm.countCurentEffect * this.getView().getDevice2D().getDeviceWidth() / pm.countBaseEffect, northHeight - 5);
            }
        }
    }

    private void moveWidgetOperationCheckMove(MouseEvent me) {
        Projection w2d = this.getView().getActiveProjection();
        for (AbstractPlugin plugin : w2d.getPluginRegistry()) {
            if (plugin.isSelectable() && !plugin.isLockSelected()) continue;
            for (Widget widget : plugin.getWidgets()) {
                WidgetFolder widgetFolder = widget.getWidgetFolder();
                if (widgetFolder == null) continue;
                if (widgetFolder.intercept(me.getX(), me.getY())) {
                    widgetFolder.setLockRollover(true);
                    this.getView().repaintDevice();
                    continue;
                }
                widgetFolder.interruptPress();
                if (!widgetFolder.isLockRollover()) continue;
                widgetFolder.setLockRollover(false);
                this.getView().repaintDevice();
            }
        }
    }

    @Override
    public void addPluginListener(PluginListener listener) {
        super.addPluginListener(listener);
    }

    private void moveWidgetOperationCheckPress(MouseEvent me) {
        if (this.getView().getActiveProjection() == null) {
            return;
        }
        Projection w2d = this.getView().getActiveProjection();
        block0: for (AbstractPlugin plugin : w2d.getPluginRegistry()) {
            if (plugin.isSelectable() && !plugin.isLockSelected()) continue;
            for (Widget widget : plugin.getWidgets()) {
                WidgetFolder widgetFolder;
                if (!widget.isLockWidget() || (widgetFolder = widget.getWidgetFolder()) == null) continue;
                if (widgetFolder.intercept(me.getX(), me.getY()) && !widget.isNoMoveOperation()) {
                    widgetFolder.setCurrentDragX(me.getX());
                    widgetFolder.setCurrentDragY(me.getY());
                    widgetFolder.startPress(800, new WidgetFolder.AsyncPressWidgetCallback(){

                        @Override
                        public void folderPress() {
                            WidgetPlugin.this.getView().repaintDevice();
                            WidgetPlugin.this.setNorthMessage("LOCK WIDGET/" + widgetFolder.getId());
                            WidgetPlugin.this.passivePlugins();
                        }
                    });
                    continue block0;
                }
                widgetFolder.interruptPress();
                this.activePlugins();
            }
        }
        this.getView().repaintDevice();
    }

    private void moveWidgetOperationCheckDrag(MouseEvent me) {
        if (this.getView().getActiveProjection() == null) {
            return;
        }
        Projection w2d = this.getView().getActiveProjection();
        for (AbstractPlugin plugin : w2d.getPluginRegistry()) {
            for (Widget widget : plugin.getWidgets()) {
                WidgetFolder widgetFolder;
                if (!widget.isLockWidget() || (widgetFolder = widget.getWidgetFolder()) == null || !widgetFolder.isLockPress()) continue;
                WidgetFolder wf = widgetFolder.getPotentialFolder();
                widgetFolder.setCurrentDragX(me.getX());
                widgetFolder.setCurrentDragY(me.getY());
                this.getView().repaintDevice();
            }
        }
    }

    private void moveWidgetOperationCheckRelease(MouseEvent me) {
        if (this.getView().getActiveProjection() == null) {
            return;
        }
        this.setNorthMessage(null);
        Projection w2d = this.getView().getActiveProjection();
        for (AbstractPlugin plugin : w2d.getPluginRegistry()) {
            for (Widget widget : plugin.getWidgets()) {
                WidgetFolder widgetFolder;
                if (!widget.isLockWidget() || (widgetFolder = widget.getWidgetFolder()) == null) continue;
                if (widgetFolder.isLockPress() && widgetFolder.getTargetFolder() != null) {
                    widgetFolder.getOnPostListener().onPostWidget();
                    this.activePlugins();
                    if (this.isLockAboutFolderMessage()) {
                        this.pushMessage("POST/" + widgetFolder.getId() + "/" + widgetFolder.getTargetFolder().getxIndex() + "/" + widgetFolder.getTargetFolder().getyIndex(), plugin, PushingBehavior.Slow, this.font);
                    }
                }
                widgetFolder.interruptPress();
            }
        }
        this.getView().repaintDevice();
    }

    @Override
    public void onMove(MouseEvent me) {
        this.dispatchMove(me);
    }

    private void dispatchMove(MouseEvent me) {
        Projection w2d = this.getView().getActiveProjection();
        if (w2d == null) {
            return;
        }
        for (AbstractPlugin plugin : w2d.getPluginRegistry()) {
            if (plugin.isSelectable() && plugin.isLockSelected()) {
                for (Widget widget : plugin.getWidgets()) {
                    if (!widget.isLockWidget()) continue;
                    widget.interceptMove(me.getX(), me.getY());
                }
                continue;
            }
            for (Widget widget : plugin.getWidgets()) {
                if (!widget.isLockWidget()) continue;
                widget.interceptMove(me.getX(), me.getY());
            }
        }
    }

    @Override
    public void onWheel(MouseWheelEvent mwe) {
        this.dispatchWheel(mwe);
    }

    private void dispatchWheel(MouseWheelEvent mwe) {
        Projection w2d = this.getView().getActiveProjection();
        if (w2d == null) {
            return;
        }
        for (AbstractPlugin plugin : w2d.getPluginRegistry()) {
            if (plugin.isSelectable() && plugin.isLockSelected()) {
                for (Widget widget : plugin.getWidgets()) {
                    if (!widget.isLockWidget()) continue;
                    widget.interceptWheel(mwe.getWheelRotation());
                }
                continue;
            }
            for (Widget widget : plugin.getWidgets()) {
                if (!widget.isLockWidget()) continue;
                widget.interceptWheel(mwe.getWheelRotation());
            }
        }
    }

    @Override
    public void onDrag(MouseEvent me) {
        this.moveWidgetOperationCheckDrag(me);
        this.dispatchDrag(me);
    }

    private void dispatchDrag(MouseEvent me) {
        Projection w2d = this.getView().getActiveProjection();
        if (w2d == null) {
            return;
        }
        for (AbstractPlugin plugin : w2d.getPluginRegistry()) {
            if (plugin.isSelectable() && plugin.isLockSelected()) {
                for (Widget widget : plugin.getWidgets()) {
                    if (!widget.isLockWidget()) continue;
                    widget.interceptDrag(me.getX(), me.getY());
                }
                continue;
            }
            for (Widget widget : plugin.getWidgets()) {
                if (!widget.isLockWidget()) continue;
                widget.interceptDrag(me.getX(), me.getY());
            }
        }
    }

    @Override
    public void onPress(MouseEvent me) {
        this.moveWidgetOperationCheckPress(me);
        this.dispatchPress(me);
    }

    private void dispatchPress(MouseEvent me) {
        Projection w2d = this.getView().getActiveProjection();
        if (w2d == null) {
            return;
        }
        for (AbstractPlugin plugin : w2d.getPluginRegistry()) {
            if (plugin.isSelectable() && plugin.isLockSelected()) {
                for (Widget widget : plugin.getWidgets()) {
                    if (!widget.isLockWidget()) continue;
                    widget.interceptPress(me.getX(), me.getY());
                }
                continue;
            }
            for (Widget widget : plugin.getWidgets()) {
                if (!widget.isLockWidget()) continue;
                widget.interceptPress(me.getX(), me.getY());
            }
        }
    }

    @Override
    public void onRelease(MouseEvent me) {
        this.moveWidgetOperationCheckRelease(me);
        this.dispatchRelease(me);
    }

    private void dispatchRelease(MouseEvent me) {
        Projection w2d = this.getView().getActiveProjection();
        if (w2d == null) {
            return;
        }
        for (AbstractPlugin plugin : w2d.getPluginRegistry()) {
            if (plugin.isSelectable() && plugin.isLockSelected()) {
                for (Widget widget : plugin.getWidgets()) {
                    if (!widget.isLockWidget()) continue;
                    widget.interceptReleased(me.getX(), me.getY());
                }
                continue;
            }
            for (Widget widget : plugin.getWidgets()) {
                if (!widget.isLockWidget()) continue;
                widget.interceptReleased(me.getX(), me.getY());
            }
        }
    }

    private boolean isEmptyFolder(Widget widget, WidgetFolder potentialFolder) {
        Rectangle2D.Double rec0 = new Rectangle2D.Double(potentialFolder.getX(), potentialFolder.getY(), potentialFolder.getWidth(), potentialFolder.getHeight());
        Object hostPlugin = widget.getHost();
        for (Widget hostedPluginWidget : ((AbstractPlugin)hostPlugin).getWidgets()) {
            WidgetFolder widgetFolder;
            if (hostedPluginWidget == widget || !rec0.intersects((widgetFolder = hostedPluginWidget.getWidgetFolder()).getBounds2D())) continue;
            return false;
        }
        for (AbstractPlugin plugin : this.getView().getActiveProjection().getPluginRegistry()) {
            if (hostPlugin == plugin || plugin.isSelectable() && !plugin.isLockSelected()) continue;
            for (Widget pluginWidget : plugin.getWidgets()) {
                Rectangle2D.Double rec1;
                WidgetFolder widgetFolder = pluginWidget.getWidgetFolder();
                if (widgetFolder.getId().equals(potentialFolder.getId()) || !rec0.intersects(rec1 = new Rectangle2D.Double(widgetFolder.getX(), widgetFolder.getY(), widgetFolder.getWidth(), widgetFolder.getHeight()))) continue;
                return false;
            }
        }
        return true;
    }

    private void passivePlugins() {
        for (AbstractPlugin l : this.getView().getActiveProjection().getPluginRegistry()) {
            l.lockPassive();
        }
    }

    private void activePlugins() {
        for (AbstractPlugin l : this.getView().getActiveProjection().getPluginRegistry()) {
            l.unlockPassive();
        }
    }

    private void paintRolloverWidget(View v2d, Graphics2D g2d, ViewPart viewPart) {
        Projection w2d = this.getView().getActiveProjection();
        for (AbstractPlugin layout : w2d.getPluginRegistry()) {
            for (Widget widget : layout.getWidgets()) {
                WidgetFolder widgetFolder = widget.getWidgetFolder();
                if (!widgetFolder.isLockRollover()) continue;
                g2d.setColor(Color.WHITE);
                g2d.draw(widgetFolder.getSensible());
            }
        }
    }

    private void paintDragPhantomWidget(View v2d, Graphics2D g2d, ViewPart viewPart) {
        Projection w2d = this.getView().getActiveProjection();
        if (w2d == null) {
            return;
        }
        for (AbstractPlugin plugin : w2d.getPluginRegistry()) {
            for (Widget widget : plugin.getWidgets()) {
                WidgetFolder widgetFolder = widget.getWidgetFolder();
                if (widgetFolder == null || !widgetFolder.isLockPress()) continue;
                this.createPotential(g2d, widget, plugin);
            }
        }
    }

    private void createPotential(Graphics2D g2d, Widget widget, AbstractPlugin plugin) {
        WidgetFolder widgetFolder = widget.getWidgetFolder();
        Rectangle2D.Double r = new Rectangle2D.Double((double)widgetFolder.getCurrentDragX() - widgetFolder.getWidth() / 2.0, (double)widgetFolder.getCurrentDragY() - widgetFolder.getHeight() / 2.0, widgetFolder.getWidth(), widgetFolder.getHeight());
        g2d.setColor(Color.GREEN);
        g2d.draw(r);
        WidgetFolder widgetPotentialFolder = this.getView().newFolderIntanceByPosition(widgetFolder.getId(), widgetFolder.getWidth(), widgetFolder.getHeight(), widgetFolder.getCurrentDragX(), widgetFolder.getCurrentDragY());
        if (widgetPotentialFolder != null) {
            if (this.isEmptyFolder(widget, widgetPotentialFolder)) {
                widgetFolder.setPotentialFolder(widgetPotentialFolder);
                this.setNorthMessage(widgetFolder.getId() + "/" + widgetPotentialFolder.getxIndex() + "/" + widgetPotentialFolder.getyIndex() + "/valid");
                Rectangle2D.Double rpotential = new Rectangle2D.Double(widgetPotentialFolder.getX(), widgetPotentialFolder.getY(), widgetPotentialFolder.getWidth(), widgetPotentialFolder.getHeight());
                if (plugin == null) {
                    g2d.setColor(new Color(255, 255, 255, 180));
                } else {
                    g2d.setColor(ColorPalette.alpha(plugin.getThemeColor(), 180));
                }
                g2d.fill(rpotential);
                widgetFolder.setTargetFolder(widgetPotentialFolder);
            } else {
                this.setNorthMessage(widgetFolder.getId() + "/" + widgetPotentialFolder.getxIndex() + "/" + widgetPotentialFolder.getyIndex() + "/invalid");
                Rectangle2D.Double rpotential = new Rectangle2D.Double(widgetPotentialFolder.getX(), widgetPotentialFolder.getY(), widgetPotentialFolder.getWidth(), widgetPotentialFolder.getHeight());
                g2d.setColor(new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 150));
                g2d.fill(rpotential);
            }
        }
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart == ViewPart.Device) {
            if (v2d.getActiveProjection() != null) {
                List<AbstractPlugin> plugins = v2d.getActiveProjection().getPluginRegistry();
                for (AbstractPlugin plugin : plugins) {
                    List<Widget> widgets = plugin.getWidgets();
                    for (Widget widget : widgets) {
                        if (!widget.isLockWidget()) continue;
                        widget.paint(v2d, g2d);
                    }
                }
            }
            this.paintDragPhantomWidget(v2d, g2d, viewPart);
        }
        if (viewPart == ViewPart.North) {
            this.paintPushingMessage(g2d);
            this.paintNorthMessage(g2d);
        }
    }

    class MoveAnimator
    extends Thread {
        private WidgetFolder df;

        public MoveAnimator(WidgetFolder df) {
            this.df = df;
        }

        @Override
        public void run() {
            try {
                double folderCenterX = this.df.getX() + this.df.getWidth() / 2.0;
                double folderCenterY = this.df.getY() + this.df.getHeight() / 2.0;
                int curentMouseX = this.df.getCurrentDragX();
                int curentMouseY = this.df.getCurrentDragY();
                int stepCount = 20;
                double deltaX = ((double)curentMouseX - folderCenterX) / (double)stepCount;
                double deltaY = ((double)curentMouseY - folderCenterY) / (double)stepCount;
                double x = this.df.getX();
                double y = this.df.getY();
                for (int i = 0; i < stepCount; ++i) {
                    this.df.setX(x + (double)stepCount * deltaX);
                    this.df.setY(y + (double)stepCount * deltaY);
                    WidgetPlugin.this.getView().repaintDevice();
                    Thread.sleep(300L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    class MessageCleaner
    extends Thread {
        private int delay;

        public MessageCleaner(int delay) {
            this.delay = delay;
        }

        @Override
        public void run() {
            try {
                WidgetPlugin.this.getView().getViewPartComponent(ViewPart.North).repaint();
                Thread.sleep(this.delay);
                WidgetPlugin.this.northMessage = null;
                WidgetPlugin.this.getView().getViewPartComponent(ViewPart.North).repaint();
            }
            catch (InterruptedException e) {
                WidgetPlugin.this.northMessage = null;
                WidgetPlugin.this.getView().getViewPartComponent(ViewPart.North).repaint();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static enum PushingBehavior {
        VerySlow(40),
        Slow(30),
        Default(20),
        Fast(10),
        VeryFast(5);

        private int behavior;

        private PushingBehavior(int behavior) {
            this.behavior = behavior;
        }

        public int getBehavior() {
            return this.behavior;
        }
    }

    class PushingMessage
    extends Thread {
        private String message;
        private int startDelay = 0;
        private PushingBehavior behavior;
        private Color color;
        private Font font;
        private float alpha = 1.0f;
        private int countBaseEffect = 300;
        private int countCurentEffect = 0;
        private boolean lockAlpha = true;
        private boolean effect = true;

        public PushingMessage(String message, PushingBehavior behavior, Color color, Font font) {
            this.message = message;
            this.behavior = behavior;
            this.color = color;
            this.font = font;
        }

        public PushingMessage(String message, int startDelay, PushingBehavior behavior, Color color, Font font) {
            this.message = message;
            this.startDelay = startDelay;
            this.behavior = behavior;
            this.color = color;
            this.font = font;
        }

        public PushingMessage(String message, int startDelay, PushingBehavior behavior, Color color, Font font, boolean lockAlpha) {
            this.message = message;
            this.startDelay = startDelay;
            this.behavior = behavior;
            this.color = color;
            this.font = font;
            this.lockAlpha = lockAlpha;
        }

        @Override
        public void run() {
            try {
                WidgetPlugin.this.getView().getViewPartComponent(ViewPart.North).repaint();
                Thread.sleep(this.startDelay);
                WidgetPlugin.this.getView().getViewPartComponent(ViewPart.North).repaint();
                while (this.effect) {
                    if (this.alpha < 0.0f) {
                        this.effect = false;
                        continue;
                    }
                    this.alpha = this.lockAlpha ? (this.alpha -= 0.005f) : 1.0f;
                    ++this.countCurentEffect;
                    if (!(this.alpha >= 0.0f) || !(this.alpha <= 1.0f)) continue;
                    WidgetPlugin.this.getView().getViewPartComponent(ViewPart.North).repaint();
                    Thread.sleep(this.behavior.getBehavior());
                }
                WidgetPlugin.this.getView().getViewPartComponent(ViewPart.North).repaint();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.message = null;
                WidgetPlugin.this.getView().getViewPartComponent(ViewPart.North).repaint();
            }
        }
    }
}

