/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.view.background;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.view.View;
import org.jensoft.core.view.background.ViewBackgroundPainter;

public class ViewDefaultBackground
extends ViewBackgroundPainter {
    private int outlineRound = 20;
    private int paddingX = 2;
    private int paddingY = 2;
    private Shader shader;
    private Color outlineColor;
    private Stroke outlineStroke;

    public ViewDefaultBackground() {
    }

    public ViewDefaultBackground(Shader shader) {
        this.shader = shader;
    }

    public ViewDefaultBackground(Shader shader, Color outlineColor) {
        this.shader = shader;
        this.outlineColor = outlineColor;
    }

    public ViewDefaultBackground(Shader shader, Color outlineColor, Stroke outlineStroke) {
        this.shader = shader;
        this.outlineColor = outlineColor;
        this.outlineStroke = outlineStroke;
    }

    public ViewDefaultBackground(Shader shader, Color outlineColor, Stroke outlineStroke, int outlineRound) {
        this.shader = shader;
        this.outlineColor = outlineColor;
        this.outlineStroke = outlineStroke;
        this.outlineRound = outlineRound;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    public int getOutlineRound() {
        return this.outlineRound;
    }

    public void setOutlineRound(int outlineRound) {
        this.outlineRound = outlineRound;
    }

    public int getPaddingX() {
        return this.paddingX;
    }

    public void setPaddingX(int paddingX) {
        this.paddingX = paddingX;
    }

    public int getPaddingY() {
        return this.paddingY;
    }

    public void setPaddingY(int paddingY) {
        this.paddingY = paddingY;
    }

    public Shader getShader() {
        return this.shader;
    }

    public void setShader(Shader shader) {
        this.shader = shader;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    @Override
    public final void paintViewBackground(View view, int viewWidth, int viewHeight, Graphics2D g2d) {
        int width = view.getWidth();
        int height = view.getHeight();
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        qualityHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        qualityHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHints(qualityHints);
        RoundRectangle2D.Double roundBackground = new RoundRectangle2D.Double(this.paddingX, this.paddingY, width - 1 - 2 * this.paddingX, height - 1 - 2 * this.paddingY, this.outlineRound, this.outlineRound);
        if (this.shader != null) {
            LinearGradientPaint lgp = new LinearGradientPaint(new Point2D.Double(width / 2, 0.0), new Point2D.Double(width / 2, height), this.shader.getFractions(), this.shader.getColors());
            g2d.setPaint(lgp);
            g2d.fill(roundBackground);
        }
        if (this.outlineColor != null) {
            g2d.setColor(this.outlineColor);
            if (this.outlineStroke != null) {
                g2d.setStroke(this.outlineStroke);
            }
            g2d.draw(roundBackground);
        }
    }
}

