/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.widget;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.widget.WidgetFolder;

public abstract class Widget<P extends AbstractPlugin>
implements WidgetFolder.OnPostWidgetListener {
    private String name;
    private String id;
    private P host;
    private WidgetFolder widgetFolder;
    private double width;
    private double height;
    private int xIndex;
    private int yIndex;
    private boolean lockWidget = true;
    private List<Shape> sensibleShapes = new ArrayList<Shape>();
    private boolean noMoveOperation = false;
    private boolean isMovable = true;
    private boolean orphanLock = false;

    public Widget() {
        this("widget", 0.0, 0.0, 0, 0);
    }

    public Widget(String id) {
        this(id, 0.0, 0.0, 0, 0);
    }

    public Widget(String id, double width, double height, int xIndex, int yIndex) {
        this.id = id;
        this.width = width;
        this.height = height;
        this.xIndex = xIndex;
        this.yIndex = yIndex;
    }

    public void onRegister() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isNoMoveOperation() {
        return this.noMoveOperation;
    }

    public void setNoMoveOperation(boolean noMoveOperation) {
        this.noMoveOperation = noMoveOperation;
    }

    public boolean isSensible(int x, int y) {
        for (Shape sensibleShape : this.sensibleShapes) {
            if (!sensibleShape.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public List<Shape> getSensibleShapes() {
        return this.sensibleShapes;
    }

    public void clearSensibleShape() {
        this.sensibleShapes.clear();
    }

    public void setSensibleShapes(List<Shape> sensibleShapes) {
        this.sensibleShapes = sensibleShapes;
    }

    public void addSensibleShape(Shape sensibleShape) {
        this.sensibleShapes.add(sensibleShape);
    }

    public void removeSensibleShape(Shape sensibleShape) {
        this.sensibleShapes.remove(sensibleShape);
    }

    public void interceptMove(int x, int y) {
        this.checkMoveOperation(x, y);
    }

    public void interceptPress(int x, int y) {
    }

    public void interceptDrag(int x, int y) {
    }

    public void interceptReleased(int x, int y) {
        this.setNoMoveOperation(false);
    }

    public void interceptWheel(int rotation) {
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public int getxIndex() {
        return this.xIndex;
    }

    public void setxIndex(int xIndex) {
        this.xIndex = xIndex;
    }

    public int getyIndex() {
        return this.yIndex;
    }

    public void setyIndex(int yIndex) {
        this.yIndex = yIndex;
    }

    public P getHost() {
        return this.host;
    }

    public void setHost(P host) {
        this.host = host;
    }

    public WidgetFolder getWidgetFolder() {
        return this.widgetFolder;
    }

    public void setWidgetFolder(WidgetFolder widgetFolder) {
        this.widgetFolder = widgetFolder;
    }

    public Color getThemeColor() {
        return ((AbstractPlugin)this.getHost()).getThemeColor();
    }

    @Override
    public void onPostWidget() {
        this.xIndex = this.widgetFolder.getTargetFolder().getxIndex();
        this.yIndex = this.widgetFolder.getTargetFolder().getyIndex();
    }

    protected abstract void paintWidget(View var1, Graphics2D var2);

    private void layoutFolder(View view) {
        if (this.getWidgetFolder() == null) {
            this.setWidgetFolder(view.newWidgetFolderIntance(this.getId(), this.getWidth(), this.getHeight(), this.getxIndex(), this.getyIndex()));
            this.getWidgetFolder().setOnPostListener(this);
        } else {
            WidgetFolder vdf = view.newWidgetFolderIntance(this.getId(), this.getWidth(), this.getHeight(), this.getxIndex(), this.getyIndex());
            this.getWidgetFolder().updateFrame(vdf.getX(), vdf.getY(), vdf.getWidth(), vdf.getHeight());
        }
    }

    public void repaintWidget() {
        if (this.getHost() != null && ((AbstractPlugin)this.getHost()).getProjection() != null && ((AbstractPlugin)this.getHost()).getProjection().getView() != null && this.getWidgetFolder() != null && this.getWidgetFolder().getBounds() != null) {
            ((AbstractPlugin)this.getHost()).getProjection().getView().repaintDevice(this.getWidgetFolder().getBounds());
        }
    }

    public final void paint(View view, Graphics2D g2d) {
        if (!this.isLockWidget()) {
            return;
        }
        if (!((AbstractPlugin)this.getHost()).isLockSelected() && this.isOrphanLock()) {
            return;
        }
        this.layoutFolder(view);
        this.paintWidget(view, g2d);
    }

    public boolean isLockWidget() {
        return this.lockWidget;
    }

    public void setLockWidget(boolean lockWidget) {
        this.lockWidget = lockWidget;
    }

    public void lockWidget() {
        this.lockWidget = true;
    }

    public void unlockWidget() {
        this.lockWidget = false;
    }

    public void checkMoveOperation(int x, int y) {
        if (!((AbstractPlugin)this.getHost()).isLockSelected() && this.isOrphanLock()) {
            return;
        }
        if (!this.isMovable) {
            this.setNoMoveOperation(true);
            return;
        }
        if (this.isSensible(x, y)) {
            this.setNoMoveOperation(true);
        } else {
            this.setNoMoveOperation(false);
        }
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
    }

    public boolean isOrphanLock() {
        return this.orphanLock;
    }

    public void setOrphanLock(boolean orphanLock) {
        this.orphanLock = orphanLock;
    }

    public void isCompatible() {
    }

    public abstract boolean isCompatiblePlugin();
}

