/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.widget.bar;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jensoft.core.widget.AbstractWidgetGeometry;

public abstract class AbstractBarGeometry
extends AbstractWidgetGeometry {
    private Rectangle2D bound2D;
    private RoundRectangle2D outlineShape;
    private Rectangle2D rect1;
    private Rectangle2D rect2;
    private Shape button1;
    private Shape button2;
    private boolean rollover1 = false;
    private boolean rollover2 = false;
    private boolean solveRequest = true;
    private int margin = 4;
    private double radius;
    private int inset = 3;
    private BarWidgetOrientation barWidgetOrientation;

    public AbstractBarGeometry() {
    }

    public AbstractBarGeometry(BarWidgetOrientation barWidgetOrientation) {
        this.barWidgetOrientation = barWidgetOrientation;
    }

    public boolean isSolveRequest() {
        return this.solveRequest;
    }

    public void setSolveRequest(boolean solveRequest) {
        this.solveRequest = solveRequest;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
        this.solveRequest = true;
    }

    public int getInset() {
        return this.inset;
    }

    public void setInset(int inset) {
        this.inset = inset;
        this.solveRequest = true;
    }

    public BarWidgetOrientation getBarWidgetOrientation() {
        return this.barWidgetOrientation;
    }

    public void setBarWidgetOrientation(BarWidgetOrientation barWidgetOrientation) {
        this.barWidgetOrientation = barWidgetOrientation;
        this.solveRequest = true;
    }

    private final void solveBarGeometry() {
        if (this.barWidgetOrientation == BarWidgetOrientation.Horizontal) {
            this.outlineShape = new RoundRectangle2D.Double(this.bound2D.getX(), this.bound2D.getY(), this.bound2D.getWidth(), this.bound2D.getHeight(), this.bound2D.getHeight(), this.bound2D.getHeight());
            this.rect1 = new Rectangle2D.Double(this.bound2D.getX() + (double)this.margin + (double)this.inset, this.bound2D.getY() + (double)this.inset, this.radius - (double)(2 * this.inset), this.radius - (double)(2 * this.inset));
            this.rect2 = new Rectangle2D.Double(this.bound2D.getX() + (double)this.inset + this.bound2D.getWidth() - (double)this.margin - this.radius, this.bound2D.getY() + (double)this.inset, this.radius - (double)(2 * this.inset), this.radius - (double)(2 * this.inset));
        } else {
            this.outlineShape = new RoundRectangle2D.Double(this.bound2D.getX(), this.bound2D.getY(), this.bound2D.getWidth(), this.bound2D.getHeight(), this.bound2D.getWidth(), this.bound2D.getWidth());
            this.rect1 = new Rectangle2D.Double(this.bound2D.getX() + (double)this.inset, this.bound2D.getY() + (double)this.margin + (double)this.inset, this.radius - (double)(2 * this.inset), this.radius - (double)(2 * this.inset));
            this.rect2 = new Rectangle2D.Double(this.bound2D.getX() + (double)this.inset, this.bound2D.getY() + this.bound2D.getHeight() - this.radius - (double)this.margin + (double)this.inset, this.radius - (double)(2 * this.inset), this.radius - (double)(2 * this.inset));
        }
        this.clearSensibleShape();
        this.addSensibleShape(this.rect1);
        this.addSensibleShape(this.rect2);
    }

    abstract void solveButton1Geometry(Rectangle2D var1);

    abstract void solveButton2Geometry(Rectangle2D var1);

    @Override
    public final void solveGeometry(Rectangle2D bound2D) {
        if (this.solveRequest) {
            this.bound2D = bound2D;
            if (this.getBarWidgetOrientation() == BarWidgetOrientation.Horizontal) {
                this.radius = bound2D.getHeight();
            } else if (this.getBarWidgetOrientation() == BarWidgetOrientation.Vertical) {
                this.radius = bound2D.getWidth();
            }
            if (this.barWidgetOrientation == null) {
                return;
            }
            this.solveBarGeometry();
            this.solveButton1Geometry(this.rect1);
            this.solveButton2Geometry(this.rect2);
            this.solveRequest = false;
        }
    }

    public Rectangle2D getBound2D() {
        return this.bound2D;
    }

    public void setBound2D(Rectangle2D bound2d) {
        Rectangle2D oldBound = this.bound2D;
        this.bound2D = bound2d;
        if (!oldBound.equals(bound2d)) {
            this.solveRequest = true;
        }
    }

    public RoundRectangle2D getOutlineShape() {
        return this.outlineShape;
    }

    public void setOutlineShape(RoundRectangle2D outlineShape) {
        this.outlineShape = outlineShape;
    }

    public Rectangle2D getRect1() {
        return this.rect1;
    }

    public void setRect1(Rectangle2D rect1) {
        this.rect1 = rect1;
    }

    public Rectangle2D getRect2() {
        return this.rect2;
    }

    public void setRect2(Rectangle2D rect2) {
        this.rect2 = rect2;
    }

    public Shape getButton1() {
        return this.button1;
    }

    public void setButton1(Shape button1) {
        this.button1 = button1;
    }

    public Shape getButton2() {
        return this.button2;
    }

    public void setButton2(Shape button2) {
        this.button2 = button2;
    }

    public boolean isRollover1() {
        return this.rollover1;
    }

    public void setRollover1(boolean rollover1) {
        this.rollover1 = rollover1;
    }

    public boolean isRollover2() {
        return this.rollover2;
    }

    public void setRollover2(boolean rollover2) {
        this.rollover2 = rollover2;
    }

    public static enum BarWidgetOrientation {
        Horizontal,
        Vertical;

    }
}

