/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.widget.pad;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.widget.Widget;
import org.jensoft.core.widget.WidgetFolder;
import org.jensoft.core.widget.pad.AbstractPadGeometry;

public abstract class AbstractPadWidget<P extends AbstractPlugin>
extends Widget<P> {
    private Color fillBaseColor;
    private Color fillControlColor;
    private Color drawBaseColor;
    private Color drawControlColor;
    private Color drawBaseStroke;
    private Color drawControlStroke;
    private Color fillNorthColor;
    private Color fillNorthRolloverColor;
    private Stroke drawNorthStroke;
    private Color drawNorthColor;
    private Color drawNorthRolloverColor;
    private Color fillSouthColor;
    private Color fillSouthRolloverColor;
    private Stroke drawSouthStroke;
    private Color drawSouthColor;
    private Color drawSouthRolloverColor;
    private Color fillWestColor;
    private Color fillWestRolloverColor;
    private Stroke drawWestStroke;
    private Color drawWestColor;
    private Color drawWestRolloverColor;
    private Color fillEastColor;
    private Color fillEastRolloverColor;
    private Stroke drawEastStroke;
    private Color drawEastColor;
    private Color drawEastRolloverColor;
    private Stroke basicStroke = new BasicStroke();
    private AbstractPadGeometry padGeometry;

    public AbstractPadWidget(String id, double padSquare, int xIndex, int yIndex, AbstractPadGeometry geometry) {
        super(id, padSquare, padSquare, xIndex, yIndex);
        this.padGeometry = geometry;
    }

    @Override
    public void interceptMove(int x, int y) {
        super.interceptMove(x, y);
        if (this.getWidgetFolder() == null) {
            return;
        }
        if (!this.getWidgetFolder().getBounds2D().contains(x, y)) {
            this.padGeometry.setNorthRollover(false);
            this.padGeometry.setSouthRollover(false);
            this.padGeometry.setWestRollover(false);
            this.padGeometry.setEastRollover(false);
            this.onNorthButtonRolloverOff();
            this.onSouthButtonRolloverOff();
            this.onWestButtonRolloverOff();
            this.onEastButtonRolloverOff();
            return;
        }
        this.checkMoveOperation(x, y);
        this.trackRollover(x, y);
    }

    private void trackRollover(int x, int y) {
        if (this.padGeometry.getRectNorth() != null && this.padGeometry.getRectNorth().contains(x, y)) {
            if (!this.padGeometry.isNorthRollover()) {
                this.padGeometry.setNorthRollover(true);
                this.onNorthButtonRolloverOn();
            }
        } else if (this.padGeometry.isNorthRollover()) {
            this.padGeometry.setNorthRollover(false);
            this.onNorthButtonRolloverOff();
        }
        if (this.padGeometry.getRectSouth() != null && this.padGeometry.getRectSouth().contains(x, y)) {
            if (!this.padGeometry.isSouthRollover()) {
                this.padGeometry.setSouthRollover(true);
                this.onSouthButtonRolloverOn();
            }
        } else if (this.padGeometry.isSouthRollover()) {
            this.padGeometry.setSouthRollover(false);
            this.onSouthButtonRolloverOff();
        }
        if (this.padGeometry.getRectWest() != null && this.padGeometry.getRectWest().contains(x, y)) {
            if (!this.padGeometry.isWestRollover()) {
                this.padGeometry.setWestRollover(true);
                this.onWestButtonRolloverOn();
            }
        } else if (this.padGeometry.isWestRollover()) {
            this.padGeometry.setWestRollover(false);
            this.onWestButtonRolloverOff();
        }
        if (this.padGeometry.getRectEast() != null && this.padGeometry.getRectEast().contains(x, y)) {
            if (!this.padGeometry.isEastRollover()) {
                this.padGeometry.setEastRollover(true);
                this.onEastButtonRolloverOn();
            }
        } else if (this.padGeometry.isEastRollover()) {
            this.padGeometry.setEastRollover(false);
            this.onEastButtonRolloverOff();
        }
    }

    public void onNorthButtonRolloverOn() {
        this.repaintNorthButton();
    }

    public void onNorthButtonRolloverOff() {
        this.repaintNorthButton();
    }

    public void onSouthButtonRolloverOn() {
        this.repaintSouthButton();
    }

    public void onSouthButtonRolloverOff() {
        this.repaintSouthButton();
    }

    public void onWestButtonRolloverOn() {
        this.repaintWestButton();
    }

    public void onWestButtonRolloverOff() {
        this.repaintWestButton();
    }

    public void onEastButtonRolloverOn() {
        this.repaintEastButton();
    }

    public void onEastButtonRolloverOff() {
        this.repaintEastButton();
    }

    public void onNorthButtonPress() {
        this.repaintNorthButton();
    }

    public void onSouthButtonPress() {
        this.repaintSouthButton();
    }

    public void onWestButtonPress() {
        this.repaintWestButton();
    }

    public void onEastButtonPress() {
        this.repaintEastButton();
    }

    public void onNorthButtonReleased() {
        this.repaintNorthButton();
    }

    public void onSouthButtonReleased() {
        this.repaintSouthButton();
    }

    public void onWestButtonReleased() {
        this.repaintWestButton();
    }

    public void onEastButtonReleased() {
        this.repaintEastButton();
    }

    public void repaintNorthButton() {
        if (this.padGeometry == null || this.padGeometry.getRectNorth() == null) {
            return;
        }
        ((AbstractPlugin)this.getHost()).getProjection().getView().repaintDevice(this.padGeometry.getRectNorth().getBounds());
    }

    public void repaintSouthButton() {
        if (this.padGeometry == null || this.padGeometry.getRectSouth() == null) {
            return;
        }
        ((AbstractPlugin)this.getHost()).getProjection().getView().repaintDevice(this.padGeometry.getRectSouth().getBounds());
    }

    public void repaintWestButton() {
        if (this.padGeometry == null || this.padGeometry.getRectWest() == null) {
            return;
        }
        ((AbstractPlugin)this.getHost()).getProjection().getView().repaintDevice(this.padGeometry.getRectWest().getBounds());
    }

    public void repaintEastButton() {
        if (this.padGeometry == null || this.padGeometry.getRectEast() == null) {
            return;
        }
        ((AbstractPlugin)this.getHost()).getProjection().getView().repaintDevice(this.padGeometry.getRectEast().getBounds());
    }

    @Override
    public void interceptPress(int x, int y) {
        super.interceptPress(x, y);
        if (this.padGeometry.getRectNorth() != null && this.padGeometry.getRectNorth().contains(x, y)) {
            this.onNorthButtonPress();
        }
        if (this.padGeometry.getRectSouth() != null && this.padGeometry.getRectSouth().contains(x, y)) {
            this.onSouthButtonPress();
        }
        if (this.padGeometry.getRectWest() != null && this.padGeometry.getRectWest().contains(x, y)) {
            this.onWestButtonPress();
        }
        if (this.padGeometry.getRectEast() != null && this.padGeometry.getRectEast().contains(x, y)) {
            this.onEastButtonPress();
        }
    }

    public Color getFillBaseColor() {
        return this.fillBaseColor;
    }

    public void setFillBaseColor(Color fillBaseColor) {
        this.fillBaseColor = fillBaseColor;
    }

    public Color getFillControlColor() {
        return this.fillControlColor;
    }

    public void setFillControlColor(Color fillControlColor) {
        this.fillControlColor = fillControlColor;
    }

    public Color getDrawBaseColor() {
        return this.drawBaseColor;
    }

    public void setDrawBaseColor(Color drawBaseColor) {
        this.drawBaseColor = drawBaseColor;
    }

    public Color getDrawControlColor() {
        return this.drawControlColor;
    }

    public void setDrawControlColor(Color drawControlColor) {
        this.drawControlColor = drawControlColor;
    }

    public Color getDrawBaseStroke() {
        return this.drawBaseStroke;
    }

    public void setDrawBaseStroke(Color drawBaseStroke) {
        this.drawBaseStroke = drawBaseStroke;
    }

    public Color getDrawControlStroke() {
        return this.drawControlStroke;
    }

    public void setDrawControlStroke(Color drawControlStroke) {
        this.drawControlStroke = drawControlStroke;
    }

    public void setFillButtonColor(Color fillButtonColor) {
        this.fillNorthColor = fillButtonColor;
        this.fillSouthColor = fillButtonColor;
        this.fillWestColor = fillButtonColor;
        this.fillEastColor = fillButtonColor;
    }

    public void setFillButtonRolloverColor(Color fillRolloverButtonColor) {
        this.fillNorthRolloverColor = fillRolloverButtonColor;
        this.fillSouthRolloverColor = fillRolloverButtonColor;
        this.fillWestRolloverColor = fillRolloverButtonColor;
        this.fillEastRolloverColor = fillRolloverButtonColor;
    }

    public void setDrawButtonStroke(Stroke drawButtonStroke) {
        this.drawNorthStroke = drawButtonStroke;
        this.drawSouthStroke = drawButtonStroke;
        this.drawWestStroke = drawButtonStroke;
        this.drawEastStroke = drawButtonStroke;
    }

    public void setDrawButtonColor(Color drawButtonColor) {
        this.drawNorthColor = drawButtonColor;
        this.drawSouthColor = drawButtonColor;
        this.drawWestColor = drawButtonColor;
        this.drawEastColor = drawButtonColor;
    }

    public void setDrawButtonRolloverColor(Color drawButtonRolloverColor) {
        this.drawNorthRolloverColor = drawButtonRolloverColor;
        this.drawSouthRolloverColor = drawButtonRolloverColor;
        this.drawWestRolloverColor = drawButtonRolloverColor;
        this.drawEastRolloverColor = drawButtonRolloverColor;
    }

    public Color getFillNorthColor() {
        return this.fillNorthColor;
    }

    public void setFillNorthColor(Color fillNorthColor) {
        this.fillNorthColor = fillNorthColor;
    }

    public Color getFillNorthRolloverColor() {
        return this.fillNorthRolloverColor;
    }

    public void setFillNorthRolloverColor(Color fillNorthRolloverColor) {
        this.fillNorthRolloverColor = fillNorthRolloverColor;
    }

    public Stroke getDrawNorthStroke() {
        return this.drawNorthStroke;
    }

    public void setDrawNorthStroke(Stroke drawNorthStroke) {
        this.drawNorthStroke = drawNorthStroke;
    }

    public Color getDrawNorthColor() {
        return this.drawNorthColor;
    }

    public void setDrawNorthColor(Color drawNorthColor) {
        this.drawNorthColor = drawNorthColor;
    }

    public Color getDrawNorthRolloverColor() {
        return this.drawNorthRolloverColor;
    }

    public void setDrawNorthRolloverColor(Color drawNorthRolloverColor) {
        this.drawNorthRolloverColor = drawNorthRolloverColor;
    }

    public Color getFillSouthColor() {
        return this.fillSouthColor;
    }

    public void setFillSouthColor(Color fillSouthColor) {
        this.fillSouthColor = fillSouthColor;
    }

    public Color getFillSouthRolloverColor() {
        return this.fillSouthRolloverColor;
    }

    public void setFillSouthRolloverColor(Color fillSouthRolloverColor) {
        this.fillSouthRolloverColor = fillSouthRolloverColor;
    }

    public Stroke getDrawSouthStroke() {
        return this.drawSouthStroke;
    }

    public void setDrawSouthStroke(Stroke drawSouthStroke) {
        this.drawSouthStroke = drawSouthStroke;
    }

    public Color getDrawSouthColor() {
        return this.drawSouthColor;
    }

    public void setDrawSouthColor(Color drawSouthColor) {
        this.drawSouthColor = drawSouthColor;
    }

    public Color getDrawSouthRolloverColor() {
        return this.drawSouthRolloverColor;
    }

    public void setDrawSouthRolloverColor(Color drawSouthRolloverColor) {
        this.drawSouthRolloverColor = drawSouthRolloverColor;
    }

    public Color getFillWestColor() {
        return this.fillWestColor;
    }

    public void setFillWestColor(Color fillWestColor) {
        this.fillWestColor = fillWestColor;
    }

    public Color getFillWestRolloverColor() {
        return this.fillWestRolloverColor;
    }

    public void setFillWestRolloverColor(Color fillWestRolloverColor) {
        this.fillWestRolloverColor = fillWestRolloverColor;
    }

    public Stroke getDrawWestStroke() {
        return this.drawWestStroke;
    }

    public void setDrawWestStroke(Stroke drawWestStroke) {
        this.drawWestStroke = drawWestStroke;
    }

    public Color getDrawWestColor() {
        return this.drawWestColor;
    }

    public void setDrawWestColor(Color drawWestColor) {
        this.drawWestColor = drawWestColor;
    }

    public Color getDrawWestRolloverColor() {
        return this.drawWestRolloverColor;
    }

    public void setDrawWestRolloverColor(Color drawWestRolloverColor) {
        this.drawWestRolloverColor = drawWestRolloverColor;
    }

    public Color getFillEastColor() {
        return this.fillEastColor;
    }

    public void setFillEastColor(Color fillEastColor) {
        this.fillEastColor = fillEastColor;
    }

    public Color getFillEastRolloverColor() {
        return this.fillEastRolloverColor;
    }

    public void setFillEastRolloverColor(Color fillEastRolloverColor) {
        this.fillEastRolloverColor = fillEastRolloverColor;
    }

    public Stroke getDrawEastStroke() {
        return this.drawEastStroke;
    }

    public void setDrawEastStroke(Stroke drawEastStroke) {
        this.drawEastStroke = drawEastStroke;
    }

    public Color getDrawEastColor() {
        return this.drawEastColor;
    }

    public void setDrawEastColor(Color drawEastColor) {
        this.drawEastColor = drawEastColor;
    }

    public Color getDrawEastRolloverColor() {
        return this.drawEastRolloverColor;
    }

    public void setDrawEastRolloverColor(Color drawEastRolloverColor) {
        this.drawEastRolloverColor = drawEastRolloverColor;
    }

    public AbstractPadGeometry getPadGeometry() {
        return this.padGeometry;
    }

    public void setPadGeometry(AbstractPadGeometry padGeometry) {
        this.padGeometry = padGeometry;
    }

    @Override
    public void interceptDrag(int x, int y) {
        super.interceptDrag(x, y);
    }

    @Override
    public void interceptReleased(int x, int y) {
        super.interceptReleased(x, y);
        this.onNorthButtonReleased();
        this.onSouthButtonReleased();
        this.onWestButtonReleased();
        this.onEastButtonReleased();
    }

    @Override
    protected void paintWidget(View v2d, Graphics2D g2d) {
        if (!((AbstractPlugin)this.getHost()).isLockSelected()) {
            return;
        }
        if (this.getWidgetFolder() == null || this.padGeometry == null) {
            return;
        }
        WidgetFolder currentFolder = this.getWidgetFolder();
        Rectangle2D boundFolder = currentFolder.getBounds2D();
        this.padGeometry.setSolveRequest(true);
        this.padGeometry.solveGeometry(boundFolder);
        this.setSensibleShapes(this.padGeometry.getSensibleShapes());
        if (this.fillBaseColor != null) {
            g2d.setColor(this.fillBaseColor);
            g2d.fill(this.padGeometry.getBaseShape());
        }
        if (this.drawBaseColor != null) {
            g2d.setColor(this.drawBaseColor);
            g2d.setStroke(this.basicStroke);
            g2d.draw(this.padGeometry.getBaseShape());
        }
        if (this.fillControlColor != null) {
            g2d.setColor(this.fillControlColor);
            g2d.fill(this.padGeometry.getControlShape());
        }
        if (this.drawControlColor != null) {
            g2d.setColor(this.drawControlColor);
            g2d.setStroke(this.basicStroke);
            g2d.draw(this.padGeometry.getControlShape());
        }
        if (!this.padGeometry.isNorthRollover()) {
            if (this.fillNorthColor != null) {
                g2d.setColor(this.fillNorthColor);
                g2d.fill(this.padGeometry.getNorthButton());
            }
            if (this.drawNorthColor != null) {
                g2d.setColor(this.drawNorthColor);
                if (this.drawNorthStroke != null) {
                    g2d.setStroke(this.drawNorthStroke);
                }
                g2d.draw(this.padGeometry.getNorthButton());
                g2d.setStroke(this.basicStroke);
            }
        } else {
            if (this.fillNorthRolloverColor != null) {
                g2d.setColor(this.fillNorthRolloverColor);
                g2d.fill(this.padGeometry.getNorthButton());
            }
            if (this.drawNorthRolloverColor != null) {
                g2d.setColor(this.drawNorthRolloverColor);
                if (this.drawNorthStroke != null) {
                    g2d.setStroke(this.drawNorthStroke);
                }
                g2d.draw(this.padGeometry.getNorthButton());
                g2d.setStroke(this.basicStroke);
            }
        }
        if (!this.padGeometry.isSouthRollover()) {
            if (this.fillSouthColor != null) {
                g2d.setColor(this.fillSouthColor);
                g2d.fill(this.padGeometry.getSouthButton());
            }
            if (this.drawSouthColor != null) {
                g2d.setColor(this.drawSouthColor);
                if (this.drawSouthStroke != null) {
                    g2d.setStroke(this.drawSouthStroke);
                }
                g2d.draw(this.padGeometry.getSouthButton());
                g2d.setStroke(this.basicStroke);
            }
        } else {
            if (this.fillSouthRolloverColor != null) {
                g2d.setColor(this.fillSouthRolloverColor);
                g2d.fill(this.padGeometry.getSouthButton());
            }
            if (this.drawSouthRolloverColor != null) {
                g2d.setColor(this.drawSouthRolloverColor);
                if (this.drawSouthStroke != null) {
                    g2d.setStroke(this.drawSouthStroke);
                }
                g2d.draw(this.padGeometry.getSouthButton());
                g2d.setStroke(this.basicStroke);
            }
        }
        if (!this.padGeometry.isWestRollover()) {
            if (this.fillWestColor != null) {
                g2d.setColor(this.fillWestColor);
                g2d.fill(this.padGeometry.getWestButton());
            }
            if (this.drawWestColor != null) {
                g2d.setColor(this.drawWestColor);
                if (this.drawWestStroke != null) {
                    g2d.setStroke(this.drawWestStroke);
                }
                g2d.draw(this.padGeometry.getWestButton());
                g2d.setStroke(this.basicStroke);
            }
        } else {
            if (this.fillWestRolloverColor != null) {
                g2d.setColor(this.fillWestRolloverColor);
                g2d.fill(this.padGeometry.getWestButton());
            }
            if (this.drawWestRolloverColor != null) {
                g2d.setColor(this.drawWestRolloverColor);
                if (this.drawWestStroke != null) {
                    g2d.setStroke(this.drawWestStroke);
                }
                g2d.draw(this.padGeometry.getWestButton());
                g2d.setStroke(this.basicStroke);
            }
        }
        if (!this.padGeometry.isEastRollover()) {
            if (this.fillEastColor != null) {
                g2d.setColor(this.fillEastColor);
                g2d.fill(this.padGeometry.getEastButton());
            }
            if (this.drawEastColor != null) {
                g2d.setColor(this.drawEastColor);
                if (this.drawEastStroke != null) {
                    g2d.setStroke(this.drawEastStroke);
                }
                g2d.draw(this.padGeometry.getEastButton());
                g2d.setStroke(this.basicStroke);
            }
        } else {
            if (this.fillEastRolloverColor != null) {
                g2d.setColor(this.fillEastRolloverColor);
                g2d.fill(this.padGeometry.getEastButton());
            }
            if (this.drawEastRolloverColor != null) {
                g2d.setColor(this.drawEastRolloverColor);
                if (this.drawEastStroke != null) {
                    g2d.setStroke(this.drawEastStroke);
                }
                g2d.draw(this.padGeometry.getEastButton());
                g2d.setStroke(this.basicStroke);
            }
        }
    }

    private void paintDebug(View v2d, Graphics2D g2d) {
        if (((AbstractPlugin)this.getHost()).isLockSelected()) {
            if (this.getWidgetFolder() == null || this.padGeometry == null) {
                return;
            }
            WidgetFolder currentFolder = this.getWidgetFolder();
            Rectangle2D boundFolder = currentFolder.getBounds2D();
            this.padGeometry.setSolveRequest(true);
            this.padGeometry.solveGeometry(boundFolder);
            this.setSensibleShapes(this.padGeometry.getSensibleShapes());
            g2d.setColor(Color.RED);
            g2d.draw(this.padGeometry.getBaseShape());
            g2d.draw(this.padGeometry.getControlShape());
            g2d.draw(this.padGeometry.getNorthButton());
            g2d.draw(this.padGeometry.getSouthButton());
            g2d.draw(this.padGeometry.getWestButton());
            g2d.draw(this.padGeometry.getEastButton());
        }
    }
}

