/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.x2d.X2DErrorHandler;
import org.jensoft.core.x2d.X2DException;
import org.jensoft.core.x2d.binding.AbstractX2DPluginDeflater;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.X2DViewDeflater;
import org.jensoft.core.x2d.binding.X2DViewInflater;
import org.jensoft.core.x2d.binding.donut2d.Donut2DDeflater;
import org.jensoft.core.x2d.binding.donut2d.Donut2DInflater;
import org.jensoft.core.x2d.binding.donut3d.Donut3DDeflater;
import org.jensoft.core.x2d.binding.donut3d.Donut3DInflater;
import org.jensoft.core.x2d.binding.function.AreaFunctionInflater;
import org.jensoft.core.x2d.binding.function.CurveFunctionInflater;
import org.jensoft.core.x2d.binding.function.ScatterFunctionInflater;
import org.jensoft.core.x2d.binding.grid.GridInflater;
import org.jensoft.core.x2d.binding.legend.LegendInflater;
import org.jensoft.core.x2d.binding.metrics.AxisMetricsInflater;
import org.jensoft.core.x2d.binding.outline.OutlineDeflater;
import org.jensoft.core.x2d.binding.outline.OutlineInflater;
import org.jensoft.core.x2d.binding.pie.PieDeflater;
import org.jensoft.core.x2d.binding.pie.PieInflater;
import org.jensoft.core.x2d.binding.translate.TranslateInflater;
import org.jensoft.core.x2d.binding.zoom.ZoomBoxInflater;
import org.jensoft.core.x2d.binding.zoom.ZoomObjectifInflater;
import org.jensoft.core.x2d.binding.zoom.ZoomWheelInflater;
import org.jensoft.core.x2d.lang.X2DSchema;
import org.jensoft.core.x2d.lang.X2DSchemaErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class X2D {
    private List<X2DErrorHandler> errorHandlers;
    private Document x2dDocument;
    private X2DViewInflater x2dInflater;
    private X2DViewDeflater x2dDeflater;
    private View view;
    private List<AbstractX2DPluginInflater<?>> coreInflaters = new ArrayList();
    private List<AbstractX2DPluginDeflater<? extends AbstractPlugin>> coreDeflaters = new ArrayList<AbstractX2DPluginDeflater<? extends AbstractPlugin>>();
    private List<AbstractX2DPluginInflater<? extends AbstractPlugin>> inflaters = new ArrayList<AbstractX2DPluginInflater<? extends AbstractPlugin>>();
    private List<AbstractX2DPluginDeflater<? extends AbstractPlugin>> deflaters = new ArrayList<AbstractX2DPluginDeflater<? extends AbstractPlugin>>();
    private boolean lookupCoreInflaters = true;
    private boolean lookupCoreDeflaters = true;

    public X2D() {
        this.initHandlers();
        this.initCoreInflaters();
        this.initCoreDeflaters();
    }

    private void initHandlers() {
        this.errorHandlers = new ArrayList<X2DErrorHandler>();
    }

    private void initCoreInflaters() {
        this.coreInflaters.add(new OutlineInflater());
        this.coreInflaters.add(new LegendInflater());
        this.coreInflaters.add(new Donut3DInflater());
        this.coreInflaters.add(new Donut2DInflater());
        this.coreInflaters.add(new PieInflater());
        this.coreInflaters.add(new AxisMetricsInflater.FreeMetricsInflater());
        this.coreInflaters.add(new AxisMetricsInflater.FlowMetricsInflater());
        this.coreInflaters.add(new AxisMetricsInflater.StaticMetricsInflater());
        this.coreInflaters.add(new AxisMetricsInflater.ModeledMetricsInflater());
        this.coreInflaters.add(new AxisMetricsInflater.TimeMetricsInflater());
        this.coreInflaters.add(new GridInflater.FreeGridInflater());
        this.coreInflaters.add(new GridInflater.FlowGridInflater());
        this.coreInflaters.add(new GridInflater.StaticGridInflater());
        this.coreInflaters.add(new GridInflater.ModeledGridInflater());
        this.coreInflaters.add(new GridInflater.MultiplierGridInflater());
        this.coreInflaters.add(new CurveFunctionInflater());
        this.coreInflaters.add(new AreaFunctionInflater());
        this.coreInflaters.add(new ScatterFunctionInflater());
        this.coreInflaters.add(new ZoomWheelInflater());
        this.coreInflaters.add(new ZoomBoxInflater());
        this.coreInflaters.add(new ZoomObjectifInflater());
        this.coreInflaters.add(new TranslateInflater());
    }

    private void initCoreDeflaters() {
        this.coreDeflaters.add(new OutlineDeflater());
        this.coreDeflaters.add(new PieDeflater());
        this.coreDeflaters.add(new Donut2DDeflater());
        this.coreDeflaters.add(new Donut3DDeflater());
    }

    public boolean isLookupCoreInflaters() {
        return this.lookupCoreInflaters;
    }

    public void setLookupCoreInflaters(boolean lookupCoreInflaters) {
        this.lookupCoreInflaters = lookupCoreInflaters;
    }

    public boolean isLookupCoreDeflaters() {
        return this.lookupCoreDeflaters;
    }

    public void setLookupCoreDeflaters(boolean lookupCoreDeflaters) {
        this.lookupCoreDeflaters = lookupCoreDeflaters;
    }

    public void addX2DErrorHandler(X2DErrorHandler handler) {
        this.errorHandlers.add(handler);
    }

    public void registerX2DSource(String xmlSource) throws X2DException {
        X2DSchemaErrorHandler errorHandler = new X2DSchemaErrorHandler();
        try {
            X2DSchema.validX2D(xmlSource, errorHandler);
            if (!errorHandler.hasErrors()) {
                this.x2dDocument = X2DSchema.parseX2D(xmlSource);
                this.x2dDocument.normalize();
                this.x2dInflater = new X2DViewInflater();
                this.x2dInflater.getInflaters().addAll(this.inflaters);
                if (this.lookupCoreInflaters) {
                    this.x2dInflater.getInflaters().addAll(this.coreInflaters);
                }
            } else {
                X2DException x2dException = new X2DException("X2D could not register template source , see exception errors.");
                x2dException.setErrors(errorHandler.getErrors());
                throw x2dException;
            }
            this.x2dInflater.setX2D(this.x2dDocument);
            this.view = this.x2dInflater.inflate();
        }
        catch (SAXException e) {
            throw new X2DException(e);
        }
        catch (IOException e) {
            throw new X2DException(e);
        }
        catch (ParserConfigurationException e) {
            throw new X2DException(e);
        }
    }

    public void registerX2DDocument(Document xmlDocument) throws X2DException {
        X2DSchemaErrorHandler errorHandler = new X2DSchemaErrorHandler();
        X2DSchema.validX2D(xmlDocument, errorHandler);
        if (!errorHandler.hasErrors()) {
            this.x2dDocument = xmlDocument;
            this.x2dDocument.normalize();
            this.x2dInflater = new X2DViewInflater();
            this.x2dInflater.getInflaters().addAll(this.inflaters);
            if (this.lookupCoreInflaters) {
                this.x2dInflater.getInflaters().addAll(this.coreInflaters);
            }
        } else {
            X2DException x2dException = new X2DException("X2D could not register template source , see exception errors.");
            x2dException.setErrors(errorHandler.getErrors());
            throw x2dException;
        }
        this.x2dInflater.setX2D(this.x2dDocument);
        this.view = this.x2dInflater.inflate();
    }

    public void registerX2DFile(File x2dFile) throws X2DException {
        X2DSchemaErrorHandler errorHandler = new X2DSchemaErrorHandler();
        try {
            X2DSchema.validX2D(x2dFile, errorHandler);
            if (!errorHandler.hasErrors()) {
                this.x2dDocument = X2DSchema.parseX2D(x2dFile);
                this.x2dDocument.normalize();
                this.x2dInflater = new X2DViewInflater();
                this.x2dInflater.getInflaters().addAll(this.inflaters);
                if (this.lookupCoreInflaters) {
                    this.x2dInflater.getInflaters().addAll(this.coreInflaters);
                }
            } else {
                X2DException x2dException = new X2DException("X2D could not register template file " + x2dFile.getName() + ", see exception errors.");
                x2dException.setErrors(errorHandler.getErrors());
                throw x2dException;
            }
            this.x2dInflater.setX2D(this.x2dDocument);
            this.view = this.x2dInflater.inflate();
        }
        catch (SAXException e) {
            throw new X2DException(e);
        }
        catch (IOException e) {
            throw new X2DException(e);
        }
        catch (ParserConfigurationException e) {
            throw new X2DException(e);
        }
    }

    public void registerView(View view) throws X2DException {
        this.view = view;
        this.x2dDeflater = new X2DViewDeflater(view);
        this.x2dDeflater.getDeflaters().addAll(this.deflaters);
        if (this.lookupCoreDeflaters) {
            this.x2dDeflater.getDeflaters().addAll(this.coreDeflaters);
        }
        this.x2dDeflater.setView(view);
        this.x2dDocument = this.x2dDeflater.deflate();
    }

    public void registerX2D(InputStream x2dInputStream) throws X2DException {
        if (x2dInputStream == null) {
            throw new X2DException("X2D input stream cannot be null.");
        }
        X2DSchemaErrorHandler errorHandler = new X2DSchemaErrorHandler();
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = x2dInputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            ByteArrayInputStream is1 = new ByteArrayInputStream(baos.toByteArray());
            ByteArrayInputStream is2 = new ByteArrayInputStream(baos.toByteArray());
            x2dInputStream.close();
            baos.close();
            X2DSchema.validX2D(is1, errorHandler);
            if (!errorHandler.hasErrors()) {
                this.x2dDocument = X2DSchema.parseX2D(is2);
                this.x2dDocument.normalize();
                this.x2dInflater = new X2DViewInflater();
                this.x2dInflater.getInflaters().addAll(this.inflaters);
                if (this.lookupCoreInflaters) {
                    this.x2dInflater.getInflaters().addAll(this.coreInflaters);
                }
            } else {
                X2DException x2dException = new X2DException("X2D could not register input stream template file , see exception errors.");
                x2dException.setErrors(errorHandler.getErrors());
                throw x2dException;
            }
            this.x2dInflater.setX2D(this.x2dDocument);
            this.view = this.x2dInflater.inflate();
            ((InputStream)is1).close();
            ((InputStream)is2).close();
        }
        catch (SAXException e) {
            throw new X2DException(e);
        }
        catch (IOException e) {
            throw new X2DException(e);
        }
        catch (ParserConfigurationException e) {
            throw new X2DException(e);
        }
    }

    public List<AbstractX2DPluginInflater<?>> getInflaters() {
        return this.inflaters;
    }

    public void setInflaters(List<AbstractX2DPluginInflater<?>> inflaters) {
        this.inflaters = inflaters;
    }

    public void registerInflater(AbstractX2DPluginInflater<?> inflater) {
        if (inflater.getXSIType() == null) {
            throw new IllegalArgumentException("XSI Type for Inflater :" + inflater.getClass() + " is null. it should be provided");
        }
        this.inflaters.add(inflater);
    }

    public Document getX2dDocument() {
        return this.x2dDocument;
    }

    public View getView() {
        return this.view;
    }

    public int getX2DViewWidth() {
        return this.x2dInflater.getWidth();
    }

    public int getX2DViewHeight() {
        return this.x2dInflater.getHeight();
    }

    public String getViewKey() {
        return this.x2dInflater.getViewKey();
    }

    public String getApiKey() {
        return this.x2dInflater.getAPIKey();
    }
}

