/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding;

import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.background.ViewBackgroundPainter;
import org.jensoft.core.view.background.ViewDefaultBackground;
import org.jensoft.core.view.deflater.AbstractViewDeflater;
import org.jensoft.core.x2d.binding.AbstractX2DPluginDeflater;
import org.jensoft.core.x2d.binding.DeflaterUtil;
import org.jensoft.core.x2d.lang.X2DViewElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X2DViewDeflater
extends AbstractViewDeflater
implements X2DViewElement {
    private Document x2dDocument;
    private List<AbstractX2DPluginDeflater<? extends AbstractPlugin>> deflaters = new ArrayList<AbstractX2DPluginDeflater<? extends AbstractPlugin>>();

    public X2DViewDeflater() {
    }

    public X2DViewDeflater(View view2d) {
        super(view2d);
    }

    public List<AbstractX2DPluginDeflater<? extends AbstractPlugin>> getDeflaters() {
        return this.deflaters;
    }

    public void setDeflaters(List<AbstractX2DPluginDeflater<? extends AbstractPlugin>> deflaters) {
        this.deflaters = deflaters;
    }

    protected AbstractX2DPluginDeflater<? extends AbstractPlugin> lookupType(AbstractPlugin plugin) {
        for (AbstractX2DPluginDeflater<? extends AbstractPlugin> deflater : this.deflaters) {
            if (deflater.getBinding().xsi() == null || !deflater.getBinding().xsi().equals(plugin.getClass().getSimpleName())) continue;
            return deflater;
        }
        return null;
    }

    @Override
    public Document deflate() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.x2dDocument = documentBuilder.newDocument();
            for (AbstractX2DPluginDeflater<? extends AbstractPlugin> deflater : this.deflaters) {
                deflater.setX2dDocument(this.x2dDocument);
            }
            Element view2DElement = this.x2dDocument.createElement("view2d");
            this.x2dDocument.appendChild(view2DElement);
            view2DElement.setAttribute("xmlns", "http://www.jensoft.org/jensoft/schema/x2d");
            view2DElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            view2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "view-key", this.getView().getViewKey()));
            view2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "api-key", this.getView().getApiKey()));
            view2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "width", this.getView().getWidth()));
            view2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "height", this.getView().getHeight()));
            view2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "west", this.getView().getPlaceHolderAxisWest()));
            view2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "east", this.getView().getPlaceHolderAxisEast()));
            view2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "north", this.getView().getPlaceHolderAxisNorth()));
            view2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "south", this.getView().getPlaceHolderAxisSouth()));
            ViewBackgroundPainter painter = this.getView().getBackgroundPainter();
            if (painter instanceof ViewDefaultBackground) {
                ViewDefaultBackground rvf = (ViewDefaultBackground)painter;
                Element view2DBackgroundElement = this.x2dDocument.createElement("background");
                if (rvf.getOutlineRound() > 0) {
                    view2DBackgroundElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "outline-round", rvf.getOutlineRound()));
                }
                if (rvf.getOutlineColor() != null) {
                    view2DBackgroundElement.appendChild(DeflaterUtil.createColorElement(this.x2dDocument, "outline-color", rvf.getOutlineColor()));
                }
                if (rvf.getOutlineStroke() != null) {
                    view2DBackgroundElement.appendChild(DeflaterUtil.createStrokeElement(this.x2dDocument, "outline-stroke", rvf.getOutlineStroke()));
                }
                if (rvf.getShader() != null) {
                    view2DBackgroundElement.appendChild(DeflaterUtil.createShaderElement(this.x2dDocument, "background-shader", rvf.getShader()));
                }
            }
            List<Projection> windows = this.getView().getProjections();
            for (Projection window2d : windows) {
                Element window2DElement = this.x2dDocument.createElement("window2d");
                if (Projection.Linear.class.isAssignableFrom(window2d.getClass())) {
                    window2DElement.setAttribute("xsi:type", "Window2DLinear");
                } else if (Projection.LogX.class.isAssignableFrom(window2d.getClass())) {
                    window2DElement.setAttribute("xsi:type", "Window2DLogX");
                } else if (Projection.LogY.class.isAssignableFrom(window2d.getClass())) {
                    window2DElement.setAttribute("xsi:type", "Window2DLogY");
                } else if (Projection.Log.class.isAssignableFrom(window2d.getClass())) {
                    window2DElement.setAttribute("xsi:type", "Window2DLog");
                } else if (Projection.TimeX.class.isAssignableFrom(window2d.getClass())) {
                    window2DElement.setAttribute("xsi:type", "Window2DTimeX");
                } else if (Projection.TimeY.class.isAssignableFrom(window2d.getClass())) {
                    window2DElement.setAttribute("xsi:type", "Window2DTimeY");
                }
                view2DElement.appendChild(window2DElement);
                if (window2d.getProjectionId() == null) {
                    window2d.setProjectionId("window-" + windows.indexOf(window2d));
                }
                window2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "id", window2d.getProjectionId()));
                if (window2d.getName() != null) {
                    window2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "name", window2d.getName()));
                }
                if (window2d.getThemeColor() != null) {
                    window2DElement.appendChild(DeflaterUtil.createColorElement(this.x2dDocument, "theme-color", window2d.getThemeColor()));
                }
                List<AbstractPlugin> plugins = window2d.getPluginRegistry();
                for (AbstractPlugin abstractPlugin : plugins) {
                    AbstractX2DPluginDeflater<? extends AbstractPlugin> deflater = this.lookupType(abstractPlugin);
                    if (deflater == null) continue;
                    deflater.setPlugin(abstractPlugin);
                    Element pluginElement = deflater.deflate(abstractPlugin);
                    if (pluginElement == null) continue;
                    window2DElement.appendChild(pluginElement);
                }
                window2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "min-x", window2d.getMinX()));
                window2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "max-x", window2d.getMaxX()));
                window2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "min-y", window2d.getMinY()));
                window2DElement.appendChild(DeflaterUtil.createSingleElement(this.x2dDocument, "max-y", window2d.getMaxY()));
            }
            return this.x2dDocument;
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            View view2D = new View();
            view2D.setSize(new Dimension(300, 200));
            Projection.Linear w = new Projection.Linear(-12.4, 22.9, -123.0, 234.0);
            w.setProjectionId("myID");
            w.setName("myWindow name");
            view2D.registerProjection(w);
            X2DViewDeflater deflater = new X2DViewDeflater(view2D);
            Document x2d = deflater.deflate();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(x2d);
            StreamResult result = new StreamResult(new File("C:/usr/x2d/view.xml"));
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

