/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.donut2d;

import java.util.List;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DPlugin;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.effect.AbstractDonut2DEffect;
import org.jensoft.core.plugin.donut2d.painter.effect.Donut2DCompoundEffect;
import org.jensoft.core.plugin.donut2d.painter.effect.Donut2DLinearEffect;
import org.jensoft.core.plugin.donut2d.painter.effect.Donut2DReflectionEffect;
import org.jensoft.core.plugin.donut2d.painter.fill.AbstractDonut2DFill;
import org.jensoft.core.plugin.donut2d.painter.fill.Donut2DDefaultFill;
import org.jensoft.core.plugin.donut2d.painter.fill.Donut2DRadialFill;
import org.jensoft.core.plugin.donut2d.painter.label.AbstractDonut2DSliceLabel;
import org.jensoft.core.plugin.donut2d.painter.label.Donut2DBorderLabel;
import org.jensoft.core.plugin.donut2d.painter.label.Donut2DPathLabel;
import org.jensoft.core.plugin.donut2d.painter.label.Donut2DRadialLabel;
import org.jensoft.core.x2d.binding.AbstractX2DPluginDeflater;
import org.jensoft.core.x2d.binding.DeflaterUtil;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.donut2d.X2DDonut2DElement;
import org.w3c.dom.Element;

@X2DBinding(xsi="Donut2DPlugin", plugin=Donut2DPlugin.class)
public class Donut2DDeflater
extends AbstractX2DPluginDeflater<Donut2DPlugin>
implements X2DDonut2DElement {
    @Override
    public Element deflate(Donut2DPlugin plugin) {
        Element pluginElement = this.createPluginRootElement();
        List<Donut2D> donuts = plugin.getDonuts();
        for (Donut2D donut : donuts) {
            pluginElement.appendChild(this.deflateDonut2D(donut));
        }
        return pluginElement;
    }

    private Element deflateDonut2D(Donut2D donut) {
        Element donutElement = this.getX2dDocument().createElement("donut2d");
        if (donut.getName() == null) {
            donut.setName("donut2d");
        }
        donutElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "name", donut.getName()));
        donutElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "x", donut.getCenterX()));
        donutElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "y", donut.getCenterY()));
        donutElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "inner-radius", donut.getInnerRadius()));
        donutElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "outer-radius", donut.getOuterRadius()));
        donutElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "start-angle", donut.getStartAngleDegree()));
        donutElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "nature", donut.getNature().name()));
        if (donut.getDonut2DFill() != null) {
            donutElement.appendChild(this.deflateDonut2DFill(donut.getDonut2DFill()));
        }
        if (donut.getDonut2DEffect() != null) {
            donutElement.appendChild(this.deflateDonut2DEffect(donut.getDonut2DEffect()));
        }
        for (Donut2DSlice slice : donut.getSlices()) {
            donutElement.appendChild(this.deflateDonut2DSlice(slice));
        }
        return donutElement;
    }

    private Element deflateDonut2DSliceLabel(AbstractDonut2DSliceLabel label) {
        if (label.getClass().getName().equals(Donut2DRadialLabel.class.getName())) {
            return this.deflateDonut2DSliceRadialLabel((Donut2DRadialLabel)label);
        }
        if (label.getClass().getName().equals(Donut2DBorderLabel.class.getName())) {
            return this.deflateDonut2DSliceBorderLabel((Donut2DBorderLabel)label);
        }
        if (label.getClass().getName().equals(Donut2DPathLabel.class.getName())) {
            return this.deflateDonut2DSlicePathLabel((Donut2DPathLabel)label);
        }
        return null;
    }

    private Element deflateDonut2DSlicePathLabel(Donut2DPathLabel label) {
        Element labelElement = this.getX2dDocument().createElement("label");
        labelElement.setAttribute("xsi:type", ELEMENT_DONUT2D_LABEL_TYPE_PATH);
        this.deflateDonut2DSliceLabel(label, labelElement);
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "text-divergence", label.getDivergence()));
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "text-position", label.getTextPosition().name()));
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "text-side", label.getPathSide().name()));
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "segment-path", label.getFacetPathName().name()));
        if (label.getTextShader() != null) {
            labelElement.appendChild(Donut2DDeflater.createShaderElement(this.getX2dDocument(), "text-shader", label.getTextShader()));
        }
        return labelElement;
    }

    private Element deflateDonut2DSliceBorderLabel(Donut2DBorderLabel label) {
        Element labelElement = this.getX2dDocument().createElement("label");
        labelElement.setAttribute("xsi:type", ELEMENT_DONUT2D_LABEL_TYPE_BORDER);
        this.deflateDonut2DSliceLabel(label, labelElement);
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "label-margin", label.getMargin()));
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "link-enable", Boolean.toString(label.isLink())));
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "link-style", label.getLinkStyle().name()));
        labelElement.appendChild(Donut2DDeflater.createColorElement(this.getX2dDocument(), "link-color", label.getLinkColor()));
        labelElement.appendChild(Donut2DDeflater.createStrokeElement(this.getX2dDocument(), "link-stroke", label.getLinkStroke()));
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "link-extends", label.getLinkExtends()));
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "marker-enable", Boolean.toString(label.isLinkMarker())));
        if (label.getLinkMarkerDrawColor() != null) {
            labelElement.appendChild(Donut2DDeflater.createColorElement(this.getX2dDocument(), "marker-draw", label.getLinkMarkerDrawColor()));
        }
        if (label.getLinkMarkerFillColor() != null) {
            labelElement.appendChild(Donut2DDeflater.createColorElement(this.getX2dDocument(), "marker-fill", label.getLinkMarkerFillColor()));
        }
        return labelElement;
    }

    private Element deflateDonut2DSliceRadialLabel(Donut2DRadialLabel label) {
        Element labelElement = this.getX2dDocument().createElement("label");
        labelElement.setAttribute("xsi:type", ELEMENT_DONUT2D_LABEL_TYPE_RADIAL);
        this.deflateDonut2DSliceLabel(label, labelElement);
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "offsetRadius", label.getOffsetRadius()));
        return labelElement;
    }

    private void deflateDonut2DSliceLabel(AbstractDonut2DSliceLabel abstractLabel, Element labelElement) {
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "text", abstractLabel.getLabel()));
        labelElement.appendChild(Donut2DDeflater.createColorElement(this.getX2dDocument(), "text-color", abstractLabel.getLabelColor()));
        Element fontElement = Donut2DDeflater.createFontElement(this.getX2dDocument(), "font", abstractLabel.getLabelFont());
        if (fontElement != null) {
            labelElement.appendChild(fontElement);
        }
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "text-padding-x", abstractLabel.getLabelPaddingX()));
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "text-padding-y", abstractLabel.getLabelPaddingY()));
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "outline-round", abstractLabel.getOutlineRound()));
        if (abstractLabel.getOutlineColor() != null) {
            labelElement.appendChild(Donut2DDeflater.createColorElement(this.getX2dDocument(), "outline-color", abstractLabel.getOutlineColor()));
        }
        if (abstractLabel.getOutlineStroke() != null) {
            labelElement.appendChild(Donut2DDeflater.createStrokeElement(this.getX2dDocument(), "outline-stroke", abstractLabel.getOutlineStroke()));
        }
        if (abstractLabel.getFillColor() != null) {
            labelElement.appendChild(Donut2DDeflater.createColorElement(this.getX2dDocument(), "fill-color", abstractLabel.getFillColor()));
        }
        if (abstractLabel.getShadeFractions() != null && abstractLabel.getShadeColors() != null) {
            labelElement.appendChild(Donut2DDeflater.createShaderElement(this.getX2dDocument(), "shader", new Shader(abstractLabel.getShadeFractions(), abstractLabel.getShadeColors())));
        }
        labelElement.appendChild(Donut2DDeflater.createSingleElement(this.getX2dDocument(), "style", abstractLabel.getStyle().name()));
    }

    private Element deflateDonut2DSlice(Donut2DSlice slice) {
        Element sliceElement = this.getX2dDocument().createElement("slice");
        if (slice.getName() != null) {
            sliceElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "name", slice.getName()));
        }
        sliceElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "value", slice.getValue()));
        sliceElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "divergence", slice.getDivergence()));
        sliceElement.appendChild(DeflaterUtil.createColorElement(this.getX2dDocument(), "slice-color", slice.getThemeColor()));
        for (AbstractDonut2DSliceLabel label : slice.getSliceLabels()) {
            sliceElement.appendChild(this.deflateDonut2DSliceLabel(label));
        }
        return sliceElement;
    }

    private Element deflateDonut2DLinearEffect(Donut2DLinearEffect effect) {
        Element effectElement = this.getX2dDocument().createElement("effect");
        effectElement.setAttribute("xsi:type", ELEMENT_DONUT2D_EFFECT_TYPE_LINEAR);
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "incidence-angle", effect.getIncidenceAngleDegree()));
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "offset-radius", effect.getOffsetRadius()));
        return effectElement;
    }

    private Element deflateDonut2DReflectionEffect(Donut2DReflectionEffect effect) {
        Element effectElement = this.getX2dDocument().createElement("effect");
        effectElement.setAttribute("xsi:type", ELEMENT_DONUT2D_EFFECT_TYPE_REFLECTION);
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "blur-enable", Boolean.toString(effect.isBlurEnabled())));
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "mask-opacity", effect.getOpacity()));
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "reflect-length", effect.getLength()));
        return effectElement;
    }

    private Element deflateDonut2DCompoundEffect(Donut2DCompoundEffect effect) {
        Element effectElement = this.getX2dDocument().createElement("effect");
        effectElement.setAttribute("xsi:type", ELEMENT_DONUT2D_EFFECT_TYPE_COMPOUND);
        AbstractDonut2DEffect[] effects = effect.getEffects();
        for (int i = 0; i < effects.length; ++i) {
            Element e = this.deflateDonut2DEffect(effects[i]);
            if (e == null) continue;
            effectElement.appendChild(e);
        }
        return effectElement;
    }

    private Element deflateDonut2DFill(AbstractDonut2DFill fill) {
        if (fill.getClass().getName().equals(Donut2DDefaultFill.class.getName())) {
            Element fillElement = this.getX2dDocument().createElement("fill");
            fillElement.setAttribute("xsi:type", ELEMENT_DONUT2D_FILL_TYPE_DEFAULT);
            return fillElement;
        }
        if (fill.getClass().getName().equals(Donut2DRadialFill.class.getName())) {
            Element fillElement = this.getX2dDocument().createElement("fill");
            fillElement.setAttribute("xsi:type", ELEMENT_DONUT2D_FILL_TYPE_RADIAL);
            Donut2DRadialFill radialFill = (Donut2DRadialFill)fill;
            fillElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "gradient-type", radialFill.getGradientBehavior().name()));
            return fillElement;
        }
        return null;
    }

    private Element deflateDonut2DEffect(AbstractDonut2DEffect effect) {
        if (effect.getClass().getName().equals(Donut2DCompoundEffect.class.getName())) {
            return this.deflateDonut2DCompoundEffect((Donut2DCompoundEffect)effect);
        }
        if (effect.getClass().getName().equals(Donut2DLinearEffect.class.getName())) {
            return this.deflateDonut2DLinearEffect((Donut2DLinearEffect)effect);
        }
        if (effect.getClass().getName().equals(Donut2DReflectionEffect.class.getName())) {
            return this.deflateDonut2DReflectionEffect((Donut2DReflectionEffect)effect);
        }
        return null;
    }
}

