/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.donut2d;

import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DPlugin;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.Donut2DToolkit;
import org.jensoft.core.plugin.donut2d.painter.effect.AbstractDonut2DEffect;
import org.jensoft.core.plugin.donut2d.painter.effect.Donut2DCompoundEffect;
import org.jensoft.core.plugin.donut2d.painter.effect.Donut2DLinearEffect;
import org.jensoft.core.plugin.donut2d.painter.effect.Donut2DReflectionEffect;
import org.jensoft.core.plugin.donut2d.painter.fill.AbstractDonut2DFill;
import org.jensoft.core.plugin.donut2d.painter.fill.Donut2DDefaultFill;
import org.jensoft.core.plugin.donut2d.painter.fill.Donut2DRadialFill;
import org.jensoft.core.plugin.donut2d.painter.fill.Donut2DSliceRadialFill;
import org.jensoft.core.plugin.donut2d.painter.label.AbstractDonut2DSliceLabel;
import org.jensoft.core.plugin.donut2d.painter.label.Donut2DBorderLabel;
import org.jensoft.core.plugin.donut2d.painter.label.Donut2DPathLabel;
import org.jensoft.core.plugin.donut2d.painter.label.Donut2DRadialLabel;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.InflaterUtil;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.donut2d.X2DDonut2DElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@X2DBinding(xsi="Donut2DPlugin", plugin=Donut2DPlugin.class)
public class Donut2DInflater
extends AbstractX2DPluginInflater<Donut2DPlugin>
implements X2DDonut2DElement {
    private Donut2DLinearEffect inflateDonut2DLinearEffect(Element effectElement) {
        Element incidenceElement = (Element)effectElement.getElementsByTagName("incidence-angle").item(0);
        Element offsetElement = (Element)effectElement.getElementsByTagName("offset-radius").item(0);
        Donut2DLinearEffect linear = new Donut2DLinearEffect();
        if (incidenceElement != null) {
            linear.setIncidenceAngleDegree(Integer.parseInt(incidenceElement.getTextContent().trim()));
        }
        if (offsetElement != null) {
            linear.setOffsetRadius(Integer.parseInt(offsetElement.getTextContent().trim()));
        }
        return linear;
    }

    private Donut2DReflectionEffect inflateDonut2DReflectionEffect(Element effectElement) {
        Element blurElement = (Element)effectElement.getElementsByTagName("blur-enable").item(0);
        Element opacityElement = (Element)effectElement.getElementsByTagName("mask-opacity").item(0);
        Element lengthElement = (Element)effectElement.getElementsByTagName("reflect-length").item(0);
        Donut2DReflectionEffect reflectionEffect = new Donut2DReflectionEffect();
        if (blurElement != null) {
            reflectionEffect.setBlurEnabled(Boolean.parseBoolean(blurElement.getTextContent().trim()));
        }
        if (opacityElement != null) {
            reflectionEffect.setOpacity(Float.parseFloat(opacityElement.getTextContent().trim()));
        }
        if (lengthElement != null) {
            reflectionEffect.setLength(Float.parseFloat(lengthElement.getTextContent().trim()));
        }
        return reflectionEffect;
    }

    private AbstractDonut2DEffect inflateDonut2DEffect(Element donut2DEffectElement) {
        if (donut2DEffectElement == null) {
            return null;
        }
        String type = donut2DEffectElement.getAttribute("xsi:type");
        if (type == null) {
            return null;
        }
        if (Donut2DEffectType.Donut2DCompoundEffect.getDonut2DEffectType().equals(type)) {
            NodeList effectElementList = donut2DEffectElement.getElementsByTagName("effect");
            AbstractDonut2DEffect[] fxs = new AbstractDonut2DEffect[effectElementList.getLength()];
            for (int i = 0; i < effectElementList.getLength(); ++i) {
                Element subEffectElement = (Element)effectElementList.item(i);
                fxs[i] = this.inflateDonut2DEffect(subEffectElement);
            }
            return new Donut2DCompoundEffect(fxs);
        }
        if (Donut2DEffectType.Donut2DLinearEffect.getDonut2DEffectType().equals(type)) {
            return this.inflateDonut2DLinearEffect(donut2DEffectElement);
        }
        if (Donut2DEffectType.Donut2DReflectionEffect.getDonut2DEffectType().equals(type)) {
            return this.inflateDonut2DReflectionEffect(donut2DEffectElement);
        }
        return null;
    }

    private Donut2DDefaultFill inflateDonut2DDefaultFill(Element fillElement) {
        Donut2DDefaultFill defaultFill = new Donut2DDefaultFill();
        return defaultFill;
    }

    private Donut2DRadialFill inflateDonut2DRadialFill(Element fillElement) {
        Element gradientBehaviorElement = (Element)fillElement.getElementsByTagName("gradient-type").item(0);
        Donut2DRadialFill radialFill = new Donut2DRadialFill();
        if (gradientBehaviorElement != null) {
            radialFill.setGradientBehavior(Donut2DSliceRadialFill.GradientFillType.parse(gradientBehaviorElement.getTextContent().trim()));
        }
        return radialFill;
    }

    private AbstractDonut2DFill inflateDonut2DFill(Element donut2DFillElement) {
        if (donut2DFillElement == null) {
            return null;
        }
        String type = donut2DFillElement.getAttribute("xsi:type");
        if (type == null) {
            return null;
        }
        if (Donut2DFillType.Donut2DDefaultFill.getDonut2DPaintType().equals(type)) {
            return this.inflateDonut2DDefaultFill(donut2DFillElement);
        }
        if (Donut2DFillType.Donut2DRadialFill.getDonut2DPaintType().equals(type)) {
            return this.inflateDonut2DRadialFill(donut2DFillElement);
        }
        return null;
    }

    private Donut2DBorderLabel inflateDonut2DSliceBorderLabel(Element labelElement) {
        Donut2DBorderLabel sliceLabel = new Donut2DBorderLabel();
        this.inflateDonut2DSliceLabel(sliceLabel, labelElement);
        String link = Donut2DInflater.elementText(labelElement, "link-enable");
        String linkStyle = Donut2DInflater.elementText(labelElement, "link-style");
        Element linkColorElement = (Element)labelElement.getElementsByTagName("link-color").item(0);
        Element linkStrokeElement = (Element)labelElement.getElementsByTagName("link-stroke").item(0);
        String linkextends = Donut2DInflater.elementText(labelElement, "link-extends");
        String linkMarker = Donut2DInflater.elementText(labelElement, "marker-enable");
        Element linkMarkerDrawColorElement = (Element)labelElement.getElementsByTagName("marker-draw").item(0);
        Element linkMarkerFillColorElement = (Element)labelElement.getElementsByTagName("marker-fill").item(0);
        String margin = Donut2DInflater.elementText(labelElement, "label-margin");
        if (link != null && !link.equals("undefined")) {
            sliceLabel.setLink(Boolean.parseBoolean(link));
        }
        if (linkStyle != null && !linkStyle.equals("undefined")) {
            sliceLabel.setLinkStyle(Donut2DBorderLabel.LinkStyle.parseStyle(linkStyle));
        }
        if (linkextends != null && !linkextends.equals("undefined")) {
            sliceLabel.setLinkExtends(Integer.parseInt(linkextends));
        }
        sliceLabel.setLinkColor(Donut2DInflater.elementColor(linkColorElement));
        sliceLabel.setLinkStroke(InflaterUtil.elementStroke(linkStrokeElement));
        if (linkMarker != null && !linkMarker.equals("undefined")) {
            sliceLabel.setLinkMarker(Boolean.parseBoolean(linkMarker));
        }
        sliceLabel.setLinkMarkerDrawColor(Donut2DInflater.elementColor(linkMarkerDrawColorElement));
        sliceLabel.setLinkMarkerFillColor(Donut2DInflater.elementColor(linkMarkerFillColorElement));
        if (margin != null && !margin.equals("undefined")) {
            sliceLabel.setMargin(Integer.parseInt(margin));
        }
        return sliceLabel;
    }

    private Donut2DRadialLabel inflateDonut2DSliceRadialLabel(Element labelElement) {
        Donut2DRadialLabel sliceLabel = new Donut2DRadialLabel();
        this.inflateDonut2DSliceLabel(sliceLabel, labelElement);
        String offsetRadius = Donut2DInflater.elementText(labelElement, "offsetRadius");
        if (offsetRadius != null && !offsetRadius.equals("undefined")) {
            sliceLabel.setOffsetRadius(Integer.parseInt(offsetRadius));
        }
        return sliceLabel;
    }

    private Donut2DPathLabel inflateDonut2DSlicePathLabel(Element labelElement) {
        Donut2DPathLabel sliceLabel = new Donut2DPathLabel();
        this.inflateDonut2DSliceLabel(sliceLabel, labelElement);
        String pathdivergence = Donut2DInflater.elementText(labelElement, "text-divergence");
        String textposition = Donut2DInflater.elementText(labelElement, "text-position");
        String pathside = Donut2DInflater.elementText(labelElement, "text-side");
        String pathname = Donut2DInflater.elementText(labelElement, "segment-path");
        Element textShaderElement = (Element)labelElement.getElementsByTagName("text-shader").item(0);
        sliceLabel.setDivergence(Donut2DPathLabel.parseDivergence(pathdivergence));
        sliceLabel.setFacetPathName(Donut2DPathLabel.Donut2DFacetPathName.parse(pathname));
        sliceLabel.setTextPosition(TextPath.TextPosition.parse(textposition));
        sliceLabel.setPathSide(TextPath.PathSide.parse(pathside));
        sliceLabel.setTextShader(InflaterUtil.elementShader(textShaderElement));
        return sliceLabel;
    }

    private void inflateDonut2DSliceLabel(AbstractDonut2DSliceLabel abstractLabel, Element labelElement) {
        String text = Donut2DInflater.elementText(labelElement, "text");
        Element textColorElement = (Element)labelElement.getElementsByTagName("text-color").item(0);
        String font = Donut2DInflater.elementText(labelElement, "font");
        String labelPaddingX = Donut2DInflater.elementText(labelElement, "text-padding-x");
        String labelPaddingY = Donut2DInflater.elementText(labelElement, "text-padding-y");
        String outlineRound = Donut2DInflater.elementText(labelElement, "outline-round");
        Element outlineColorElement = (Element)labelElement.getElementsByTagName("outline-color").item(0);
        Element outlineStrokeElement = (Element)labelElement.getElementsByTagName("outline-stroke").item(0);
        Element fillColorElement = (Element)labelElement.getElementsByTagName("fill-color").item(0);
        Element shaderElement = (Element)labelElement.getElementsByTagName("shader").item(0);
        String style = Donut2DInflater.elementText(labelElement, "style");
        abstractLabel.setLabel(text);
        abstractLabel.setLabelColor(Donut2DInflater.elementColor(textColorElement));
        abstractLabel.setLabelFont(InflaterUtil.parseFont(font));
        abstractLabel.setLabelPaddingX(Integer.parseInt(labelPaddingX));
        abstractLabel.setLabelPaddingY(Integer.parseInt(labelPaddingY));
        abstractLabel.setOutlineRound(Integer.parseInt(outlineRound));
        abstractLabel.setOutlineColor(Donut2DInflater.elementColor(outlineColorElement));
        abstractLabel.setOutlineStroke(InflaterUtil.elementStroke(outlineStrokeElement));
        abstractLabel.setFillColor(Donut2DInflater.elementColor(fillColorElement));
        abstractLabel.setShader(InflaterUtil.elementShader(shaderElement));
        abstractLabel.setStyle(AbstractDonut2DSliceLabel.Style.parseStyle(style));
    }

    private AbstractDonut2DSliceLabel inflateDonut2DSliceLabel(Element labelElement) {
        String type = labelElement.getAttribute("xsi:type");
        if (type == null) {
            return null;
        }
        if (Donut2DLabelType.Donut2DRadialLabel.getDonut2DLabelType().equals(type)) {
            return this.inflateDonut2DSliceRadialLabel(labelElement);
        }
        if (Donut2DLabelType.Donut2DBorderLabel.getDonut2DLabelType().equals(type)) {
            return this.inflateDonut2DSliceBorderLabel(labelElement);
        }
        if (Donut2DLabelType.Donut2DPathLabel.getDonut2DLabelType().equals(type)) {
            return this.inflateDonut2DSlicePathLabel(labelElement);
        }
        return null;
    }

    private Donut2DSlice inflateDonut2DSlice(Element sliceElement) {
        String sliceName = Donut2DInflater.elementText(sliceElement, "name");
        String value = Donut2DInflater.elementText(sliceElement, "value");
        String divergence = Donut2DInflater.elementText(sliceElement, "divergence");
        Element colorElement = (Element)sliceElement.getElementsByTagName("slice-color").item(0);
        Donut2DSlice s = Donut2DToolkit.createDonut2DSlice(sliceName, Donut2DInflater.elementColor(colorElement), Integer.parseInt(value), Integer.parseInt(divergence));
        NodeList labelListElement = sliceElement.getElementsByTagName("label");
        for (int i = 0; i < labelListElement.getLength(); ++i) {
            Element labelElement = (Element)labelListElement.item(i);
            AbstractDonut2DSliceLabel sliceLabel = this.inflateDonut2DSliceLabel(labelElement);
            if (sliceLabel == null) continue;
            s.addSliceLabel(sliceLabel);
        }
        return s;
    }

    private Donut2D inflateDonut2D(Element donut2DElement) {
        Element effectElement;
        AbstractDonut2DEffect donut2DEffect;
        String x = Donut2DInflater.elementText(donut2DElement, "x");
        String y = Donut2DInflater.elementText(donut2DElement, "y");
        String innerRadius = Donut2DInflater.elementText(donut2DElement, "inner-radius");
        String outerRadius = Donut2DInflater.elementText(donut2DElement, "outer-radius");
        String startAngleDegree = Donut2DInflater.elementText(donut2DElement, "start-angle");
        String nature = Donut2DInflater.elementText(donut2DElement, "nature");
        Donut2D donut2D = Donut2DToolkit.createDonut2D("donut2d", Integer.parseInt(innerRadius), Integer.parseInt(outerRadius));
        donut2D.setCenterX(Double.parseDouble(x));
        donut2D.setCenterY(Double.parseDouble(y));
        donut2D.setStartAngleDegree(Integer.parseInt(startAngleDegree));
        donut2D.setNature(Donut2D.Donut2DNature.parseNature(nature));
        NodeList slices = donut2DElement.getElementsByTagName("slice");
        for (int i = 0; i < slices.getLength(); ++i) {
            Element donut3DSliceElement = (Element)slices.item(i);
            Donut2DSlice donut3DSlice = this.inflateDonut2DSlice(donut3DSliceElement);
            donut2D.addSlice(donut3DSlice);
        }
        Element fillElement = (Element)donut2DElement.getElementsByTagName("fill").item(0);
        AbstractDonut2DFill donut2DFill = this.inflateDonut2DFill(fillElement);
        if (donut2DFill != null) {
            donut2D.setDonut2DFill(donut2DFill);
        }
        if ((donut2DEffect = this.inflateDonut2DEffect(effectElement = (Element)donut2DElement.getElementsByTagName("effect").item(0))) != null) {
            donut2D.setDonut2DEffect(donut2DEffect);
        }
        return donut2D;
    }

    @Override
    public Donut2DPlugin inflate(Element pluginElement) {
        Donut2DPlugin d2d = new Donut2DPlugin();
        NodeList donut2DElementList = pluginElement.getElementsByTagName("donut2d");
        for (int i = 0; i < donut2DElementList.getLength(); ++i) {
            Element donut2DElement = (Element)donut2DElementList.item(i);
            Donut2D donut2d = this.inflateDonut2D(donut2DElement);
            d2d.addDonut(donut2d);
        }
        return d2d;
    }

    public static enum Donut2DLabelType {
        Donut2DRadialLabel("Donut2DRadialLabel"),
        Donut2DBorderLabel("Donut2DBorderLabel"),
        Donut2DPathLabel("Donut2DPathLabel");

        private String donut2DLabelType;

        private Donut2DLabelType(String donut2DLabelType) {
            this.donut2DLabelType = donut2DLabelType;
        }

        public String getDonut2DLabelType() {
            return this.donut2DLabelType;
        }
    }

    public static enum Donut2DFillType {
        Donut2DDefaultFill("Donut2DDefaultFill"),
        Donut2DRadialFill("Donut2DRadialFill");

        private String donut2DFillType;

        private Donut2DFillType(String donut2DFillType) {
            this.donut2DFillType = donut2DFillType;
        }

        public String getDonut2DPaintType() {
            return this.donut2DFillType;
        }
    }

    public static enum Donut2DEffectType {
        Donut2DLinearEffect("Donut2DLinearEffect"),
        Donut2DReflectionEffect("Donut2DReflectionEffect"),
        Donut2DCompoundEffect("Donut2DCompoundEffect");

        private String donut2DEffectType;

        private Donut2DEffectType(String donut2DEffectType) {
            this.donut2DEffectType = donut2DEffectType;
        }

        public String getDonut2DEffectType() {
            return this.donut2DEffectType;
        }
    }
}

