/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.donut3d;

import java.util.List;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.Donut3DPlugin;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.painter.label.AbstractDonut3DSliceLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DBorderLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DPathLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DRadialLabel;
import org.jensoft.core.plugin.donut3d.painter.paint.Donut3DDefaultPaint;
import org.jensoft.core.x2d.binding.AbstractX2DPluginDeflater;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.donut3d.X2DDonut3DElement;
import org.w3c.dom.Element;

@X2DBinding(xsi="Donut3DPlugin", plugin=Donut3DPlugin.class)
public class Donut3DDeflater
extends AbstractX2DPluginDeflater<Donut3DPlugin>
implements X2DDonut3DElement {
    @Override
    public Element deflate(Donut3DPlugin plugin) {
        Element pluginElement = this.createPluginRootElement();
        List<Donut3D> donuts = plugin.getDonuts3D();
        for (Donut3D donut : donuts) {
            pluginElement.appendChild(this.deflateDonut3D(donut));
        }
        return pluginElement;
    }

    private Element deflateDonut3D(Donut3D donut) {
        Element donut3DElement = this.getX2dDocument().createElement("donut3d");
        if (donut.getName() == null) {
            donut.setName("donut3d");
        }
        donut3DElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "name", donut.getName()));
        donut3DElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "x", donut.getCenterX()));
        donut3DElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "y", donut.getCenterY()));
        donut3DElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "inner-radius", donut.getInnerRadius()));
        donut3DElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "outer-radius", donut.getOuterRadius()));
        donut3DElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "thickness", donut.getThickness()));
        donut3DElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "tilt", donut.getTilt()));
        donut3DElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "start-angle", donut.getStartAngleDegree()));
        donut3DElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "nature", donut.getDonut3DNature().name()));
        List<Donut3DSlice> slices = donut.getSlices();
        for (Donut3DSlice donut3dSlice : slices) {
            donut3DElement.appendChild(this.deflateDonut3DSlice(donut3dSlice));
        }
        donut3DElement.appendChild(this.deflateDonut3DPaint(donut));
        return donut3DElement;
    }

    private Element deflateDonut3DPaint(Donut3D donut) {
        if (donut.getDonut3DPaint().getClass().getName().equals(Donut3DDefaultPaint.class.getName())) {
            Element paintElement = this.getX2dDocument().createElement("paint");
            paintElement.setAttribute("xsi:type", ELEMENT_DONUT3D_PAINT_TYPE_DEFAULT);
            Donut3DDefaultPaint defaultPaint = (Donut3DDefaultPaint)donut.getDonut3DPaint();
            paintElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "incidence-effect-angle", defaultPaint.getIncidenceAngleDegree()));
            paintElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "slice-fill-alpha", defaultPaint.getAlphaFill()));
            paintElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "inner-effect-alpha", defaultPaint.getAlphaInner()));
            paintElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "inner-effect-enable", Boolean.toString(defaultPaint.isPaintInnerEffect())));
            paintElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "outer-effect-alpha", defaultPaint.getAlphaOuter()));
            paintElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "outer-effect-enable", Boolean.toString(defaultPaint.isPaintOuterEffect())));
            paintElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "top-effect-alpha", defaultPaint.getAlphaTop()));
            paintElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "top-effect-enable", Boolean.toString(defaultPaint.isPaintTopEffect())));
            return paintElement;
        }
        return null;
    }

    private Element deflateDonut3DSlice(Donut3DSlice slice) {
        Element sliceElement = this.getX2dDocument().createElement("slice");
        if (slice.getName() != null) {
            slice.setName("slice");
        }
        sliceElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "name", slice.getName()));
        sliceElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "value", slice.getValue()));
        sliceElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "divergence", slice.getDivergence()));
        sliceElement.appendChild(Donut3DDeflater.createColorElement(this.getX2dDocument(), "slice-color", slice.getThemeColor()));
        for (AbstractDonut3DSliceLabel label : slice.getSliceLabels()) {
            sliceElement.appendChild(this.deflateDonut3DSliceLabel(label));
        }
        return sliceElement;
    }

    private Element deflateDonut3DSliceLabel(AbstractDonut3DSliceLabel label) {
        if (label.getClass().getName().equals(Donut3DRadialLabel.class.getName())) {
            return this.deflateDonut3DSliceRadialLabel((Donut3DRadialLabel)label);
        }
        if (label.getClass().getName().equals(Donut3DBorderLabel.class.getName())) {
            return this.deflateDonut3DSliceBorderLabel((Donut3DBorderLabel)label);
        }
        if (label.getClass().getName().equals(Donut3DPathLabel.class.getName())) {
            return this.deflateDonut3DSlicePathLabel((Donut3DPathLabel)label);
        }
        return null;
    }

    private void deflateDonut3DSliceLabel(AbstractDonut3DSliceLabel abstractLabel, Element labelElement) {
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "text", abstractLabel.getLabel()));
        labelElement.appendChild(Donut3DDeflater.createColorElement(this.getX2dDocument(), "textColor", abstractLabel.getLabelColor()));
        Element fontElement = Donut3DDeflater.createFontElement(this.getX2dDocument(), "font", abstractLabel.getLabelFont());
        if (fontElement != null) {
            labelElement.appendChild(fontElement);
        }
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "text-padding-x", abstractLabel.getLabelPaddingX()));
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "text-padding-y", abstractLabel.getLabelPaddingY()));
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "outline-round", abstractLabel.getOutlineRound()));
        if (abstractLabel.getOutlineColor() != null) {
            labelElement.appendChild(Donut3DDeflater.createColorElement(this.getX2dDocument(), "outline-color", abstractLabel.getOutlineColor()));
        }
        if (abstractLabel.getOutlineStroke() != null) {
            labelElement.appendChild(Donut3DDeflater.createStrokeElement(this.getX2dDocument(), "outline-stroke", abstractLabel.getOutlineStroke()));
        }
        if (abstractLabel.getFillColor() != null) {
            labelElement.appendChild(Donut3DDeflater.createColorElement(this.getX2dDocument(), "fill-color", abstractLabel.getFillColor()));
        }
        if (abstractLabel.getShadeFractions() != null && abstractLabel.getShadeColors() != null) {
            labelElement.appendChild(Donut3DDeflater.createShaderElement(this.getX2dDocument(), "shader", new Shader(abstractLabel.getShadeFractions(), abstractLabel.getShadeColors())));
        }
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "style", abstractLabel.getStyle().name()));
    }

    private Element deflateDonut3DSlicePathLabel(Donut3DPathLabel label) {
        Element labelElement = this.getX2dDocument().createElement("label");
        labelElement.setAttribute("xsi:type", "Donut3DPathLabel");
        this.deflateDonut3DSliceLabel(label, labelElement);
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "text-divergence", label.getDivergence()));
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "text-position", label.getTextPosition().name()));
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "text-side", label.getPathSide().name()));
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "segment-path", label.getFacetPathName().name()));
        if (label.getTextShader() != null) {
            labelElement.appendChild(Donut3DDeflater.createShaderElement(this.getX2dDocument(), "text-shader", label.getTextShader()));
        }
        return labelElement;
    }

    private Element deflateDonut3DSliceBorderLabel(Donut3DBorderLabel label) {
        Element labelElement = this.getX2dDocument().createElement("label");
        labelElement.setAttribute("xsi:type", "Donut3DBorderLabel");
        this.deflateDonut3DSliceLabel(label, labelElement);
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "label-margin", label.getMargin()));
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "link-enable", Boolean.toString(label.isLink())));
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "link-style", label.getLinkStyle().name()));
        labelElement.appendChild(Donut3DDeflater.createColorElement(this.getX2dDocument(), "link-color", label.getLinkColor()));
        labelElement.appendChild(Donut3DDeflater.createStrokeElement(this.getX2dDocument(), "link-stroke", label.getLinkStroke()));
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "link-extends", label.getLinkExtends()));
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "marker-enable", Boolean.toString(label.isLinkMarker())));
        if (label.getLinkMarkerDrawColor() != null) {
            labelElement.appendChild(Donut3DDeflater.createColorElement(this.getX2dDocument(), "marker-draw", label.getLinkMarkerDrawColor()));
        }
        if (label.getLinkMarkerFillColor() != null) {
            labelElement.appendChild(Donut3DDeflater.createColorElement(this.getX2dDocument(), "marker-fill", label.getLinkMarkerFillColor()));
        }
        return labelElement;
    }

    private Element deflateDonut3DSliceRadialLabel(Donut3DRadialLabel label) {
        Element labelElement = this.getX2dDocument().createElement("label");
        labelElement.setAttribute("xsi:type", "Donut3DRadialLabel");
        this.deflateDonut3DSliceLabel(label, labelElement);
        labelElement.appendChild(Donut3DDeflater.createSingleElement(this.getX2dDocument(), "offsetRadius", label.getOffsetRadius()));
        return labelElement;
    }
}

