/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.donut3d;

import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.plugin.donut3d.Donut3D;
import org.jensoft.core.plugin.donut3d.Donut3DPlugin;
import org.jensoft.core.plugin.donut3d.Donut3DSlice;
import org.jensoft.core.plugin.donut3d.Donut3DToolkit;
import org.jensoft.core.plugin.donut3d.painter.label.AbstractDonut3DSliceLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DBorderLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DPathLabel;
import org.jensoft.core.plugin.donut3d.painter.label.Donut3DRadialLabel;
import org.jensoft.core.plugin.donut3d.painter.paint.AbstractDonut3DPaint;
import org.jensoft.core.plugin.donut3d.painter.paint.Donut3DDefaultPaint;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.InflaterUtil;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.donut3d.X2DDonut3DElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@X2DBinding(xsi="Donut3DPlugin", plugin=Donut3DPlugin.class)
public class Donut3DInflater
extends AbstractX2DPluginInflater<Donut3DPlugin>
implements X2DDonut3DElement {
    private Donut3DDefaultPaint inflateDonut3DDefaultPaint(Element paintElement) {
        Element incidenceElement = (Element)paintElement.getElementsByTagName("incidence-effect-angle").item(0);
        Element paintTopEffect = (Element)paintElement.getElementsByTagName("top-effect-enable").item(0);
        Element paintInnerEffect = (Element)paintElement.getElementsByTagName("inner-effect-enable").item(0);
        Element paintOuterEffect = (Element)paintElement.getElementsByTagName("outer-effect-enable").item(0);
        Element alphaFillElement = (Element)paintElement.getElementsByTagName("slice-fill-alpha").item(0);
        Element alphaTopEffectElement = (Element)paintElement.getElementsByTagName("top-effect-alpha").item(0);
        Element alphaInnerEffectElement = (Element)paintElement.getElementsByTagName("inner-effect-alpha").item(0);
        Element alphaOuterEffectElement = (Element)paintElement.getElementsByTagName("outer-effect-alpha").item(0);
        Donut3DDefaultPaint defaultPaint = new Donut3DDefaultPaint();
        if (incidenceElement != null) {
            defaultPaint.setIncidenceAngleDegree(Integer.parseInt(incidenceElement.getTextContent().trim()));
        }
        if (paintTopEffect != null) {
            defaultPaint.setPaintTopEffect(Boolean.parseBoolean(paintTopEffect.getTextContent()));
        }
        if (paintInnerEffect != null) {
            defaultPaint.setPaintInnerEffect(Boolean.parseBoolean(paintInnerEffect.getTextContent()));
        }
        if (paintOuterEffect != null) {
            defaultPaint.setPaintOuterEffect(Boolean.parseBoolean(paintOuterEffect.getTextContent()));
        }
        if (alphaFillElement != null) {
            defaultPaint.setAlphaFill(Float.parseFloat(alphaFillElement.getTextContent()));
        }
        if (alphaTopEffectElement != null) {
            defaultPaint.setAlphaTop(Float.parseFloat(alphaTopEffectElement.getTextContent()));
        }
        if (alphaInnerEffectElement != null) {
            defaultPaint.setAlphaInner(Float.parseFloat(alphaInnerEffectElement.getTextContent()));
        }
        if (alphaOuterEffectElement != null) {
            defaultPaint.setAlphaOuter(Float.parseFloat(alphaOuterEffectElement.getTextContent()));
        }
        return defaultPaint;
    }

    private AbstractDonut3DPaint inflateDonut3DPaint(Element donut3DPaintElement) {
        String type = donut3DPaintElement.getAttribute("xsi:type");
        if (type == null) {
            return null;
        }
        if (Donut3DPaintType.Donut3DDefaultPaint.getDonut3DPaintType().equals(type)) {
            return this.inflateDonut3DDefaultPaint(donut3DPaintElement);
        }
        return null;
    }

    private Donut3DBorderLabel inflateDonut3DSliceBorderLabel(Element labelElement) {
        Donut3DBorderLabel sliceLabel = new Donut3DBorderLabel();
        this.inflateDonut3DSliceLabel(sliceLabel, labelElement);
        String link = Donut3DInflater.elementText(labelElement, "link-enable");
        String linkStyle = Donut3DInflater.elementText(labelElement, "link-style");
        Element linkColorElement = (Element)labelElement.getElementsByTagName("link-color").item(0);
        Element linkStrokeElement = (Element)labelElement.getElementsByTagName("link-stroke").item(0);
        String linkextends = Donut3DInflater.elementText(labelElement, "link-extends");
        String linkAlignment = Donut3DInflater.elementText(labelElement, "link-alignment");
        String linkMarker = Donut3DInflater.elementText(labelElement, "marker-enable");
        Element linkMarkerDrawColorElement = (Element)labelElement.getElementsByTagName("marker-draw").item(0);
        Element linkMarkerFillColorElement = (Element)labelElement.getElementsByTagName("marker-fill").item(0);
        String margin = Donut3DInflater.elementText(labelElement, "label-margin");
        if (link != null && !link.equals("undefined")) {
            sliceLabel.setLink(Boolean.parseBoolean(link));
        }
        if (linkStyle != null && !linkStyle.equals("undefined")) {
            sliceLabel.setLinkStyle(Donut3DBorderLabel.LinkStyle.parseStyle(linkStyle));
        }
        if (linkAlignment != null && !linkAlignment.equals("undefined")) {
            sliceLabel.setLinkAlignment(Donut3DBorderLabel.LinkAlignment.parseLinkAlignment(linkAlignment));
        }
        if (linkextends != null && !linkextends.equals("undefined")) {
            sliceLabel.setLinkExtends(Integer.parseInt(linkextends));
        }
        sliceLabel.setLinkColor(Donut3DInflater.elementColor(linkColorElement));
        sliceLabel.setLinkStroke(Donut3DInflater.elementStroke(linkStrokeElement));
        sliceLabel.setLinkMarker(Donut3DInflater.elementBoolean(labelElement, "marker-enable"));
        sliceLabel.setLinkMarkerDrawColor(Donut3DInflater.elementColor(linkMarkerDrawColorElement));
        sliceLabel.setLinkMarkerFillColor(Donut3DInflater.elementColor(linkMarkerFillColorElement));
        if (margin != null && !margin.equals("undefined")) {
            sliceLabel.setMargin(Integer.parseInt(margin));
        }
        return sliceLabel;
    }

    private Donut3DRadialLabel inflateDonut3DSliceRadialLabel(Element labelElement) {
        Donut3DRadialLabel sliceLabel = new Donut3DRadialLabel();
        this.inflateDonut3DSliceLabel(sliceLabel, labelElement);
        String offsetRadius = Donut3DInflater.elementText(labelElement, "offsetRadius");
        if (offsetRadius != null && !offsetRadius.equals("undefined")) {
            sliceLabel.setOffsetRadius(Integer.parseInt(offsetRadius));
        }
        return sliceLabel;
    }

    private Donut3DPathLabel inflateDonut3DSlicePathLabel(Element labelElement) {
        Donut3DPathLabel sliceLabel = new Donut3DPathLabel();
        this.inflateDonut3DSliceLabel(sliceLabel, labelElement);
        String pathdivergence = Donut3DInflater.elementText(labelElement, "text-divergence");
        String textposition = Donut3DInflater.elementText(labelElement, "text-position");
        String pathside = Donut3DInflater.elementText(labelElement, "text-side");
        String pathname = Donut3DInflater.elementText(labelElement, "segment-path");
        Element textShaderElement = (Element)labelElement.getElementsByTagName("text-shader").item(0);
        sliceLabel.setDivergence(Donut3DPathLabel.parseDivergence(pathdivergence));
        sliceLabel.setFacetPathName(Donut3DPathLabel.Donut3DFacetPathName.parse(pathname));
        sliceLabel.setTextPosition(TextPath.TextPosition.parse(textposition));
        sliceLabel.setPathSide(TextPath.PathSide.parse(pathside));
        sliceLabel.setTextShader(InflaterUtil.elementShader(textShaderElement));
        return sliceLabel;
    }

    private void inflateDonut3DSliceLabel(AbstractDonut3DSliceLabel abstractLabel, Element labelElement) {
        String text = Donut3DInflater.elementText(labelElement, "text");
        Element textColorElement = (Element)labelElement.getElementsByTagName("textColor").item(0);
        String font = Donut3DInflater.elementText(labelElement, "font");
        String labelPaddingX = Donut3DInflater.elementText(labelElement, "text-padding-x");
        String labelPaddingY = Donut3DInflater.elementText(labelElement, "text-padding-y");
        String outlineRound = Donut3DInflater.elementText(labelElement, "outline-round");
        Element outlineColorElement = (Element)labelElement.getElementsByTagName("outline-color").item(0);
        Element outlineStrokeElement = (Element)labelElement.getElementsByTagName("outline-stroke").item(0);
        Element fillColorElement = (Element)labelElement.getElementsByTagName("fill-color").item(0);
        Element shaderElement = (Element)labelElement.getElementsByTagName("shader").item(0);
        String style = Donut3DInflater.elementText(labelElement, "style");
        abstractLabel.setLabel(text);
        abstractLabel.setLabelColor(Donut3DInflater.elementColor(textColorElement));
        abstractLabel.setLabelFont(InflaterUtil.parseFont(font));
        abstractLabel.setLabelPaddingX(Integer.parseInt(labelPaddingX));
        abstractLabel.setLabelPaddingY(Integer.parseInt(labelPaddingY));
        abstractLabel.setOutlineRound(Integer.parseInt(outlineRound));
        abstractLabel.setOutlineColor(Donut3DInflater.elementColor(outlineColorElement));
        abstractLabel.setOutlineStroke(Donut3DInflater.elementStroke(outlineStrokeElement));
        abstractLabel.setFillColor(Donut3DInflater.elementColor(fillColorElement));
        abstractLabel.setShader(InflaterUtil.elementShader(shaderElement));
        abstractLabel.setStyle(AbstractDonut3DSliceLabel.Style.parseStyle(style));
    }

    private AbstractDonut3DSliceLabel inflateDonut3DSliceLabel(Element labelElement) {
        String type = labelElement.getAttribute("xsi:type");
        if (type == null) {
            return null;
        }
        if (Donut3DLabelType.Donut3DRadialLabel.getDonut3DLabelType().equals(type)) {
            return this.inflateDonut3DSliceRadialLabel(labelElement);
        }
        if (Donut3DLabelType.Donut3DBorderLabel.getDonut3DLabelType().equals(type)) {
            return this.inflateDonut3DSliceBorderLabel(labelElement);
        }
        if (Donut3DLabelType.Donut3DPathLabel.getDonut3DLabelType().equals(type)) {
            return this.inflateDonut3DSlicePathLabel(labelElement);
        }
        return null;
    }

    private Donut3DSlice inflateDonut3DSlice(Element sliceElement) {
        String sliceName = Donut3DInflater.elementText(sliceElement, "name");
        String value = Donut3DInflater.elementText(sliceElement, "value");
        String divergence = Donut3DInflater.elementText(sliceElement, "divergence");
        Element colorElement = (Element)sliceElement.getElementsByTagName("slice-color").item(0);
        Donut3DSlice s = Donut3DToolkit.createDonut3DSlice(sliceName, Donut3DInflater.elementColor(colorElement), (double)Integer.parseInt(value), Integer.parseInt(divergence));
        NodeList labelListElement = sliceElement.getElementsByTagName("label");
        for (int i = 0; i < labelListElement.getLength(); ++i) {
            Element labelElement = (Element)labelListElement.item(i);
            AbstractDonut3DSliceLabel sliceLabel = this.inflateDonut3DSliceLabel(labelElement);
            if (sliceLabel == null) continue;
            s.addSliceLabel(sliceLabel);
        }
        return s;
    }

    private Donut3D inflateDonut3D(Element donut3DElement) {
        String x = Donut3DInflater.elementText(donut3DElement, "x");
        String y = Donut3DInflater.elementText(donut3DElement, "y");
        String innerRadius = Donut3DInflater.elementText(donut3DElement, "inner-radius");
        String outerRadius = Donut3DInflater.elementText(donut3DElement, "outer-radius");
        String thickness = Donut3DInflater.elementText(donut3DElement, "thickness");
        String tilt = Donut3DInflater.elementText(donut3DElement, "tilt");
        String startAngleDegree = Donut3DInflater.elementText(donut3DElement, "start-angle");
        String nature = Donut3DInflater.elementText(donut3DElement, "nature");
        Donut3D donut3D = Donut3DToolkit.createDonut3D("donut3d", Integer.parseInt(innerRadius), Integer.parseInt(outerRadius), Integer.parseInt(thickness));
        donut3D.setTilt(Integer.parseInt(tilt));
        donut3D.setCenterX(Double.parseDouble(x));
        donut3D.setCenterY(Double.parseDouble(y));
        donut3D.setStartAngleDegree(Integer.parseInt(startAngleDegree));
        donut3D.setDonut3DNature(Donut3D.Donut3DNature.parseNature(nature));
        NodeList slices = donut3DElement.getElementsByTagName("slice");
        for (int i = 0; i < slices.getLength(); ++i) {
            Element donut3DSliceElement = (Element)slices.item(i);
            Donut3DSlice donut3DSlice = this.inflateDonut3DSlice(donut3DSliceElement);
            donut3D.addSlice(donut3DSlice);
        }
        Element paintElement = (Element)donut3DElement.getElementsByTagName("paint").item(0);
        AbstractDonut3DPaint paint = this.inflateDonut3DPaint(paintElement);
        donut3D.setDonut3DPaint(paint);
        return donut3D;
    }

    @Override
    public Donut3DPlugin inflate(Element pluginElement) {
        Donut3DPlugin donut3dPlugin = new Donut3DPlugin();
        NodeList donut3DElementList = pluginElement.getElementsByTagName("donut3d");
        for (int i = 0; i < donut3DElementList.getLength(); ++i) {
            Element donut3DElement = (Element)donut3DElementList.item(i);
            Donut3D donut3d = this.inflateDonut3D(donut3DElement);
            donut3dPlugin.addDonut(donut3d);
        }
        return donut3dPlugin;
    }

    public static enum Donut3DLabelType {
        Donut3DRadialLabel("Donut3DRadialLabel"),
        Donut3DBorderLabel("Donut3DBorderLabel"),
        Donut3DPathLabel("Donut3DPathLabel");

        private String donut3DLabelType;

        private Donut3DLabelType(String donut3DLabelType) {
            this.donut3DLabelType = donut3DLabelType;
        }

        public String getDonut3DLabelType() {
            return this.donut3DLabelType;
        }
    }

    public static enum Donut3DPaintType {
        Donut3DDefaultPaint("Donut3DDefaultPaint");

        private String donut3DPaintType;

        private Donut3DPaintType(String donut3DPaintType) {
            this.donut3DPaintType = donut3DPaintType;
        }

        public String getDonut3DPaintType() {
            return this.donut3DPaintType;
        }
    }
}

