/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.function;

import java.awt.Color;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.StylePosition;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricMarkerPainter;
import org.jensoft.core.glyphmetrics.painter.fill.GlyphFill;
import org.jensoft.core.glyphmetrics.painter.marker.RoundMarker;
import org.jensoft.core.glyphmetrics.painter.marker.TicTacMarker;
import org.jensoft.core.plugin.function.source.FunctionNature;
import org.jensoft.core.plugin.function.source.SourceFunction;
import org.jensoft.core.plugin.function.source.UserSourceFunction;
import org.jensoft.core.x2d.binding.InflaterUtil;
import org.jensoft.core.x2d.binding.function.X2DFunctionElement;
import org.w3c.dom.Element;

public class FunctionUtil
implements X2DFunctionElement {
    public static GlyphMetric parseGlyphMetrics(Element glyphElement) {
        StylePosition sp;
        Double xv = InflaterUtil.elementDouble(glyphElement, "x-value");
        String text = InflaterUtil.elementText(glyphElement, "text");
        Color startColor = InflaterUtil.elementColor(glyphElement, "color-1");
        Color endColor = InflaterUtil.elementColor(glyphElement, "color-2");
        String stl = InflaterUtil.elementText(glyphElement, "style");
        Integer divergence = InflaterUtil.elementInteger(glyphElement, "divergence");
        Element markerElement = (Element)glyphElement.getElementsByTagName("marker").item(0);
        GlyphMetric glyph = new GlyphMetric();
        glyph.setValue(xv);
        glyph.setMetricsLabel(text);
        if (startColor != null && endColor == null) {
            glyph.setGlyphMetricFill(new GlyphFill(startColor, startColor));
        } else if (startColor != null && endColor != null) {
            glyph.setGlyphMetricFill(new GlyphFill(startColor, endColor));
        }
        if (divergence != null) {
            glyph.setDivergence(divergence);
        }
        if (stl != null && (sp = StylePosition.parse(stl)) != null) {
            glyph.setStylePosition(sp);
        }
        if (markerElement != null) {
            GlyphMetricMarkerPainter marker = FunctionUtil.inflateMarker(markerElement);
            glyph.setGlyphMetricMarkerPainter(marker);
        }
        return glyph;
    }

    public static GlyphMetricMarkerPainter inflateMarker(Element markerElement) {
        Color themeColor;
        String type = InflaterUtil.getType(markerElement);
        if (type.equals("RoundGlyphMarker")) {
            Color fillColor = InflaterUtil.elementColor(markerElement, "fill-color");
            if (fillColor != null) {
                RoundMarker roundMarker = new RoundMarker(fillColor);
                String radius = InflaterUtil.elementText(markerElement, "radius");
                Color drawColor = InflaterUtil.elementColor(markerElement, "draw-color");
                try {
                    if (radius != null && !radius.equals("undefined")) {
                        roundMarker.setRadius(Integer.parseInt(radius));
                    }
                    if (drawColor != null) {
                        roundMarker.setMarkerDrawColor(drawColor);
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                return roundMarker;
            }
        } else if (type.equals("TicTacGlyphMarker") && (themeColor = InflaterUtil.elementColor(markerElement, "theme-color")) != null) {
            TicTacMarker tictacMarker = new TicTacMarker(themeColor);
            try {
                String s = InflaterUtil.elementText(markerElement, "thickness");
                String d = InflaterUtil.elementText(markerElement, "divergence");
                String dl = InflaterUtil.elementText(markerElement, "divergence-left");
                String dr = InflaterUtil.elementText(markerElement, "divergence-right");
                if (s != null && !s.equals("undefined")) {
                    tictacMarker.setSize(Integer.parseInt(s));
                }
                if (d != null && !d.equals("undefined")) {
                    tictacMarker.setDivergence(Integer.parseInt(d));
                }
                if (dl != null && !dl.equals("undefined")) {
                    tictacMarker.setDivergenceLeft(Integer.parseInt(dl));
                }
                if (dr != null && !dr.equals("undefined")) {
                    tictacMarker.setDivergenceRight(Integer.parseInt(dr));
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return tictacMarker;
        }
        return null;
    }

    public static SourceFunction inflateSourceFunction(Element sourceElement) {
        if (sourceElement == null) {
            return null;
        }
        String type = InflaterUtil.getType(sourceElement);
        if (type == null) {
            return null;
        }
        UserSourceFunction.LineSource serie = null;
        if (type.equalsIgnoreCase("AffineSourceFunction")) {
            serie = FunctionUtil.inflateLineSource(sourceElement);
        }
        if (type.equalsIgnoreCase("InterpolateSourceFunction")) {
            serie = FunctionUtil.inflateSplineSource(sourceElement);
        }
        if (type.equalsIgnoreCase("RegressionSourceFunction")) {
            serie = FunctionUtil.inflateRegressionSource(sourceElement);
        }
        if (serie != null) {
            String id = InflaterUtil.elementText(sourceElement, "id");
            String name = InflaterUtil.elementText(sourceElement, "name");
            if (id != null) {
                serie.setId(id);
            }
            if (name != null) {
                serie.setName(name);
            }
        }
        return serie;
    }

    private static UserSourceFunction.LineSource inflateLineSource(Element sourceElement) {
        String sourcex = InflaterUtil.elementText(sourceElement, "source-x");
        String sourcey = InflaterUtil.elementText(sourceElement, "source-y");
        StringTokenizer tokenizerX = new StringTokenizer(sourcex, " ");
        ArrayList<Double> valuesAsDoubleX = new ArrayList<Double>();
        while (tokenizerX.hasMoreElements()) {
            String x = (String)tokenizerX.nextElement();
            valuesAsDoubleX.add(Double.parseDouble(x));
        }
        StringTokenizer tokenizerY = new StringTokenizer(sourcey, " ");
        ArrayList<Double> valuesAsDoubleY = new ArrayList<Double>();
        while (tokenizerY.hasMoreElements()) {
            String y = (String)tokenizerY.nextElement();
            valuesAsDoubleY.add(Double.parseDouble(y));
        }
        return new UserSourceFunction.LineSource(valuesAsDoubleX.toArray(new Double[valuesAsDoubleX.size()]), valuesAsDoubleY.toArray(new Double[valuesAsDoubleY.size()]));
    }

    private static UserSourceFunction.SplineSource inflateSplineSource(Element sourceElement) {
        String sourcex = InflaterUtil.elementText(sourceElement, "source-x");
        String sourcey = InflaterUtil.elementText(sourceElement, "source-y");
        Double delta = InflaterUtil.elementDouble(sourceElement, "delta");
        StringTokenizer tokenizerX = new StringTokenizer(sourcex, " ");
        ArrayList<Double> valuesAsDoubleX = new ArrayList<Double>();
        while (tokenizerX.hasMoreElements()) {
            String x = (String)tokenizerX.nextElement();
            valuesAsDoubleX.add(Double.parseDouble(x));
        }
        StringTokenizer tokenizerY = new StringTokenizer(sourcey, " ");
        ArrayList<Double> valuesAsDoubleY = new ArrayList<Double>();
        while (tokenizerY.hasMoreElements()) {
            String y = (String)tokenizerY.nextElement();
            valuesAsDoubleY.add(Double.parseDouble(y));
        }
        return new UserSourceFunction.SplineSource(valuesAsDoubleX.toArray(new Double[valuesAsDoubleX.size()]), valuesAsDoubleY.toArray(new Double[valuesAsDoubleY.size()]), FunctionNature.XFunction, (double)delta);
    }

    private static UserSourceFunction.RegressionSource inflateRegressionSource(Element sourceElement) {
        String sourcex = InflaterUtil.elementText(sourceElement, "source-x");
        String sourcey = InflaterUtil.elementText(sourceElement, "source-y");
        Double delta = InflaterUtil.elementDouble(sourceElement, "delta");
        StringTokenizer tokenizerX = new StringTokenizer(sourcex, " ");
        ArrayList<Double> valuesAsDoubleX = new ArrayList<Double>();
        while (tokenizerX.hasMoreElements()) {
            String x = (String)tokenizerX.nextElement();
            valuesAsDoubleX.add(Double.parseDouble(x));
        }
        StringTokenizer tokenizerY = new StringTokenizer(sourcey, " ");
        ArrayList<Double> valuesAsDoubleY = new ArrayList<Double>();
        while (tokenizerY.hasMoreElements()) {
            String y = (String)tokenizerY.nextElement();
            valuesAsDoubleY.add(Double.parseDouble(y));
        }
        return new UserSourceFunction.RegressionSource(valuesAsDoubleX.toArray(new Double[valuesAsDoubleX.size()]), valuesAsDoubleY.toArray(new Double[valuesAsDoubleY.size()]), (double)delta);
    }
}

