/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.grid;

import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import org.jensoft.core.plugin.grid.Grid;
import org.jensoft.core.plugin.grid.GridPlugin;
import org.jensoft.core.plugin.grid.manager.ModeledGridManager;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.grid.X2DGridElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class GridInflater<A extends GridPlugin<?>>
extends AbstractX2DPluginInflater<A>
implements X2DGridElement {
    protected Grid.GridOrientation getGridOrientation(Element plugin) {
        String orientation = GridInflater.elementText(plugin, "orientation");
        return Grid.GridOrientation.parse(orientation);
    }

    protected void completeFromAbstract(GridPlugin<?> abstratPlugin, Element pluginElement) {
        Color gridColor = GridInflater.elementColor(pluginElement, "grid-color");
        Stroke stroke = GridInflater.elementStroke(pluginElement, "grid-stroke");
        Font font = GridInflater.elementFont(pluginElement, "text-font");
        Color textColor = GridInflater.elementColor(pluginElement, "text-color");
        if (gridColor != null) {
            abstratPlugin.setGridColor(gridColor);
        }
        if (stroke != null) {
            abstratPlugin.setGridStroke(stroke);
        }
        if (font != null) {
            // empty if block
        }
        if (textColor != null) {
            // empty if block
        }
    }

    @X2DBinding(xsi="ModeledGrid", plugin=GridPlugin.ModeledGrid.class)
    public static class ModeledGridInflater
    extends GridInflater<GridPlugin.ModeledGrid> {
        @Override
        public GridPlugin.ModeledGrid inflate(Element plugin) {
            GridPlugin.ModeledGrid modeledMetrics = new GridPlugin.ModeledGrid(this.getGridOrientation(plugin));
            modeledMetrics.registerGridModels(ModeledGridManager.GridModelRangeCollections.YoctoYotta);
            this.completeFromAbstract(modeledMetrics, plugin);
            return modeledMetrics;
        }
    }

    @X2DBinding(xsi="StaticGridInflater", plugin=GridPlugin.StaticGrid.class)
    public static class StaticGridInflater
    extends GridInflater<GridPlugin.StaticGrid> {
        @Override
        public GridPlugin.StaticGrid inflate(Element plugin) {
            int gridCount = StaticGridInflater.elementInteger(plugin, "grid-count");
            GridPlugin.StaticGrid staticMetrics = new GridPlugin.StaticGrid(this.getGridOrientation(plugin), gridCount);
            this.completeFromAbstract(staticMetrics, plugin);
            return staticMetrics;
        }
    }

    @X2DBinding(xsi="MultiplierGrid", plugin=GridPlugin.MultiplierGrid.class)
    public static class MultiplierGridInflater
    extends GridInflater<GridPlugin.MultiplierGrid> {
        @Override
        public GridPlugin.MultiplierGrid inflate(Element plugin) {
            Double ref = MultiplierGridInflater.elementDouble(plugin, "ref");
            Double mul = MultiplierGridInflater.elementDouble(plugin, "multiplier");
            GridPlugin.MultiplierGrid multiplier = new GridPlugin.MultiplierGrid(ref, mul, this.getGridOrientation(plugin));
            this.completeFromAbstract(multiplier, plugin);
            return multiplier;
        }
    }

    @X2DBinding(xsi="FreeGrid", plugin=GridPlugin.FreeGrid.class)
    public static class FreeGridInflater
    extends GridInflater<GridPlugin.FreeGrid> {
        @Override
        public GridPlugin.FreeGrid inflate(Element plugin) {
            GridPlugin.FreeGrid free = new GridPlugin.FreeGrid(this.getGridOrientation(plugin));
            NodeList freeMetricsElements = plugin.getElementsByTagName("free-grid");
            for (int i = 0; i < freeMetricsElements.getLength(); ++i) {
                Element element = (Element)freeMetricsElements.item(i);
                Double value = FreeGridInflater.elementDouble(element, "value");
                Color gcolor = FreeGridInflater.elementColor(element, "color");
                Stroke stroke = FreeGridInflater.elementStroke(element, "stroke");
                String text = FreeGridInflater.elementText(element, "text");
                Color tcolor = FreeGridInflater.elementColor(element, "text-color");
                Font font = FreeGridInflater.elementFont(element, "text-font");
                Grid g = new Grid(this.getGridOrientation(plugin));
                g.setGridUserValue(value);
                g.setGridColor(gcolor);
                g.setAnnotation(text);
                g.setGridStroke(stroke);
                free.addGrid(g);
            }
            this.completeFromAbstract(free, plugin);
            return free;
        }
    }

    @X2DBinding(xsi="FlowGrid", plugin=GridPlugin.FlowGrid.class)
    public static class FlowGridInflater
    extends GridInflater<GridPlugin.FlowGrid> {
        @Override
        public GridPlugin.FlowGrid inflate(Element plugin) {
            Double flowStart = FlowGridInflater.elementDouble(plugin, "flow-start");
            Double flowEnd = FlowGridInflater.elementDouble(plugin, "flow-end");
            Double flowInterval = FlowGridInflater.elementDouble(plugin, "flow-interval");
            GridPlugin.FlowGrid flow = new GridPlugin.FlowGrid(flowStart, flowEnd, flowInterval, this.getGridOrientation(plugin));
            this.completeFromAbstract(flow, plugin);
            return flow;
        }
    }
}

