/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.legend;

import java.awt.Color;
import java.awt.Font;
import org.jensoft.core.plugin.legend.title.TitleLegend;
import org.jensoft.core.plugin.legend.title.TitleLegendConstraints;
import org.jensoft.core.plugin.legend.title.TitleLegendPlugin;
import org.jensoft.core.plugin.legend.title.painter.AbstractTitleLegendFill;
import org.jensoft.core.plugin.legend.title.painter.fil.TitleLegendDefaultFill;
import org.jensoft.core.plugin.legend.title.painter.fil.TitleLegendGradientFill;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.legend.X2DLegendElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@X2DBinding(xsi="LegendPlugin", plugin=TitleLegendPlugin.class)
public class LegendInflater
extends AbstractX2DPluginInflater<TitleLegendPlugin>
implements X2DLegendElement {
    private TitleLegend inflateLegend(Element element) {
        AbstractTitleLegendFill fill;
        String text = LegendInflater.elementText(element, "text");
        Font font = LegendInflater.elementFont(element, "font");
        Color themeColor = LegendInflater.elementColor(element, "theme-color");
        Color color1 = LegendInflater.elementColor(element, "color-1");
        Color color2 = LegendInflater.elementColor(element, "color-2");
        TitleLegendConstraints.LegendPosition position = TitleLegendConstraints.LegendPosition.parse(LegendInflater.elementText(element, "position"));
        TitleLegendConstraints.LegendAlignment alignment = TitleLegendConstraints.LegendAlignment.parse(LegendInflater.elementText(element, "alignment"));
        Float depth = LegendInflater.elementFloat(element, "depth");
        TitleLegend legend = new TitleLegend(text);
        if (font != null) {
            legend.setFont(font);
        }
        if (themeColor != null) {
            legend.setThemeColor(themeColor);
        }
        if (position != null && depth != null && alignment != null) {
            TitleLegendConstraints constraints = new TitleLegendConstraints(position, depth.floatValue(), alignment);
            legend.setConstraints(constraints);
        }
        if (color1 != null && color2 != null) {
            fill = new TitleLegendGradientFill(color1, color2);
            legend.setLegendFill(fill);
        } else if (color1 != null) {
            fill = new TitleLegendDefaultFill(color1);
            legend.setLegendFill(fill);
        } else {
            fill = new TitleLegendDefaultFill();
            legend.setLegendFill(fill);
        }
        return legend;
    }

    @Override
    public TitleLegendPlugin inflate(Element pluginElement) {
        TitleLegendPlugin plugin = new TitleLegendPlugin();
        NodeList legendElements = pluginElement.getElementsByTagName("legend");
        for (int i = 0; i < legendElements.getLength(); ++i) {
            Element element = (Element)legendElements.item(i);
            TitleLegend legend = this.inflateLegend(element);
            if (legend == null) continue;
            plugin.addLegend(legend);
        }
        return plugin;
    }
}

