/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.metrics;

import java.awt.Color;
import java.awt.Font;
import org.jensoft.core.plugin.metrics.AxisMetricsPlugin;
import org.jensoft.core.plugin.metrics.manager.TimeMetricsManager;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.metrics.X2DMetricsElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AxisMetricsInflater<A extends AxisMetricsPlugin<?>>
extends AbstractX2DPluginInflater<A>
implements X2DMetricsElement {
    protected AxisMetricsPlugin.Axis getAxis(Element plugin) {
        String axisName = AxisMetricsInflater.elementText(plugin, "axis");
        AxisMetricsPlugin.Axis axis = AxisMetricsPlugin.Axis.parse(axisName);
        return axis;
    }

    protected void completeFromAbstract(AxisMetricsPlugin<?> abstratPlugin, Element pluginElement) {
        Integer axisSpacing = AxisMetricsInflater.elementInteger(pluginElement, "axis-spacing");
        Boolean linePaint = AxisMetricsInflater.elementBoolean(pluginElement, "line-paint");
        Color lineColor = AxisMetricsInflater.elementColor(pluginElement, "line-color");
        Color markerColor = AxisMetricsInflater.elementColor(pluginElement, "marker-color");
        Color textColor = AxisMetricsInflater.elementColor(pluginElement, "label-color");
        Font f = AxisMetricsInflater.elementFont(pluginElement, "label-font");
        if (axisSpacing != null && axisSpacing > 0) {
            abstratPlugin.setAxisSpacing(axisSpacing);
        }
    }

    @X2DBinding(xsi="AxisTimeMetrics", plugin=AxisMetricsPlugin.TimeMetrics.class)
    public static class TimeMetricsInflater
    extends AxisMetricsInflater<AxisMetricsPlugin.TimeMetrics> {
        @Override
        public AxisMetricsPlugin.TimeMetrics inflate(Element plugin) {
            AxisMetricsPlugin.TimeMetrics timingMetrics = new AxisMetricsPlugin.TimeMetrics(this.getAxis(plugin));
            timingMetrics.registerTimeModel(new TimeMetricsManager.Minute1Model());
            timingMetrics.registerTimeModel(new TimeMetricsManager.Minute15Model());
            timingMetrics.registerTimeModel(new TimeMetricsManager.HourModel());
            timingMetrics.registerTimeModel(new TimeMetricsManager.Hour3Model());
            timingMetrics.registerTimeModel(new TimeMetricsManager.DayNumberModel());
            timingMetrics.registerTimeModel(new TimeMetricsManager.DayShortTextModel());
            timingMetrics.registerTimeModel(new TimeMetricsManager.DayLongTextModel());
            timingMetrics.registerTimeModel(new TimeMetricsManager.WeekModel());
            timingMetrics.registerTimeModel(new TimeMetricsManager.WeekDurationDurationModel());
            timingMetrics.registerTimeModel(new TimeMetricsManager.MonthModel());
            timingMetrics.registerTimeModel(new TimeMetricsManager.MonthDurationModel());
            this.completeFromAbstract(timingMetrics, plugin);
            return timingMetrics;
        }
    }

    @X2DBinding(xsi="AxisModeledMetrics", plugin=AxisMetricsPlugin.ModeledMetrics.class)
    public static class ModeledMetricsInflater
    extends AxisMetricsInflater<AxisMetricsPlugin.ModeledMetrics> {
        @Override
        public AxisMetricsPlugin.ModeledMetrics inflate(Element plugin) {
            AxisMetricsPlugin.ModeledMetrics modeledMetrics = new AxisMetricsPlugin.ModeledMetrics(this.getAxis(plugin));
            this.completeFromAbstract(modeledMetrics, plugin);
            return modeledMetrics;
        }
    }

    @X2DBinding(xsi="AxisStaticMetrics", plugin=AxisMetricsPlugin.StaticMetrics.class)
    public static class StaticMetricsInflater
    extends AxisMetricsInflater<AxisMetricsPlugin.StaticMetrics> {
        @Override
        public AxisMetricsPlugin.StaticMetrics inflate(Element plugin) {
            int metricsCount = StaticMetricsInflater.elementInteger(plugin, "metrics-count");
            AxisMetricsPlugin.StaticMetrics staticMetrics = new AxisMetricsPlugin.StaticMetrics(metricsCount, this.getAxis(plugin));
            this.completeFromAbstract(staticMetrics, plugin);
            return staticMetrics;
        }
    }

    @X2DBinding(xsi="FreeMetricsInflater", plugin=AxisMetricsPlugin.FreeMetrics.class)
    public static class FreeMetricsInflater
    extends AxisMetricsInflater<AxisMetricsPlugin.FreeMetrics> {
        @Override
        public AxisMetricsPlugin.FreeMetrics inflate(Element plugin) {
            String axisName = FreeMetricsInflater.elementText(plugin, "axis");
            AxisMetricsPlugin.Axis axis = AxisMetricsPlugin.Axis.parse(axisName);
            AxisMetricsPlugin.FreeMetrics free = new AxisMetricsPlugin.FreeMetrics(axis);
            NodeList freeMetricsElements = plugin.getElementsByTagName("free-metric");
            for (int i = 0; i < freeMetricsElements.getLength(); ++i) {
                Element element = (Element)freeMetricsElements.item(i);
                Double value = FreeMetricsInflater.elementDouble(element, "value");
                String text = FreeMetricsInflater.elementText(element, "text");
                if (text == null) {
                    free.addMetrics(value);
                    continue;
                }
                free.addMetrics(value, text);
            }
            this.completeFromAbstract(free, plugin);
            return free;
        }
    }

    @X2DBinding(xsi="FlowMetricsInflater", plugin=AxisMetricsPlugin.FlowMetrics.class)
    public static class FlowMetricsInflater
    extends AxisMetricsInflater<AxisMetricsPlugin.FlowMetrics> {
        @Override
        public AxisMetricsPlugin.FlowMetrics inflate(Element plugin) {
            Double flowStart = FlowMetricsInflater.elementDouble(plugin, "flow-start");
            Double flowEnd = FlowMetricsInflater.elementDouble(plugin, "flow-end");
            Double flowInterval = FlowMetricsInflater.elementDouble(plugin, "flow-interval");
            String axisName = FlowMetricsInflater.elementText(plugin, "axis");
            AxisMetricsPlugin.Axis axis = AxisMetricsPlugin.Axis.parse(axisName);
            AxisMetricsPlugin.FlowMetrics flow = new AxisMetricsPlugin.FlowMetrics(flowStart, flowEnd, flowInterval, axis);
            this.completeFromAbstract(flow, plugin);
            return flow;
        }
    }
}

