/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.pie;

import java.util.List;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PiePlugin;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieCompoundEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieCubicEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieLinearEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieRadialEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieReflectionEffect;
import org.jensoft.core.plugin.pie.painter.fill.AbstractPieFill;
import org.jensoft.core.plugin.pie.painter.fill.PieDefaultFill;
import org.jensoft.core.plugin.pie.painter.fill.PieRadialFill;
import org.jensoft.core.plugin.pie.painter.label.AbstractPieSliceLabel;
import org.jensoft.core.plugin.pie.painter.label.PieBorderLabel;
import org.jensoft.core.plugin.pie.painter.label.PieBoundLabel;
import org.jensoft.core.plugin.pie.painter.label.PiePathLabel;
import org.jensoft.core.plugin.pie.painter.label.PieRadialLabel;
import org.jensoft.core.x2d.binding.AbstractX2DPluginDeflater;
import org.jensoft.core.x2d.binding.DeflaterUtil;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.pie.X2DPieElement;
import org.w3c.dom.Element;

@X2DBinding(xsi="PiePlugin", plugin=PiePlugin.class)
public class PieDeflater
extends AbstractX2DPluginDeflater<PiePlugin>
implements X2DPieElement {
    @Override
    public Element deflate(PiePlugin plugin) {
        Element pluginElement = this.createPluginRootElement();
        List<Pie> pies = plugin.getPies();
        for (Pie pie : pies) {
            pluginElement.appendChild(this.deflatePie(pie));
        }
        return pluginElement;
    }

    private Element deflatePie(Pie pie) {
        Element pieElement = this.getX2dDocument().createElement("pie");
        if (pie.getName() == null) {
            pie.setName("pie");
        }
        pieElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "name", pie.getName()));
        pieElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "x", pie.getCenterX()));
        pieElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "y", pie.getCenterY()));
        pieElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "radius", pie.getRadius()));
        pieElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "start-angle", pie.getStartAngleDegree()));
        pieElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "nature", pie.getPieNature().name()));
        if (pie.getPieFill() != null) {
            pieElement.appendChild(this.deflatePieFill(pie.getPieFill()));
        }
        if (pie.getPieEffect() != null) {
            pieElement.appendChild(this.deflatePieEffect(pie.getPieEffect()));
        }
        for (PieSlice slice : pie.getSlices()) {
            pieElement.appendChild(this.deflatePieSlice(slice));
        }
        return pieElement;
    }

    private Element deflatePieSliceLabel(AbstractPieSliceLabel label) {
        if (label.getClass().getName().equals(PieRadialLabel.class.getName())) {
            return this.deflatePieSliceRadialLabel((PieRadialLabel)label);
        }
        if (label.getClass().getName().equals(PieBorderLabel.class.getName())) {
            return this.deflatePieSliceBorderLabel((PieBorderLabel)label);
        }
        if (label.getClass().getName().equals(PieBoundLabel.class.getName())) {
            return this.deflatePieSliceBoundLabel((PieBoundLabel)label);
        }
        if (label.getClass().getName().equals(PiePathLabel.class.getName())) {
            return this.deflatePieSlicePathLabel((PiePathLabel)label);
        }
        return null;
    }

    private Element deflatePieSlicePathLabel(PiePathLabel label) {
        Element labelElement = this.getX2dDocument().createElement("label");
        labelElement.setAttribute("xsi:type", "PiePathLabel");
        this.deflatePieSliceLabel(label, labelElement);
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "text-divergence", label.getDivergence()));
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "text-position", label.getTextPosition().name()));
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "text-side", label.getPathSide().name()));
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "segment-path", label.getPathName().name()));
        if (label.getShader() != null) {
            labelElement.appendChild(PieDeflater.createShaderElement(this.getX2dDocument(), "text-shader", label.getShader()));
        }
        return labelElement;
    }

    private Element deflatePieSliceBoundLabel(AbstractPieSliceLabel label) {
        Element labelElement = this.getX2dDocument().createElement("label");
        labelElement.setAttribute("xsi:type", "PieBoundLabel");
        this.deflatePieSliceLabel(label, labelElement);
        return labelElement;
    }

    private Element deflatePieSliceBorderLabel(PieBorderLabel label) {
        Element labelElement = this.getX2dDocument().createElement("label");
        labelElement.setAttribute("xsi:type", "PieBorderLabel");
        this.deflatePieSliceLabel(label, labelElement);
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "label-margin", label.getMargin()));
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "link-enable", Boolean.toString(label.isLink())));
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "link-style", label.getLinkStyle().name()));
        labelElement.appendChild(PieDeflater.createColorElement(this.getX2dDocument(), "link-color", label.getLinkColor()));
        labelElement.appendChild(PieDeflater.createStrokeElement(this.getX2dDocument(), "link-stroke", label.getLinkStroke()));
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "link-extends", label.getLinkExtends()));
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "marker-enable", Boolean.toString(label.isLinkMarker())));
        if (label.getLinkMarkerDrawColor() != null) {
            labelElement.appendChild(PieDeflater.createColorElement(this.getX2dDocument(), "marker-draw", label.getLinkMarkerDrawColor()));
        }
        if (label.getLinkMarkerFillColor() != null) {
            labelElement.appendChild(PieDeflater.createColorElement(this.getX2dDocument(), "marker-fill", label.getLinkMarkerFillColor()));
        }
        return labelElement;
    }

    private Element deflatePieSliceRadialLabel(PieRadialLabel label) {
        Element labelElement = this.getX2dDocument().createElement("label");
        labelElement.setAttribute("xsi:type", "PieRadialLabel");
        this.deflatePieSliceLabel(label, labelElement);
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "offset-radius", label.getOffsetRadius()));
        return labelElement;
    }

    private void deflatePieSliceLabel(AbstractPieSliceLabel abstractLabel, Element labelElement) {
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "text", abstractLabel.getLabel()));
        labelElement.appendChild(PieDeflater.createColorElement(this.getX2dDocument(), "text-color", abstractLabel.getLabelColor()));
        Element fontElement = PieDeflater.createFontElement(this.getX2dDocument(), "font", abstractLabel.getLabelFont());
        if (fontElement != null) {
            labelElement.appendChild(fontElement);
        }
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "text-padding-x", abstractLabel.getLabelPaddingX()));
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "text-padding-y", abstractLabel.getLabelPaddingY()));
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "outline-round", abstractLabel.getOutlineRound()));
        if (abstractLabel.getOutlineColor() != null) {
            labelElement.appendChild(PieDeflater.createColorElement(this.getX2dDocument(), "outline-color", abstractLabel.getOutlineColor()));
        }
        if (abstractLabel.getOutlineStroke() != null) {
            labelElement.appendChild(PieDeflater.createStrokeElement(this.getX2dDocument(), "outline-stroke", abstractLabel.getOutlineStroke()));
        }
        if (abstractLabel.getFillColor() != null) {
            labelElement.appendChild(PieDeflater.createColorElement(this.getX2dDocument(), "fill-color", abstractLabel.getFillColor()));
        }
        if (abstractLabel.getShadeFractions() != null && abstractLabel.getShadeColors() != null) {
            labelElement.appendChild(PieDeflater.createShaderElement(this.getX2dDocument(), "shader", new Shader(abstractLabel.getShadeFractions(), abstractLabel.getShadeColors())));
        }
        labelElement.appendChild(PieDeflater.createSingleElement(this.getX2dDocument(), "style", abstractLabel.getStyle().name()));
    }

    private Element deflatePieSlice(PieSlice slice) {
        Element sliceElement = this.getX2dDocument().createElement("slice");
        if (slice.getName() != null) {
            sliceElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "name", slice.getName()));
        }
        sliceElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "value", slice.getValue()));
        sliceElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "divergence", slice.getDivergence()));
        sliceElement.appendChild(DeflaterUtil.createColorElement(this.getX2dDocument(), "slice-color", slice.getThemeColor()));
        for (AbstractPieSliceLabel label : slice.getSliceLabels()) {
            sliceElement.appendChild(this.deflatePieSliceLabel(label));
        }
        return sliceElement;
    }

    private Element deflatePieLinearEffect(PieLinearEffect effect) {
        Element effectElement = this.getX2dDocument().createElement("effect");
        effectElement.setAttribute("xsi:type", "PieLinearEffect");
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "incidence-angle", effect.getIncidenceAngleDegree()));
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "offset-radius", effect.getOffsetRadius()));
        return effectElement;
    }

    private Element deflatePieCubicEffect(PieCubicEffect effect) {
        Element effectElement = this.getX2dDocument().createElement("effect");
        effectElement.setAttribute("xsi:type", "PieCubicEffect");
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "incidence-angle", effect.getIncidenceAngleDegree()));
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "offset-radius", effect.getOffsetRadius()));
        Element cubicKey = this.getX2dDocument().createElement("cubic-key");
        effectElement.appendChild(cubicKey);
        cubicKey.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "start-angle-delta", effect.getCubicKey().getStartAngleDelta()));
        cubicKey.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "end-angle-delta", effect.getCubicKey().getEndAngleDelta()));
        cubicKey.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "start-radius-fraction", effect.getCubicKey().getStartControlFractionRadius()));
        cubicKey.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "end-radius-fraction", effect.getCubicKey().getEndControlFractionRadius()));
        if (effect.getFrame() != null) {
            effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "cubic-frame", effect.getFrame().name()));
        }
        return effectElement;
    }

    private Element deflatePieRadialEffect(PieRadialEffect effect) {
        Element effectElement = this.getX2dDocument().createElement("effect");
        effectElement.setAttribute("xsi:type", "PieRadialEffect");
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "focus-angle", effect.getFocusAngle()));
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "focus-radius", effect.getFocusRadius()));
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "offset-radius", effect.getOffsetRadius()));
        return effectElement;
    }

    private Element deflatePieReflectionEffect(PieReflectionEffect effect) {
        Element effectElement = this.getX2dDocument().createElement("effect");
        effectElement.setAttribute("xsi:type", "PieReflectionEffect");
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "blur-enable", Boolean.toString(effect.isBlurEnabled())));
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "mask-opacity", effect.getOpacity()));
        effectElement.appendChild(DeflaterUtil.createSingleElement(this.getX2dDocument(), "reflection-length", effect.getLength()));
        return effectElement;
    }

    private Element deflatePieCompoundEffect(PieCompoundEffect effect) {
        Element effectElement = this.getX2dDocument().createElement("effect");
        effectElement.setAttribute("xsi:type", "PieCompoundEffect");
        AbstractPieEffect[] effects = effect.getEffects();
        for (int i = 0; i < effects.length; ++i) {
            Element e = this.deflatePieEffect(effects[i]);
            if (e == null) continue;
            effectElement.appendChild(e);
        }
        return effectElement;
    }

    private Element deflatePieFill(AbstractPieFill pieFill) {
        if (pieFill.getClass().getName().equals(PieDefaultFill.class.getName())) {
            Element effectElement = this.getX2dDocument().createElement("fill");
            effectElement.setAttribute("xsi:type", "PieLinearFill");
            return effectElement;
        }
        if (pieFill.getClass().getName().equals(PieRadialFill.class.getName())) {
            Element effectElement = this.getX2dDocument().createElement("fill");
            effectElement.setAttribute("xsi:type", "PieRadialFill");
            return effectElement;
        }
        return null;
    }

    private Element deflatePieEffect(AbstractPieEffect pieEffect) {
        if (pieEffect.getClass().getName().equals(PieCompoundEffect.class.getName())) {
            return this.deflatePieCompoundEffect((PieCompoundEffect)pieEffect);
        }
        if (pieEffect.getClass().getName().equals(PieLinearEffect.class.getName())) {
            return this.deflatePieLinearEffect((PieLinearEffect)pieEffect);
        }
        if (pieEffect.getClass().getName().equals(PieRadialEffect.class.getName())) {
            return this.deflatePieRadialEffect((PieRadialEffect)pieEffect);
        }
        if (pieEffect.getClass().getName().equals(PieReflectionEffect.class.getName())) {
            return this.deflatePieReflectionEffect((PieReflectionEffect)pieEffect);
        }
        if (pieEffect.getClass().getName().equals(PieCubicEffect.class.getName())) {
            return this.deflatePieCubicEffect((PieCubicEffect)pieEffect);
        }
        return null;
    }
}

