/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jensoft.core.x2d.X2DException;
import org.jensoft.core.x2d.lang.X2DSchemaErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class X2DSchema {
    private static X2DSchema schema;
    private Schema x2dSchema;

    private X2DSchema() throws X2DException {
        try {
            String lang = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory factory = SchemaFactory.newInstance(lang);
            this.x2dSchema = factory.newSchema(new StreamSource(X2DSchema.class.getResourceAsStream("x2d.xsd")));
        }
        catch (SAXException e) {
            throw new X2DException("X2D initialization Error", e);
        }
    }

    public static X2DSchema getInstance() throws X2DException {
        if (schema == null) {
            schema = new X2DSchema();
        }
        return schema;
    }

    public Schema getX2DSchema() {
        return this.x2dSchema;
    }

    public static void validX2D(File x2dViewFile, X2DSchemaErrorHandler handler) throws X2DException {
        try {
            StreamSource source = new StreamSource(x2dViewFile);
            Validator validator = X2DSchema.getInstance().getX2DSchema().newValidator();
            validator.setErrorHandler(handler);
            validator.validate(source);
        }
        catch (SAXException e) {
            throw new X2DException("valid failed with exception : " + e.getMessage());
        }
        catch (IOException e) {
            throw new X2DException("valid failed with exception : " + e.getMessage());
        }
    }

    public static void validX2D(InputStream x2dInputStream, X2DSchemaErrorHandler handler) throws X2DException {
        try {
            StreamSource source = new StreamSource(x2dInputStream);
            Validator validator = X2DSchema.getInstance().getX2DSchema().newValidator();
            validator.setErrorHandler(handler);
            validator.validate(source);
        }
        catch (SAXException e) {
            throw new X2DException("valid failed with exception : " + e.getMessage());
        }
        catch (IOException e) {
            throw new X2DException("valid failed with exception : " + e.getMessage());
        }
    }

    public static void validX2D(String xmlSource, X2DSchemaErrorHandler handler) throws X2DException {
        try {
            StreamSource source = new StreamSource(new StringReader(xmlSource));
            Validator validator = X2DSchema.getInstance().getX2DSchema().newValidator();
            validator.setErrorHandler(handler);
            validator.validate(source);
        }
        catch (SAXException e) {
            throw new X2DException("valid failed with exception : " + e.getMessage());
        }
        catch (IOException e) {
            throw new X2DException("valid failed with exception : " + e.getMessage());
        }
    }

    public static void validX2D(Document xmlDocument, X2DSchemaErrorHandler handler) throws X2DException {
        try {
            DOMSource source = new DOMSource(xmlDocument.getDocumentElement());
            Validator validator = X2DSchema.getInstance().getX2DSchema().newValidator();
            validator.setErrorHandler(handler);
            validator.validate(source);
        }
        catch (SAXException e) {
            throw new X2DException("valid failed with exception : " + e.getMessage());
        }
        catch (IOException e) {
            throw new X2DException("valid failed with exception : " + e.getMessage());
        }
    }

    public static Document parseX2D(String xmlSource) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(new InputSource(new StringReader(xmlSource)));
        return document;
    }

    public static Document parseX2D(File x2dFile) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(x2dFile);
        return document;
    }

    public static Document parseX2D(InputStream x2dInputStream) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(x2dInputStream);
        return document;
    }
}

